/***********************************************************************************
 File:		BssManager_VapManager.h
 Module:		Vap manager -  sub module of BSSmanager 	
 Purpose: 		
 Description:   
 
************************************************************************************/


#ifndef BSS_MANAGER_VAP_MANAGER_H
#define BSS_MANAGER_VAP_MANAGER_H

/****************************************************************************/
/* Includes                                                                 */
/****************************************************************************/


#include "OSAL_Kmsg.h"
#include "BSSmanager_API.h"





/****************************************************************************/
/* Defines										                                                                 */
/****************************************************************************/

typedef enum
{
	VAP_MANAGER_INACTIVE_STATE,
	VAP_MANAGER_STARTING_STATE,
	VAP_MANAGER_POST_STARTING_STATE,
	VAP_MANAGER_WAITING_FOR_SET_BSS_STATE,
	VAP_MANAGER_SETTING_BSS_STATE,
	VAP_MANAGER_POST_SET_BSS_STATE,
	VAP_MANAGER_WAITING_FOR_SET_WMM_PARAMS,
	VAP_MANAGER_SETTING_WMM_PARAMS_STATE,
	VAP_MANAGER_POST_VAP_ACTIVATION_STATE,
	VAP_MANAGER_ACTIVE_STATE,
	VAP_MANAGER_STOPPING_TRAFFIC_STATE,
	VAP_MANAGER_POST_STOP_TRAFFIC_STATE,
	VAP_MANAGER_WAITING_FOR_REMOVE_STATE,
	VAP_MANAGER_REMOVING_STATE,
	VAP_MANAGER_POST_REMOVING_STATE,
	VAP_MANAGER_POST_RATES_SETTING,
}vapManagerState_e;

/****************************************************************************/
/* Data Types                                                               */
/****************************************************************************/

typedef struct 
{
#if defined(ENET_INC_ARCH_WAVE600)
	uint8 numOfActiveVaps[NUM_OF_CONFIGURATION_MANAGER_BANDS];
#else
	uint8 numOfActiveVaps;
#endif
} bssManagerVapsDb_t;


typedef struct 
{
	K_MSG*				pStoredMsg;  		/*The driver message we are currently handling*/	
	uint32				pendingBitmap;		/*pending clients for confirmation*/
} VAP_MANAGER_CONFIRMATION_ELEMENT;


typedef struct 
{
	vapManagerState_e 					state;											/*state*/
	VAP_MANAGER_CONFIRMATION_ELEMENT	eventConfirmation[TOTAL_VAP_MANAGER_EVENTS];	/* event confirmation db */
} VAP_MANAGER_DB_ELEMENT;


/*Registration Client Info*/
typedef struct BssManagerVapManagerRegClient_s
{
	uint16 taskId;
	uint16 msgId;
} BssManagerVapManagerRegClient_t;


/*Registration DB*/
typedef struct BssManagerVapManagerRegDb_s
{
	/*Number of Clients*/
	uint8				  			numClients[TOTAL_VAP_MANAGER_EVENTS];
	/*Client DB*/
	BssManagerVapManagerRegClient_t clientDb[TOTAL_VAP_MANAGER_EVENTS][BSS_MANAGER_VAP_MANAGER_MAX_CLIENTS];
} BssManagerVapManagerRegDb_t;








/****************************************************************************/
/* Functions Prototypes                                                     */
/****************************************************************************/

void BssManager_VapManager_Init(void); 
void BssManager_VapManager_SetState(uint8 vapId, vapManagerState_e vapManagerNewState);
void BssManager_VapManager_AddVap(K_MSG* psMsg); 
void BssManager_VapManager_RemoveVap(K_MSG* psMsg);
void BssManager_VapManager_EventHandlerConfirm(K_MSG* psMsg);
void BssManager_VapManager_StopTraffic(K_MSG* psMsg);
void BssManager_VapManager_SetBss(K_MSG* psMsg);
void BssManager_VapManager_SetWmmParams(K_MSG* psMsg); 




#endif //BSS_MANAGER_VAP_MANAGER_H

