/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      Firmware: Upper MAC
 **
 ** MODULE:         BSS Manager
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2010/10/27 $
 **
 ** AUTHOR:         
 **
 ** DESCRIPTION:    BSS Manager upper MAC API
 **
 ** LAST MODIFIED BY:   
 **
 ****************************************************************************
  ****************************************************************************/

/****************************************************************************/
/* Includes                                                                 */
/****************************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Utils_Api.h"
#include "OSAL_Api.h"
#include "BSSmanager_API.h"
#include "BssManager_VapManager.h"
#include "BssManager_StaManager.h"
#include "bss_manage_task.h"
#include "ShramVapDatabase.h"
#include "VapDatabase_Api.h"
#include "ProcessManager_Api.h"
#include "DmaManager_Api.h"
#include "EventsManager_api.h"
#include "shram_man_msgs.h"
#include "BeaconHandler_api.h"
#include "init_ifmsg.h"
#include "DmaManager_Api.h"
#include "EventsManager_api.h"
#include "ServicesHandler_Api.h"
#include "queue_utility.h"


/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_BSS_MANAGER
#define LOG_LOCAL_FID 0


/****************************************************************************/
/* Defines                                                                  */
/****************************************************************************/

/****************************************************************************/
/* Data Types                                                               */
/****************************************************************************/

/****************************************************************************/
/* Functions Prototypes                                                     */
/****************************************************************************/
static void bssManagerSetBeaconTemplate (K_MSG* psMsg);
static void BSSmanager_BeaconTemplateDmaDone(K_MSG* psMsg);
static void bssManagerEventHandlerConfirm(K_MSG* psMsg); 



/****************************************************************************/
/* Static Data                                                              */
/****************************************************************************/
/* Table of events and their corresponding functions in BSSmanager task */
static const FunctionEntry_t afpTaskTable[TASK_BSS_MANAGER_END-TASK_BSS_MANAGER_START]=
{
	{BssManager_VapManager_AddVap,		DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_BSS_ADD_VAP_REQ)},
	{BssManager_VapManager_SetBss,		DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_BSS_SET_BSS_REQ)},
	{BssManager_VapManager_SetWmmParams, DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_SET_WMM_REQ)},
	{BssManager_VapManager_RemoveVap,	DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_BSS_REMOVE_VAP_REQ)}, 
	{bssManagerSetBeaconTemplate,		DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_SET_BEACON_TEMPLATE_REQ)},
	{BssManager_VapManager_StopTraffic,	DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_STOP_VAP_TRAFFIC_REQ)},
	{bssManagerEventHandlerConfirm, 	DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM)},
	{BSSmanager_BeaconTemplateDmaDone,	DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_DMA_TEMPLATE_DONE)},
	{BssManager_AddSta,					DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_STA_MANAGER_ADD_STA)},
	{BssManager_SetFilter,				DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_STA_MANAGER_SET_FILTER)},
	{BssManager_StopTraffic,			DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_STA_MANAGER_STOP_TRAFFIC)},
	{BssManager_CloseSta,				DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_STA_MANAGER_CLOSE_STA)},
	{bssManagerEventHandlerConfirm,		DOUBLE_CHECK_MSG_TYPE(BSS_MANAGER_STA_MANAGER_REG_CFM)},
	{BssManager_VapManager_StartAddVapProcess,			DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_START_ADD_VAP_PROCESS)},
	{BssManager_VapManager_FinalizeAddVapProcess,		DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_FINALIZE_ADD_VAP_PROCESS)},
	{BssManager_VapManager_StartSetBssProcess,			DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_START_SET_BSS_PROCESS)},
	{BssManager_VapManager_FinalizeSetBssProcess,		DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_FINALIZE_SET_BSS_PROCESS)},
	{BssManager_VapManager_StartSetWmmParamsProcess,	DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_START_SET_WMM_PARAMS_PROCESS)},
	{BssManager_VapManager_FinalizeSetWmmParamsProcess,	DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_FINALIZE_SET_WMM_PARAMS_PROCESS)},
	{BssManager_VapManager_StartRemoveVapProcess,		DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_START_REMOVE_VAP_PROCESS)},
	{BssManager_VapManager_FinalizeRemoveVapProcess,	DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_FINALIZE_REMOVE_VAP__PROCESS)},
	{BssManager_StartActivateProcess,					DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_START_ACTIVATE_PROCESS)},
	{BssManager_FinalizeActivateProcess,				DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_FINALIZE_ACTIVATE_PROCESS)},
};


/****************************************************************************/
/****************************************************************************/
/* Public Function                                                          */
/****************************************************************************/
/****************************************************************************/


/**********************************************************************************

BssManager_Init 

Description:
	------------
	initialize the BSSmanager module
	
Input:
-----
	void 
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void BssManager_Init(void) 
{
	VapDB_Init();
	BssManager_StaManagerInit();
	BssManager_VapManager_Init(); 
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif


/**********************************************************************************

BssManager_Task 

Description:
	------------
	entry point for BSSmanager module task
	
Input:
-----
	void 
		
Output:
-------
	

Returns:
--------
	void - 
	
**********************************************************************************/
void BssManager_Task(K_MSG* psMsg)
{
	/* Use common task switching and Table */
	vTaskDispatcher(psMsg, afpTaskTable, TASK_BSS_MANAGER_START, TASK_BSS_MANAGER_END);
}

/**********************************************************************************

BssManager_StartActivateProcess


Description:
	------------
	
	
Input:
-----
	None
		
Output:
-------
	

Returns:
--------
	
	
**********************************************************************************/
void BssManager_StartActivateProcess(K_MSG *psMsg)
{
	ProcessManagerReturnParams_t* processmangerReturnParams= (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);

	ILOG2_V("BssManager_StartActivateProcess");
	
	ASSERT(processmangerReturnParams->processStatus == PROCESS_STATUS_REQUEST_ACCEPTED);
	
	vBSS_Initialise(psMsg->header.vapId);
}

/**********************************************************************************

BssManager_FinalizeActivateProcess




Description:
	------------
	
	
Input:
-----

		
Output:
-------
	

Returns:
--------
	
	
**********************************************************************************/
void BssManager_FinalizeActivateProcess(K_MSG *psMsg)
{
	ProcessManagerReturnParams_t *processmangerReturnParams= (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG*	pStoredMsg = (K_MSG*)processmangerReturnParams->requesterParams;

	ASSERT(processmangerReturnParams->processStatus == PROCESS_STATUS_EXECUTION_COMPLETED);

	OSAL_SEND_MESSAGE(UMI_BSS_PRE_ACTIVATE_CFM, TASK_UM_IF_TASK, pStoredMsg, pStoredMsg->header.vapId);
}

/****************************************************************************/
/****************************************************************************/
/* Static Functions                                                         */
/****************************************************************************/
/****************************************************************************/

/**********************************************************************************

bssManagerEventHandlerConfirm

Description:	calls the VAP/STA manager confirm handler 

Input:

Output:

Returns:  void 

	
**********************************************************************************/
static void bssManagerEventHandlerConfirm(K_MSG* psMsg)
{
	if(psMsg->header.tKMsgType == BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM)
	{
		BssManager_VapManager_EventHandlerConfirm(psMsg); 
	}
	
	else/* if (psMsg->header.tKMsgType == BSS_MANAGER_STA_MANAGER_REGISTERED_MODULE_CONFIRM))*/ 
	{
		BssManager_StaManagerRegConfirm(psMsg); 
	}
}

/***************************************************************************************************
 BssManager_SetBeaconTemplate

Description:  Get request to set / change beacon template from host. Activate DMA to copy the template.
	
****************************************************************************************************/
static void bssManagerSetBeaconTemplate(K_MSG* psMsg)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(BssManagerSetTemplateReq_t));
	BssManagerSetTemplateReq_t *SetTemplateReqMsg_p = (BssManagerSetTemplateReq_t *)pK_MSG_DATA(kMsg_p);

#if defined (ENET_INC_ARCH_WAVE600)
	UMI_BEACON_SET* beaconTemplateParams_p = (UMI_BEACON_SET*)pK_MSG_DATA(psMsg);
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	beaconTemplateParams_p->u8vapIndex = psMsg->header.vapId;
#endif
	
	SetTemplateReqMsg_p->psMsg = psMsg;
	OSAL_SEND_MESSAGE(PAC_MANAGER_SET_BEACON_TEMPLATE_REQ, TASK_PAC_MANAGER, kMsg_p, psMsg->header.vapId);		
}

static void BSSmanager_BeaconTemplateDmaDone(K_MSG* psMsg)
{
	UNUSED_PARAM(psMsg);
	
}

