/***********************************************************************************
File:		  BssManager_VapManger.c
Module:	  Bssmanger
Purpose: 	  
Description: 	

************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "ErrorHandler_Api.h"
#include "BssManager_VapManager.h"
#include "BSSmanager_API.h"
#include "VapDatabase_Api.h"
#include "init_ifmsg.h"
#include "ProcessManager_Api.h"
#include "ServicesHandler_Api.h"
#include "Dut_Api.h"
#include "loggerAPI.h"
#include "ServicesHandler_Api.h"
#include "Pac_Api.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID GLOBAL_GID_BSS_MANAGER
#define LOG_LOCAL_FID 2


#define PROCESS_ADD_FIRST_VAP_PRE_SERVICES_BITMAP		(1 << SERVICE_ID_PAUSE_ALL_TX)	
#if defined(ENET_INC_ARCH_WAVE600)
#define PROCESS_ADD_FIRST_VAP_POST_SERVICES_BITMAP		(1 << SERVICE_ID_RESUME_ALL_TX)	
#else
#define PROCESS_ADD_FIRST_VAP_POST_SERVICES_BITMAP		(1 << SERVICE_ID_RESUME_ALL)
#endif
#define PROCESS_ADD_VAP_PRE_SERVICES_BITMAP				(1 << SERVICE_ID_PAUSE_ALL)	
#define PROCESS_ADD_VAP_POST_SERVICES_BITMAP			(1 << SERVICE_ID_RESUME_ALL)
#define PROCESS_SET_BSS_PRE_SERVICES_BITMAP				(1 << SERVICE_ID_PAUSE_ALL)
#define PROCESS_SET_BSS_POST_SERVICES_BITMAP			(1 << SERVICE_ID_RESUME_ALL)
#define PROCESS_SET_WMM_PARAMS_PRE_SERVICES_BITMAP		(1 << SERVICE_ID_PAUSE_ALL)
#define PROCESS_SET_WMM_PARAMS_POST_SERVICES_BITMAP		(1 << SERVICE_ID_RESUME_ALL)
#define PROCESS_REMOVE_VAP_PRE_SERVICES_BITMAP			(1 << SERVICE_ID_PAUSE_ALL)
#define PROCESS_REMOVE_VAP_POST_SERVICES_BITMAP			(1 << SERVICE_ID_RESUME_ALL)
#if defined(ENET_INC_ARCH_WAVE600)
#define PROCESS_REMOVE_LAST_VAP_PRE_SERVICES_BITMAP		(1 << SERVICE_ID_PAUSE_ALL_TX)
#else
#define PROCESS_REMOVE_LAST_VAP_PRE_SERVICES_BITMAP		(1 << SERVICE_ID_PAUSE_ALL)
#endif
#define PROCESS_REMOVE_LAST_VAP_POST_SERVICES_BITMAP	(1 << SERVICE_ID_RESUME_ALL_TX)


#if defined(ENET_INC_ARCH_WAVE600)
#define BSS_MANAGER_VAP_MANAGER_STATE_DEBUG
#endif

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#if defined (BSS_MANAGER_VAP_MANAGER_STATE_DEBUG)
#define BSS_MANAGER_VAP_MANAGER_MAX_STATE_DEBUG		256
#endif

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

#if defined (BSS_MANAGER_VAP_MANAGER_STATE_DEBUG)
typedef struct BssManager_VapManagerStateDebug_s {
	uint32				tsf;
	uint8				vapId;
	vapManagerState_e	prevState;
	vapManagerState_e	newState;
} BssManager_VapManagerStateDebug_t;
#endif

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

VAP_MANAGER_DB_ELEMENT VapManagerDb[HW_NUM_OF_VAPS]; 

bssManagerVapsDb_t bssManagerVapsDb;


/*Local Databases*/
/*Registration DB*/
static BssManagerVapManagerRegDb_t VapManager_RegDb = 
{
	//numClients[TOTAL_VAP_MANAGER_EVENTS];
	{
		0, // VAP_MANAGER_ADD_VAP,
		0, // VAP_MANAGER_POST_VAP_ADDITION,
		0, // VAP_MANAGER_SET_BSS,
		0, // VAP_MANAGER_POST_SET_BSS,		
		0, // VAP_MANAGER_SET_WMM_PARAMS,
		0, // VAP_MANAGER_POST_VAP_ACTIVATION, 
		0, // VAP_MANAGER_REMOVE_VAP,
		0, // VAP_MANAGER_POST_VAP_REMOVAL,
		0, // VAP_MANAGER_STOP_TRAFFIC, 
		0, // VAP_MANAGER_POST_STOP_TRAFFIC,
	},
	//clientDb[TOTAL_VAP_MANAGER_EVENTS][BSS_MANAGER_VAP_MANAGER_MAX_CLIENTS];
	{
		//VAP_MANAGER_ADD_VAP
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	CHANNEL_SWITCH_MANAGER_VAP_MANAGER_REGISTRATION_EVENT_ADD_VAP			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						COC_ADD_VAP						},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						DUT_ADD_VAP						},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK_CDB_MANAGER,			HDK_CDB_MAN_ADD_VAP_REQ			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				PAC_MANAGER_ADD_VAP_REQ			},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				RX_MANAGER_ADD_VAP				},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				ENCRYPTION_ADD_VAP				},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		STATISTICS_MANAGER_ADD_VAP		},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				TS_MANAGER_ADD_VAP				},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		//VAP_MANAGER_POST_VAP_ADDITION
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				PAC_MANAGER_POST_ADD_VAP_REQ	},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				TX_MANAGER_POST_VAP_ADDITION	},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			AGER_EMULATOR_ADD_VAP			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		//VAP_MANAGER_SET_BSS
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				CSA_MANAGER_VAP_OPEN			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						HIM_VAP_SET_BSS					},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				PAC_MANAGER_SET_BSS_REQ			},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			LINK_ADAPTATION_ADD_VAP			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG						},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				SMPS_ADD_VAP					},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			TRAINING_MANAGER_SET_BSS		},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    TWT_MANAGER_ADD_VAP			    },	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		//VAP_MANAGER_POST_SET_BSS
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						OSAL_TASK_UNUSED_MSG 				},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				OSAL_TASK_UNUSED_MSG 			},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG 			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				TX_MANAGER_ADD_VAP				},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		//VAP_MANAGER_SET_WMM_PARAMS
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
#if defined(ENET_INC_ARCH_WAVE600)
			{TASK_PAC_MANAGER,				PAC_MANAGER_UPDATE_VAP_TIMING_PARAMETERS},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
#else
			{TASK_PAC_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
#endif
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#else
			{TASK_TX_MANAGER,				TX_MANAGER_SET_WMM_PARAMETERS	},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#endif
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
            {TASK_TWT_MANAGER,              OSAL_TASK_UNUSED_MSG            },  // BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},
		
		//VAP_MANAGER_POST_VAP_ACTIVATION
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				CTS_MANAGER_VAP_OPEN			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						HDK_POST_ACTIVATION_VAP			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						HIM_POST_VAP_ACTIVATION			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				PAC_MANAGER_POST_VAP_ACTIVATION	},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				TX_MANAGER_ENABLE_VAP			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		//VAP_MANAGER_REMOVE_VAP
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	CHANNEL_SWITCH_MANAGER_VAP_MANAGER_REGISTRATION_EVENT_POST_REMOVE_VAP			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						COC_REMOVE_VAP					},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				CSA_MANAGER_VAP_CLOSE			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				CTS_MANAGER_VAP_CLOSE			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						DUT_REMOVE_VAP					},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK_CDB_MANAGER,			HDK_CDB_MAN_REMOVE_VAP_REQ		},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				PAC_MANAGER_REMOVE_VAP_REQ		},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			LINK_ADAPTATION_REMOVE_VAP		},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						QOS_REMOVE_VAP					},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				RX_MANAGER_REMOVE_VAP			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				ENCRYPTION_REMOVE_VAP			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				SMPS_REMOVE_VAP					},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		STATISTICS_MANAGER_REMOVE_VAP	},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				TS_MANAGER_REMOVE_VAP			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		//VAP_MANAGER_POST_VAP_REMOVAL
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		// VAP_MANAGER_STOP_TRAFFIC
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						HIM_VAP_STOP_TRAFFIC			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				TX_MANAGER_DISABLE_VAP			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			AGER_EMULATOR_REMOVE_VAP		},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			TRAINING_MANAGER_STOP_TRAFFIC	},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},

		// VAP_MANAGER_POST_STOP_TRAFFIC
		{
			{TASK_CHANNEL_SWITCH_MANAGER,	OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CHANNEL_SWITCH_MANAGER_CLIENT
			{TASK_COC,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_COC_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CSA_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_CTS_MANAGER_CLIENT
			{TASK_DUT,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_DUT_CLIENT
			{TASK_HDK,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HDK_CLIENT
			{TASK_HIM,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_HIM_CLIENT
			{TASK_PAC_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_PAC_MANAGER_CLIENT
			{TASK_LINK_ADAPTATION,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_LINK_ADAPTATION_CLIENT
			{TASK_QOS,						OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_QOS_CLIENT
			{TASK_RX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_RX_MANAGER_CLIENT
			{TASK_ENCRYPTION,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SEC_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_SMPS_MANAGER_CLIENT
			{TASK_STATISTICS_MANAGER,		OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_STATISTICS_MANAGER_CLIENT
			{TASK_TS_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TS_MANAGER_CLIENT
			{TASK_TX_MANAGER,				OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TX_MANAGER_CLIENT
#ifdef USE_AGER_EMULATOR
			{TASK_AGER_EMULATOR,			OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_AGER_CLIENT
#endif
			{TASK_GROUP_MANAGER,			OSAL_TASK_UNUSED_MSG			},	//BSS_MANAGER_VAP_MANAGER_TRAINING_MANAGER_CLIENT
#ifdef ENET_INC_ARCH_WAVE600
			{TASK_TWT_MANAGER,			    OSAL_TASK_UNUSED_MSG			},	// BSS_MANAGER_VAP_MANAGER_TWT_MANAGER_CLIENT
#endif
		},
	}
};

typedef struct BssManager_VapManagerProcessEntry_s
{
	bool			inProgress;
	FwUtils_queue_t queue;	
} BssManager_VapManagerProcessEntry_t;

typedef struct BssManager_VapManagerProcessDb_s
{
	BssManager_VapManagerProcessEntry_t addVap;
	BssManager_VapManagerProcessEntry_t setBss;
	BssManager_VapManagerProcessEntry_t setWmm;
	BssManager_VapManagerProcessEntry_t removeVap;
} BssManager_VapManagerProcessDb_t;


BssManager_VapManagerProcessDb_t BssManager_VapManagerProcessDb;

#if defined (BSS_MANAGER_VAP_MANAGER_STATE_DEBUG)
BssManager_VapManagerStateDebug_t BssManager_VapManagerStateDebug[BSS_MANAGER_VAP_MANAGER_MAX_STATE_DEBUG];
uint32 BssManager_VapManagerStateDebugIdx = 0;
#endif


/****************************************************************************/
/* Static Functions                                                         */
/****************************************************************************/
/****************************************************************************/

static void vapManagerDispatcher(K_MSG* psMsg, vapManagerEvents_e event); 
static void vapManagerPostConfirmationHandler(vapManagerEvents_e eventIndx, uint8 vapId);
static void bssManagerVapManagerPostVapActivation(K_MSG* psMsg); 
static void bssManagerVapManagerPostVapRemoval(K_MSG* psMsg);
static void bssManagerVapManagerPostVapAddition(K_MSG* psMsg);
static void BssManager_VapManagerScheduleAddVap(K_MSG* psMsg);
static void BssManager_VapManagerScheduleSetBss(K_MSG* psMsg);
static void	BssManager_VapManagerScheduleSetWmm(K_MSG *psMsg);
static void	BssManager_VapManagerScheduleRemoveVap(K_MSG *psMsg);



/*---------------------------------------------------------------------------------
/						Debuf Section									
/----------------------------------------------------------------------------------*/


static void BssManager_VapManagerScheduleAddVap(K_MSG* psMsg)
{
	K_MSG *processManagerMsg;
	ProcessRequestParams_t *processRequestParams;
	UMI_ADD_VAP* addVapStructurePtr; 
	uint8 vapId;  
#if defined(ENET_INC_ARCH_WAVE600)
	uint8 bandId;
#endif

	BssManager_VapManagerProcessDb.addVap.inProgress = TRUE;
	addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(psMsg);	
	vapId = addVapStructurePtr->vapId; 	
	/* Schedule Process*/	
	processManagerMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(processManagerMsg);
	processRequestParams->processId 				= PROCESS_ID_ADD_VAP;
	processRequestParams->startProcessMsg			= BSS_MANAGE_BSS_START_ADD_VAP_PROCESS;
	processRequestParams->endProcessMsg 			= BSS_MANAGE_BSS_FINALIZE_ADD_VAP_PROCESS;
	processRequestParams->requesterParams			= psMsg;
#if defined(ENET_INC_ARCH_WAVE600)
	bandId = ConfigurationManager_GetBandForVap(vapId);
	if (bssManagerVapsDb.numOfActiveVaps[bandId] != 0)
#else
	if (bssManagerVapsDb.numOfActiveVaps != 0)
#endif
	{
		processRequestParams->preProcessServiceBitmap		= PROCESS_ADD_VAP_PRE_SERVICES_BITMAP;
		processRequestParams->postProcessServiceBitmap		= PROCESS_ADD_VAP_POST_SERVICES_BITMAP;
	}
	else
	{
		processRequestParams->preProcessServiceBitmap		= PROCESS_ADD_FIRST_VAP_PRE_SERVICES_BITMAP;
		processRequestParams->postProcessServiceBitmap		= PROCESS_ADD_FIRST_VAP_POST_SERVICES_BITMAP;
	}
	
	processRequestParams->returnTask						= TASK_BSS_MANAGER;
	processRequestParams->updateParamsBeforeFinalizing 		= FALSE;
	processRequestParams->serviceData						= 0;
	processRequestParams->vapId 							= vapId;
	processRequestParams->dualBandProcess 					= FALSE;
	processRequestParams->processMsgHandledByCdbProcessMan 	= FALSE;
	
#if defined(ENET_INC_ARCH_WAVE600)
	bssManagerVapsDb.numOfActiveVaps[bandId]++;
#else
	bssManagerVapsDb.numOfActiveVaps++;
#endif

 
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST,TASK_PROCESS_MANAGER, processManagerMsg, vapId);
}

static void BssManager_VapManagerScheduleSetBss(K_MSG* psMsg)
{
	K_MSG *processManagerMsg;
	ProcessRequestParams_t *processRequestParams;
	UMI_SET_BSS* setBssStructurePtr; 
	uint8 vapId;

	BssManager_VapManagerProcessDb.setBss.inProgress = TRUE;
	setBssStructurePtr =(UMI_SET_BSS*)pK_MSG_DATA(psMsg);	
	vapId = setBssStructurePtr->vapId; 
	/* Schedule Process*/	
	processManagerMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(processManagerMsg);
	processRequestParams->processId 				= PROCESS_ID_SET_BSS;
	processRequestParams->startProcessMsg			= BSS_MANAGE_BSS_START_SET_BSS_PROCESS;
	processRequestParams->endProcessMsg 			= BSS_MANAGE_BSS_FINALIZE_SET_BSS_PROCESS;
	processRequestParams->requesterParams			= psMsg;
	processRequestParams->preProcessServiceBitmap	= PROCESS_SET_BSS_PRE_SERVICES_BITMAP;
	processRequestParams->postProcessServiceBitmap	= PROCESS_SET_BSS_POST_SERVICES_BITMAP;
	processRequestParams->returnTask				= TASK_BSS_MANAGER;
	processRequestParams->updateParamsBeforeFinalizing = FALSE;
	processRequestParams->serviceData 				= 0;
	processRequestParams->vapId						= vapId;
	processRequestParams->dualBandProcess 					= FALSE;
	processRequestParams->processMsgHandledByCdbProcessMan 	= FALSE;	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST,TASK_PROCESS_MANAGER,processManagerMsg, vapId);
}

static void	BssManager_VapManagerScheduleSetWmm(K_MSG *psMsg)
{
	K_MSG *processManagerMsg;
	ProcessRequestParams_t *processRequestParams;
	UMI_SET_WMM_PARAMETERS* setWmmstructurePtr;
	uint8 vapId;

	BssManager_VapManagerProcessDb.setWmm.inProgress = TRUE;
	setWmmstructurePtr =(UMI_SET_WMM_PARAMETERS*)pK_MSG_DATA(psMsg);	
	vapId = setWmmstructurePtr->vapId; 
	/* Schedule Process*/	
	processManagerMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(processManagerMsg);
	processRequestParams->processId 				= PROCESS_ID_SET_WMM_PARAMS;
	processRequestParams->startProcessMsg			= BSS_MANAGE_BSS_START_SET_WMM_PARAMS_PROCESS;
	processRequestParams->endProcessMsg 			= BSS_MANAGE_BSS_FINALIZE_SET_WMM_PARAMS_PROCESS;
	processRequestParams->requesterParams			= psMsg;
	processRequestParams->preProcessServiceBitmap	= PROCESS_SET_WMM_PARAMS_PRE_SERVICES_BITMAP;
	processRequestParams->postProcessServiceBitmap	= PROCESS_SET_WMM_PARAMS_POST_SERVICES_BITMAP;
	processRequestParams->returnTask				= TASK_BSS_MANAGER;
	processRequestParams->updateParamsBeforeFinalizing = FALSE;
	processRequestParams->serviceData 				= 0;
	processRequestParams->vapId    					= vapId;
	processRequestParams->dualBandProcess 					= FALSE;
	processRequestParams->processMsgHandledByCdbProcessMan 	= FALSE;	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST,TASK_PROCESS_MANAGER,processManagerMsg, vapId);
}

static void	BssManager_VapManagerScheduleRemoveVap(K_MSG *psMsg)
{
	K_MSG *processManagerMsg;
	ProcessRequestParams_t *processRequestParams;
#if defined(ENET_INC_ARCH_WAVE600)
	uint8 bandId;
#endif

	BssManager_VapManagerProcessDb.removeVap.inProgress = TRUE;	
	/* Schedule Process*/	
#if defined(ENET_INC_ARCH_WAVE600)
	bandId = ConfigurationManager_GetBandForVap(psMsg->header.vapId);
	bssManagerVapsDb.numOfActiveVaps[bandId]--;
#else
	bssManagerVapsDb.numOfActiveVaps--;
#endif
	processManagerMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(processManagerMsg);
	processRequestParams->processId 				= PROCESS_ID_REMOVE_VAP;
	processRequestParams->startProcessMsg			= BSS_MANAGE_BSS_START_REMOVE_VAP_PROCESS;
	processRequestParams->endProcessMsg 			= BSS_MANAGE_BSS_FINALIZE_REMOVE_VAP__PROCESS;
	processRequestParams->requesterParams			= psMsg;
#if defined(ENET_INC_ARCH_WAVE600)
	if (bssManagerVapsDb.numOfActiveVaps[bandId] != 0)
#else
	if (bssManagerVapsDb.numOfActiveVaps != 0)
#endif
	{
		processRequestParams->preProcessServiceBitmap	= PROCESS_REMOVE_VAP_PRE_SERVICES_BITMAP;
		processRequestParams->postProcessServiceBitmap	= PROCESS_REMOVE_VAP_POST_SERVICES_BITMAP;
	}
	else
	{
		processRequestParams->preProcessServiceBitmap	= PROCESS_REMOVE_LAST_VAP_PRE_SERVICES_BITMAP;
		processRequestParams->postProcessServiceBitmap	= PROCESS_REMOVE_LAST_VAP_POST_SERVICES_BITMAP;
	}
	processRequestParams->returnTask				= TASK_BSS_MANAGER;
	processRequestParams->updateParamsBeforeFinalizing = FALSE;
#if defined(ENET_INC_ARCH_WAVE600)
	processRequestParams->serviceData 				= bssManagerVapsDb.numOfActiveVaps[bandId];
#else
	processRequestParams->serviceData 				= bssManagerVapsDb.numOfActiveVaps;
#endif	
	processRequestParams->vapId						 = psMsg->header.vapId;
	processRequestParams->dualBandProcess 					= FALSE;
	processRequestParams->processMsgHandledByCdbProcessMan 	= FALSE;	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST,TASK_PROCESS_MANAGER, processManagerMsg, psMsg->header.vapId);
}

/*---------------------------------------------------------------------------------
/						Public Function Definitions									
/----------------------------------------------------------------------------------*/
void BssManager_VapManager_SetState(uint8 vapId, vapManagerState_e vapManagerNewState)
{
	ILOG0_DD("BssManager_VapManager_SetState, vapId:%d, vapManagerNewState:%d", vapId, vapManagerNewState);	

#if defined (BSS_MANAGER_VAP_MANAGER_STATE_DEBUG)
	BssManager_VapManagerStateDebug[BssManager_VapManagerStateDebugIdx].tsf = Pac_TimGetTsfLow();
	BssManager_VapManagerStateDebug[BssManager_VapManagerStateDebugIdx].vapId = vapId;
	BssManager_VapManagerStateDebug[BssManager_VapManagerStateDebugIdx].prevState = VapManagerDb[vapId].state;
	BssManager_VapManagerStateDebug[BssManager_VapManagerStateDebugIdx].newState = vapManagerNewState;
	BssManager_VapManagerStateDebugIdx++;
	if (BssManager_VapManagerStateDebugIdx == BSS_MANAGER_VAP_MANAGER_MAX_STATE_DEBUG)
	{
		BssManager_VapManagerStateDebugIdx = 0;
	}
#endif
	VapManagerDb[vapId].state = vapManagerNewState;
}

/**********************************************************************************

BssManager_VapManager_AddVap 

Description:
	Add Vap according to given parameters , calls to all registered modules 
	
Input:
-----
	Pointer to UMI_ADD_VAP structure, filled by driver   
		

Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_AddVap(K_MSG* psMsg)
{
	UMI_ADD_VAP* addVapStructurePtr; 
	uint8 vapId;  
	
	addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(psMsg);	
#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	addVapStructurePtr->vapId = psMsg->header.vapId;
#endif	
	SLOG0(0, 0, UMI_ADD_VAP, addVapStructurePtr);
	vapId = addVapStructurePtr->vapId; 	
	ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_INACTIVE_STATE); //Verify that VAP with same ID doesn't exists 
	/*If an ADD VAP Process is already scheduled, queue message and return*/
	if (BssManager_VapManagerProcessDb.addVap.inProgress == TRUE)
	{
		OSAL_QUEUE_MSG(&BssManager_VapManagerProcessDb.addVap.queue, psMsg);
		return;
	}
	BssManager_VapManagerScheduleAddVap(psMsg);
}

/**********************************************************************************

BssManager_VapManager_StartAddVaptProcess 

Description:
----------
	Start the Add Vap Process 
	
Input:
-----
	Pointer to UMI_ADD_VAP structure, filled by driver   
			
**********************************************************************************/
void BssManager_VapManager_StartAddVapProcess(K_MSG* psMsg)
{
	ProcessManagerReturnParams_t *processMangerReturnPrams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG *requesterParams = (K_MSG *)processMangerReturnPrams->requesterParams;
	UMI_ADD_VAP* addVapStructurePtr;
	uint8 vapId; 


	if (processMangerReturnPrams->processStatus == PROCESS_STATUS_REQUEST_ACCEPTED)
	{	
		addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(requesterParams);			
		vapId = addVapStructurePtr->vapId; 	
#ifdef SNIFFER_DEBUG
//
//		//workaround till DUT_APP will support sniffer mode
		if (addVapStructurePtr->operationMode == OPERATION_MODE_DUT)
//		{
			addVapStructurePtr->operationMode = OPERATION_MODE_SNIFFER;
//		}
//
#endif //SNIFFER_DEBUG

		VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_ADD_VAP].pStoredMsg = requesterParams;

		BssManager_VapManager_SetState(vapId, VAP_MANAGER_STARTING_STATE);

		VapDb_AssignVap(addVapStructurePtr); // should the DB register too? 

		/* Distribute the add vap  event to all registered modules */
		vapManagerDispatcher(requesterParams, VAP_MANAGER_ADD_VAP);  
	}
	else
	{
		addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(requesterParams);	
		
		vapId = addVapStructurePtr->vapId;
		/* Add Status to add vap msgaddVapStructurePtr->u8Status = UMI_REQUEST_REJECTED; */
		OSAL_SEND_MESSAGE(UMI_BSS_ADD_VAP_CFM, TASK_UM_IF_TASK, (K_MSG *)processMangerReturnPrams->requesterParams, vapId);
	}
}


/**********************************************************************************

BssManager_VapManager_FinalizeAddVapProcess 

Description:
----------
	Finalize  Add Vap Process  and return confiramtion to driver
	
Input:
-----
	Pointer to UMI_ADD_VAP structure, filled by driver   
			
**********************************************************************************/
void BssManager_VapManager_FinalizeAddVapProcess(K_MSG* psMsg)
{
	ProcessManagerReturnParams_t *processMangerReturnPrams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG *requesterParams = (K_MSG *)processMangerReturnPrams->requesterParams;
	UMI_ADD_VAP* addVapStructurePtr; 
	uint8 vapId;  
	K_MSG *pendingMsg;

	DEBUG_ASSERT(processMangerReturnPrams->processStatus == PROCESS_STATUS_EXECUTION_COMPLETED);	
	addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(requesterParams); 
	vapId = addVapStructurePtr->vapId;
	BssManager_VapManager_SetState(vapId, VAP_MANAGER_WAITING_FOR_SET_BSS_STATE);
	DEBUG_ASSERT(VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_ADDITION].pStoredMsg != NULL); 
	OSAL_SEND_MESSAGE(UMI_BSS_ADD_VAP_CFM, TASK_UM_IF_TASK, VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_ADDITION].pStoredMsg, vapId);
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_ADDITION].pStoredMsg = NULL;
	BssManager_VapManagerProcessDb.addVap.inProgress = FALSE;
	pendingMsg = OSAL_DEQUEUE_MSG(&BssManager_VapManagerProcessDb.addVap.queue);
	if (pendingMsg)
	{
		BssManager_VapManagerScheduleAddVap(pendingMsg);
	}
}

/**********************************************************************************

BssManager_VapManager_SetBss 

Description:
-----------
	Start the event of setting the BSS parameters, as part of the vap activation procedure 
	
Input:
-----
	Pointer to UMI_SET_BSS_REQ structure, filled by driver   
		
Returns:
--------
	VOID
	
**********************************************************************************/
void BssManager_VapManager_SetBss(K_MSG* psMsg)
{
	UMI_SET_BSS* setBssStructurePtr; 
	uint8 vapId;  

	setBssStructurePtr =(UMI_SET_BSS*)pK_MSG_DATA(psMsg);	
#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	setBssStructurePtr->vapId = psMsg->header.vapId;
#endif

	vapId = setBssStructurePtr->vapId; 
	/*If we get this message Vap must be in  "active" state  or "WAITING_FOR_SET_BSS_STATE" state*/
	ASSERT((VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE) || (VapManagerDb[vapId].state == VAP_MANAGER_WAITING_FOR_SET_BSS_STATE)); 
	/*If a SET BSS Process is already scheduled, queue message and return*/
	if (BssManager_VapManagerProcessDb.setBss.inProgress == TRUE)
	{
		OSAL_QUEUE_MSG(&BssManager_VapManagerProcessDb.setBss.queue, psMsg);
		return;
	}
	/* Schedule Process*/	
	BssManager_VapManagerScheduleSetBss(psMsg);
}

/**********************************************************************************

BssManager_VapManager_StartSetBssProcess 

Description:
----------
	Start The Set Bss Process
	
Input:
-----
	Pointer to UMI_SET_BSS_REQ structure, filled by driver   
		
Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_StartSetBssProcess(K_MSG* psMsg)
{
	ProcessManagerReturnParams_t *processMangerReturnParams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG *requesterParams = (K_MSG *)processMangerReturnParams->requesterParams;
	UMI_SET_BSS *setBssStructurePtr; 
	uint8 vapId;  

	if (processMangerReturnParams->processStatus == PROCESS_STATUS_REQUEST_ACCEPTED)
	{
		setBssStructurePtr = (UMI_SET_BSS *)pK_MSG_DATA(requesterParams);	
		vapId = setBssStructurePtr->vapId; 	
		VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_SET_BSS].pStoredMsg = requesterParams;

		if(VapManagerDb[vapId].state == VAP_MANAGER_WAITING_FOR_SET_BSS_STATE) 
		{
			BssManager_VapManager_SetState(vapId, VAP_MANAGER_SETTING_BSS_STATE); 
		}
		else
		{
			DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE); /*If we get this message Vap must be in  
																			"active" state  or "WAITING_FOR_SET_BSS_STATE" state*/
		}
		if(VapManager_RegDb.numClients[VAP_MANAGER_SET_BSS] == 0)
		{
			vapManagerPostConfirmationHandler(VAP_MANAGER_SET_BSS,vapId); 
		}
		else
		{
			/* Distribute the Set Bss  event to all registered modules */
			vapManagerDispatcher(requesterParams, VAP_MANAGER_SET_BSS); 
		}
	}
	else
	{
		setBssStructurePtr = (UMI_SET_BSS *)pK_MSG_DATA(requesterParams);	
		vapId = setBssStructurePtr->vapId; 	
		//setBssStructurePtr->u8Status = UMI_REQUEST_REJECTED;
		OSAL_SEND_MESSAGE(UMI_BSS_SET_BSS_CFM, TASK_UM_IF_TASK, requesterParams, vapId);
	}
}

/**********************************************************************************

BssManager_VapManager_FinalizeSetBssProcess 

Description:
----------
	Finalize  The Set Bss Process and send confirmation to driver
	
Input:
-----
	Pointer to UMI_SET_BSS_REQ structure, filled by driver   
		
Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_FinalizeSetBssProcess(K_MSG* psMsg)
{
	ProcessManagerReturnParams_t *processMangerReturnPrams= (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG* requesterParams =  processMangerReturnPrams->requesterParams;
	UMI_SET_BSS* setBssStructurePtr; 
	uint8 vapId;  
	vapManagerEvents_e eventIndex;
	K_MSG *pendingMsg;

	DEBUG_ASSERT(processMangerReturnPrams->processStatus == PROCESS_STATUS_EXECUTION_COMPLETED);
	setBssStructurePtr = (UMI_SET_BSS*) pK_MSG_DATA(requesterParams); 
	vapId = setBssStructurePtr->vapId;
	if(VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE)
	{
		/*When  Vap is In Active State - Send Confiramtion To Driver witout State Changing*/
		eventIndex = VAP_MANAGER_SET_BSS;
	}
	else
	{
		BssManager_VapManager_SetState(vapId, VAP_MANAGER_WAITING_FOR_SET_WMM_PARAMS);
		eventIndex = VAP_MANAGER_POST_SET_BSS;
	}
	DEBUG_ASSERT(VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg != NULL);	
	OSAL_SEND_MESSAGE(UMI_BSS_SET_BSS_CFM, TASK_UM_IF_TASK, VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg, vapId);
	VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg = NULL;
	BssManager_VapManagerProcessDb.setBss.inProgress = FALSE;
	pendingMsg = OSAL_DEQUEUE_MSG(&BssManager_VapManagerProcessDb.setBss.queue);
	if (pendingMsg)
	{
		/* Schedule Process*/	
		BssManager_VapManagerScheduleSetBss(pendingMsg);
	}
}

/**********************************************************************************

BssManager_VapManager_SetWmmParams 

Description:
	Start the event of setting the VAP WMM parameters, as part of the vap activation procedure 
	
Input:
-----
	Pointer to UMI_SET_VAP_WMM_PARAMS structure, filled by driver   
		
Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_SetWmmParams(K_MSG* psMsg)
{
	UMI_SET_WMM_PARAMETERS *setWmmStructurePtr; 
	uint8 vapId;  
	
	setWmmStructurePtr =(UMI_SET_WMM_PARAMETERS*)pK_MSG_DATA(psMsg);	
#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	setWmmStructurePtr->vapId = psMsg->header.vapId;
#endif
	vapId = setWmmStructurePtr->vapId; 
	SLOG0(0, 0, UMI_SET_WMM_PARAMETERS, setWmmStructurePtr);
	/*If we get this message Vap must be in  "active" state  or "VAP_MANAGER_WAITING_FOR_SET_WMM_PARAMS" state*/
	ASSERT((VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE) || (VapManagerDb[vapId].state == VAP_MANAGER_WAITING_FOR_SET_WMM_PARAMS)); 
	/*If a SET WMM Process is already scheduled, queue message and return*/
	if (BssManager_VapManagerProcessDb.setWmm.inProgress == TRUE)
	{
		OSAL_QUEUE_MSG(&BssManager_VapManagerProcessDb.setWmm.queue, psMsg);
		return;
	}
	/* Schedule Process*/	
	BssManager_VapManagerScheduleSetWmm(psMsg);
}

/**********************************************************************************

BssManager_VapManager_StartSetWmmParamsProcess 

Description:
----------
	Start Setiting Vap Wmm Parameters Process
	
Input:
-----
	Pointer to UMI_SET_VAP_WMM_PARAMS structure, filled by driver   
			
**********************************************************************************/
void BssManager_VapManager_StartSetWmmParamsProcess(K_MSG* psMsg)
{	
	ProcessManagerReturnParams_t *processMangerReturnPrams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG* requesterParams =  processMangerReturnPrams->requesterParams;
	UMI_SET_WMM_PARAMETERS* setWmmParamstructurePtr; 
	uint8 vapId;  

	setWmmParamstructurePtr = (UMI_SET_WMM_PARAMETERS*) pK_MSG_DATA(requesterParams); 
	if (processMangerReturnPrams->processStatus == PROCESS_STATUS_REQUEST_ACCEPTED)
	{
		vapId = setWmmParamstructurePtr->vapId; 	
		//ILOG2("BssManager_VapManager_StartSetWmmParamsProcess of vapId:%d", vapId);

		VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_SET_WMM_PARAMS].pStoredMsg = requesterParams;
			
		if(VapManagerDb[vapId].state == VAP_MANAGER_WAITING_FOR_SET_WMM_PARAMS)
		{
			BssManager_VapManager_SetState(vapId, VAP_MANAGER_SETTING_WMM_PARAMS_STATE);
		}
		else
		{
			/*If we get this message Vap must be in  "active" state  or "WAITING_FOR_SET_WMM_PARAMS" state*/
			DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE); 
		}
		/* Distribute the Set Wmm event to all registered modules */
		vapManagerDispatcher(requesterParams, VAP_MANAGER_SET_WMM_PARAMS);  
	}
	else
	{ 
		vapId = setWmmParamstructurePtr->vapId; 
		setWmmParamstructurePtr->u8Status = UMI_REQUEST_REJECTED;
		OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_WMM_PARAMETERS_CFM, TASK_UM_IF_TASK,requesterParams, vapId);
	}
}

/**********************************************************************************
 
BssManager_VapManager_FinalizeSetWmmParamsProcess 

Description:
----------
	Finalize the Set Wmm Process and send confiramtion to driver
	
Input:
-----
	status - Process Status
	psMsg - Pointer to UMI_SET_VAP_WMM_PARAMS structure, filled by driver   
			
**********************************************************************************/
void BssManager_VapManager_FinalizeSetWmmParamsProcess(K_MSG* psMsg)
{
	ProcessManagerReturnParams_t *processMangerReturnPrams= (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG* requesterParams =  processMangerReturnPrams->requesterParams;
	UMI_SET_WMM_PARAMETERS* setWmmParamstructurePtr; 
	uint8 vapId;  
	vapManagerEvents_e eventIndex;
	K_MSG *pendingMsg;

	DEBUG_ASSERT(processMangerReturnPrams->processStatus == PROCESS_STATUS_EXECUTION_COMPLETED);
	setWmmParamstructurePtr = (UMI_SET_WMM_PARAMETERS*) pK_MSG_DATA(requesterParams); 
	vapId = setWmmParamstructurePtr->vapId;
	if(VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE)
	{
		/*When  Vap is In Active State - Send Confiramtion To Driver witout State Changing*/
		eventIndex = VAP_MANAGER_SET_WMM_PARAMS;
	}
	else
	{
		BssManager_VapManager_SetState(vapId, VAP_MANAGER_ACTIVE_STATE);
		eventIndex = VAP_MANAGER_POST_VAP_ACTIVATION;
	}

	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_WMM_PARAMETERS_CFM, TASK_UM_IF_TASK, VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg, vapId);
	VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg = NULL;
	BssManager_VapManagerProcessDb.setWmm.inProgress = FALSE;
	pendingMsg = OSAL_DEQUEUE_MSG(&BssManager_VapManagerProcessDb.setWmm.queue);
	if (pendingMsg)
	{
		BssManager_VapManagerScheduleSetWmm(pendingMsg);
	}
}

/**********************************************************************************

BssManager_VapManager_RemoveVapReq 

Description:
------------
	Removes Vap according to given parameters  
	
Input:
-----
	Pointer to UMI_REMOVE_VAP which contains the vapId that shoudl be removed    
		

Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_RemoveVap(K_MSG* psMsg) 
{
#if defined (ENET_INC_ARCH_WAVE600)
	UMI_REMOVE_VAP* removeVapStructurePtr; 
		
	removeVapStructurePtr = (UMI_REMOVE_VAP*) pK_MSG_DATA(psMsg); 
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	removeVapStructurePtr->vapId = psMsg->header.vapId;
	SLOG0(0, 0, UMI_REMOVE_VAP, removeVapStructurePtr);
#endif	
	/*If a Remove VAP Process is already scheduled, queue message and return*/
	if (BssManager_VapManagerProcessDb.removeVap.inProgress == TRUE)
	{
		OSAL_QUEUE_MSG(&BssManager_VapManagerProcessDb.removeVap.queue, psMsg);
		return;
	}
	/* Schedule Process*/	
	BssManager_VapManagerScheduleRemoveVap(psMsg);
}

/**********************************************************************************

BssManager_VapManager_StartRemoveVapProcess 

Description:
------------
	Starts the Removes Vap process,, calls to all registered modules
	
Input:
-----
	Pointer to UMI_REMOVE_VAP which contains the vapId that shoudl be removed    
		

Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_StartRemoveVapProcess(K_MSG* psMsg) 
{
	ProcessManagerReturnParams_t *processMangerReturnPrams = (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG* requesterParams =  processMangerReturnPrams->requesterParams;
	UMI_REMOVE_VAP* removeVapStructurePtr;
	uint8 vapId; 

	removeVapStructurePtr = (UMI_REMOVE_VAP*) pK_MSG_DATA(requesterParams);
	vapId = removeVapStructurePtr->vapId; 
	if (processMangerReturnPrams->processStatus == PROCESS_STATUS_REQUEST_ACCEPTED)
	{
		BssManager_VapManager_SetState(vapId, VAP_MANAGER_REMOVING_STATE);	
		VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_REMOVE_VAP].pStoredMsg = requesterParams; 

		/* Distribute the Remove vap event to all registered modules */
		vapManagerDispatcher(requesterParams, VAP_MANAGER_REMOVE_VAP);  	
	}
	else
	{
		removeVapStructurePtr = (UMI_REMOVE_VAP*) pK_MSG_DATA(requesterParams);
		removeVapStructurePtr->u16Status = UMI_REQUEST_REJECTED;
		OSAL_SEND_MESSAGE(UMI_BSS_REMOVE_VAP_CFM, TASK_UM_IF_TASK, requesterParams, vapId);
	}
}

/**********************************************************************************

BssManager_VapManager_FinalizeRemoveVapProcess 

Description:
------------
	Finalize the Removes Vap process,, calls to all registered modules
	
Input:
-----
	Pointer to UMI_REMOVE_VAP which contains the vapId that shoudl be removed    
		

Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_FinalizeRemoveVapProcess(K_MSG* psMsg) 
{
	ProcessManagerReturnParams_t *processmangerReturnParams= (ProcessManagerReturnParams_t*)pK_MSG_DATA(psMsg);
	K_MSG* requesterParams =  processmangerReturnParams->requesterParams;	
	UMI_REMOVE_VAP* removeVapStructurePtr; 
	uint8 vapId;  
	K_MSG *pendingMsg;

	DEBUG_ASSERT(processmangerReturnParams->processStatus == PROCESS_STATUS_EXECUTION_COMPLETED);
	removeVapStructurePtr = (UMI_REMOVE_VAP*) pK_MSG_DATA(requesterParams); 
	vapId = removeVapStructurePtr->vapId;
	VapDb_ResetVapEntry(vapId);
	BssManager_VapManager_SetState(vapId, VAP_MANAGER_INACTIVE_STATE);	
	DEBUG_ASSERT(VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_REMOVAL].pStoredMsg != NULL);	
	OSAL_SEND_MESSAGE(UMI_BSS_REMOVE_VAP_CFM, TASK_UM_IF_TASK, VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_REMOVAL].pStoredMsg, vapId); 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_REMOVAL].pStoredMsg = NULL;
	BssManager_VapManagerProcessDb.removeVap.inProgress = FALSE;
	pendingMsg = OSAL_DEQUEUE_MSG(&BssManager_VapManagerProcessDb.removeVap.queue);
	if (pendingMsg)
	{
		BssManager_VapManagerScheduleRemoveVap(pendingMsg);
	}
}	

/**********************************************************************************

BssManager_VapManager_StopTraffic 

Description:
------------
	Stop Vap's traffic (MC and probe responses), by  distibtute the message to all relevent modules 
	
Input:	
----- 
	Stop traffic Request 

Returns:
--------
	void
	
**********************************************************************************/
void BssManager_VapManager_StopTraffic(K_MSG* psMsg) 
{
	UMI_STOP_VAP_TRAFFIC *pStopTraffic;
	uint8 vapId; 


	pStopTraffic = (UMI_STOP_VAP_TRAFFIC *)pK_MSG_DATA(psMsg);	
#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	pStopTraffic->vapId = psMsg->header.vapId;
#endif


	vapId = pStopTraffic->vapId; 
	
	DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE); 
	BssManager_VapManager_SetState(vapId, VAP_MANAGER_STOPPING_TRAFFIC_STATE);		
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_STOP_TRAFFIC].pStoredMsg = psMsg; 
	if(VapManager_RegDb.numClients[VAP_MANAGER_STOP_TRAFFIC] == 0)
	{
		vapManagerPostConfirmationHandler(VAP_MANAGER_STOP_TRAFFIC,vapId); 
	}
	else
	{
		/* Distribute the Stop Traffic event to all registered modules */
		vapManagerDispatcher(psMsg, VAP_MANAGER_STOP_TRAFFIC);  
	}
}


/**********************************************************************************

BssManager_VapManager_EventHandlerConfirm 

Description:
------------
		This routine is the one to be called after each VAP_MANAGER event confirmation 
	
Input:
-----
		BSS manager confirmation event, general confirmation for the BSS manager  thread   
		
Output:
-------


Returns:
--------
	void - 
	
**********************************************************************************/
void BssManager_VapManager_EventHandlerConfirm(K_MSG* psMsg)
{
	BSS_MANAGER_CONFIRM_EVENT*			pVapCfm = (BSS_MANAGER_CONFIRM_EVENT *)psMsg->abData;
	uint8 								vapId;
	vapManagerEvents_e					eventIndex;	
	VAP_MANAGER_CONFIRMATION_ELEMENT*	pVapCfmEvent;

	/*Get vap Index from message*/
	vapId = pVapCfm->vapId;
	eventIndex = pVapCfm->eventIndex;
	DEBUG_ASSERT(vapId < HW_NUM_OF_VAPS);
	DEBUG_ASSERT(eventIndex < TOTAL_VAP_MANAGER_EVENTS);

	pVapCfmEvent = &(VapManagerDb[vapId].eventConfirmation[eventIndex]);
	DEBUG_ASSERT(pVapCfmEvent->pendingBitmap != 0);
	/*Clear this client from pending clients*/
	pVapCfmEvent->pendingBitmap &= ~(1 << pVapCfm->clientId);
	ILOG0_DD("BSS MNG, VAP MNG, Reg Confirm, vapId %d, Client %d", vapId, pVapCfm->clientId);	
	// Check if all modules have confirmed
	if(pVapCfmEvent->pendingBitmap == 0) 
	{
		vapManagerPostConfirmationHandler(eventIndex, vapId); 
	}
}

K_MSG *BssManagerVapManager_GetDummyMessage(void)
{
	K_MSG *dummyMsg = NULL;
	ProcessRequestParams_t *dummyStruct = NULL;
	dummyMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	dummyStruct = (ProcessRequestParams_t*)pK_MSG_DATA(dummyMsg);
	dummyStruct->preProcessServiceBitmap = 0xCAFECAFE;
	dummyStruct->postProcessServiceBitmap = 0xCAFECAFE;
	dummyStruct->serviceData = 0xCAFECAFE;
	dummyStruct->startProcessMsg = 0xCAFE;
	dummyStruct->endProcessMsg = 0xCAFE;
	dummyStruct->returnTask = 0xCA;
	dummyStruct->processId = 0xFE;
	return dummyMsg;
}



/**********************************************************************************

bssManagerVapManagerPostSetBss 

Description:
	called after SET BSS distribution and confirmation done 
	
Input:
-----
	Pointer to UMI_SET_BSS structure, filled by driver   
		
Output:
-------
	

Returns:
--------
	VOID
	
**********************************************************************************/
static void bssManagerVapManagerPostSetBss(K_MSG* psMsg)
{
	uint8 vapId; 
	UMI_SET_BSS* setBssPtr = (UMI_SET_BSS*) pK_MSG_DATA(psMsg);

	vapId = setBssPtr->vapId; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_SET_BSS].pStoredMsg  = psMsg; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_SET_BSS].pStoredMsg  = NULL; 	

	if (VapManager_RegDb.numClients[VAP_MANAGER_POST_SET_BSS] == 0)
	{
		vapManagerPostConfirmationHandler(VAP_MANAGER_POST_SET_BSS,vapId); 
	}
	else
	{
		/* Distribute the Post Set Bss event to all registered modules */
		vapManagerDispatcher(psMsg, VAP_MANAGER_POST_SET_BSS);  
	}
}



/**********************************************************************************

BssManager_VapManagerPostVapAddition 

Description:
	called after add vap distribution and confirmation done 
	
Input:
-----
	Pointer to UMI_ADD_VAP structure, filled by driver   
		
Output:
-------
	

Returns:
--------
	VOID
	
**********************************************************************************/
static void bssManagerVapManagerPostVapActivation(K_MSG* psMsg)
{
	uint8 vapId; 
	UMI_SET_WMM_PARAMETERS* setWmmParamstructurePtr = (UMI_SET_WMM_PARAMETERS*) pK_MSG_DATA(psMsg);; 

	vapId = setWmmParamstructurePtr->vapId; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_ACTIVATION].pStoredMsg = psMsg; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_SET_WMM_PARAMS].pStoredMsg = NULL; 
	if(VapManager_RegDb.numClients[VAP_MANAGER_POST_VAP_ACTIVATION] == 0)
	{
		vapManagerPostConfirmationHandler(VAP_MANAGER_POST_VAP_ACTIVATION,vapId); 
	}
	else
	{
		/* Distribute the Post Wmm Setting  event to all registered modules */
		vapManagerDispatcher(psMsg, VAP_MANAGER_POST_VAP_ACTIVATION);  
	}
}

/**********************************************************************************

BssManager_VapManagerPostVapRemoval 

Description:
	called after add vap distribution and confirmation done 
	
Input:
-----
	Pointer to UMI_ADD_VAP structure, filled by driver   
		
Output:
-------
	

Returns:
--------
	VOID
	
**********************************************************************************/
static void bssManagerVapManagerPostVapRemoval(K_MSG* psMsg)
{
	uint8 vapId; 
	UMI_REMOVE_VAP* removeVapStructurePtr = (UMI_REMOVE_VAP*) pK_MSG_DATA(psMsg);

	vapId = removeVapStructurePtr->vapId; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_REMOVAL].pStoredMsg = psMsg; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_REMOVE_VAP].pStoredMsg = NULL; 
	if(VapManager_RegDb.numClients[VAP_MANAGER_POST_VAP_REMOVAL] == 0)
	{
		vapManagerPostConfirmationHandler(VAP_MANAGER_POST_VAP_REMOVAL,vapId); 
	}
	else
	{ 
		/* Distribute the Post Vap Removeal event to all registered modules */
		vapManagerDispatcher( psMsg, VAP_MANAGER_POST_VAP_REMOVAL);  	
	}
}

/**********************************************************************************

bssManagerPostStopTraffic 

Description:

	
Input:
-----
 
		
Output:
-------
	

Returns:
--------
	VOID
	
**********************************************************************************/
static void bssManagerPostStopTraffic(K_MSG* psMsg)
{
	UMI_STOP_VAP_TRAFFIC *pStopTraffic;
	uint8 vapId; 

	pStopTraffic = (UMI_STOP_VAP_TRAFFIC*)pK_MSG_DATA(psMsg);	
	vapId = pStopTraffic->vapId; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_STOP_TRAFFIC].pStoredMsg = psMsg; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_STOP_TRAFFIC].pStoredMsg = NULL; 
	if(VapManager_RegDb.numClients[VAP_MANAGER_POST_STOP_TRAFFIC] == 0)
	{
		vapManagerPostConfirmationHandler(VAP_MANAGER_POST_STOP_TRAFFIC,vapId); 
	}
	else
	{
		/* Distribute the post stop traffic event to all registered modules */
		vapManagerDispatcher(psMsg, VAP_MANAGER_POST_STOP_TRAFFIC);  
	}
}

/**********************************************************************************

bssManagerVapManagerPostVapAddition 

Description:
	called after add vap distribution and confirmation done 
	
Input:
-----
	Pointer to UMI_ADD_VAP structure, filled by driver   
		
Output:
-------
	

Returns:
--------
	VOID
	
**********************************************************************************/
static void bssManagerVapManagerPostVapAddition(K_MSG* psMsg)
{
	uint8 vapId; 
	UMI_ADD_VAP* addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(psMsg);

	vapId = addVapStructurePtr->vapId; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_POST_VAP_ADDITION].pStoredMsg = psMsg; 
	VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_ADD_VAP].pStoredMsg = NULL; 
	if(VapManager_RegDb.numClients[VAP_MANAGER_POST_VAP_ADDITION] == 0)
	{
		vapManagerPostConfirmationHandler(VAP_MANAGER_POST_VAP_ADDITION,vapId); 
	}
	else
	{ 
		/* Distribute the Post Vap Additon event to all registered modules */
		vapManagerDispatcher(psMsg, VAP_MANAGER_POST_VAP_ADDITION);  	
	}
}

/**********************************************************************************

vapManagerDispatcher 

Description:
------------
	This routine distribute the event for all registered modules (for the given event)  
	
Input:
-----
vapManagerEvents_e  
K_MSG* - event apropriate message 

		
Output:
-------
None	

Returns:
--------
	
**********************************************************************************/
static void vapManagerDispatcher(K_MSG* psMsg, vapManagerEvents_e event)
{
	uint8 								i;
	K_MSG*								psEventMsg;
	BssManagerVapManagerReq_t* 			vapManagerReq;
	BssManagerVapManagerRegClient_t* 	client;
	uint8								vapId = psMsg->header.vapId;

	/*Check registration type validity*/	
	DEBUG_ASSERT(event < TOTAL_VAP_MANAGER_EVENTS);

	/*There must be registered clients*/
	DEBUG_ASSERT(VapManager_RegDb.numClients[event] > 0);

	/* There must be no pending clients for this VAP */
	DEBUG_ASSERT(VapManagerDb[vapId].eventConfirmation[event].pendingBitmap == 0);

	/*Send messages to registered clients*/
	for (i = 0; i < BSS_MANAGER_VAP_MANAGER_MAX_CLIENTS; i++)
	{

		client = &VapManager_RegDb.clientDb[event][i];
		if (client->msgId != OSAL_TASK_UNUSED_MSG)
		{
			/*Allocate message*/
			psEventMsg = OSAL_GET_MESSAGE(sizeof(BssManagerVapManagerReq_t));
			vapManagerReq = (BssManagerVapManagerReq_t *)pK_MSG_DATA(psEventMsg);

			/*Set pointer to original message in registration message*/
			vapManagerReq->psMsg = psMsg;

			/*Mark this client as pending*/
			VapManagerDb[vapId].eventConfirmation[event].pendingBitmap |= (1 << i);
			ILOG0_DDD("BSS MNG, VAP MNG, Dispatch Client %d, MsgId %d, TaskId %x", i, client->msgId, client->taskId);

			/*Send appropiate message to task registered by this client*/
			OSAL_SEND_MESSAGE(client->msgId, client->taskId, psEventMsg, vapId);
		}
	}
}


/**********************************************************************************

vapManagerPostConfirmationHandler 

Description:
----------
	After all even't ditributed modules confirmed, this routine decides on the next step.  
	
Input:
-----
	event, which all of it's registered modules confirms reached 
	vap Id, what VAP is this instance for   
		
Output:
-------
	

Returns:
--------
	VOID
	
**********************************************************************************/
static void vapManagerPostConfirmationHandler(vapManagerEvents_e eventIndex, uint8 vapId)
{
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = NULL;	

	switch (eventIndex)  
	{
	case VAP_MANAGER_ADD_VAP:
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_STARTING_STATE);
		BssManager_VapManager_SetState(vapId, VAP_MANAGER_POST_STARTING_STATE);
		bssManagerVapManagerPostVapAddition(VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg); 
		break;

	case VAP_MANAGER_POST_VAP_ADDITION:	
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_POST_STARTING_STATE);		
		/* Signal to Process Manager Excecution Has Fisnished  Process */
		dummyMsg = BssManagerVapManager_GetDummyMessage();
		OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
		break;
		
	case VAP_MANAGER_SET_BSS: 
		DEBUG_ASSERT((VapManagerDb[vapId].state == VAP_MANAGER_SETTING_BSS_STATE) || (VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE));
		if(VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE)
		{
			/* Signal to Process Manager Excecution Has Fisnished  Process*/		
			dummyMsg = BssManagerVapManager_GetDummyMessage();
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
		}
		else
		{
			BssManager_VapManager_SetState(vapId, VAP_MANAGER_POST_SET_BSS_STATE);
			bssManagerVapManagerPostSetBss(VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg); 
		}
		break;

	case VAP_MANAGER_POST_SET_BSS:
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_POST_SET_BSS_STATE); 		
		/* Signal to Process Manager Excecution Has Fisnished  Process*/		
		dummyMsg = BssManagerVapManager_GetDummyMessage();
		OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
		break;
		
	case VAP_MANAGER_SET_WMM_PARAMS: 
		DEBUG_ASSERT((VapManagerDb[vapId].state == VAP_MANAGER_SETTING_WMM_PARAMS_STATE) || (VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE));

		if(VapManagerDb[vapId].state == VAP_MANAGER_ACTIVE_STATE)
		{
			dummyMsg = BssManagerVapManager_GetDummyMessage();
			OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
		}
		else
		{
			BssManager_VapManager_SetState(vapId, VAP_MANAGER_POST_VAP_ACTIVATION_STATE);
			bssManagerVapManagerPostVapActivation(VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg); 
		}
	
		break;
		
	case VAP_MANAGER_POST_VAP_ACTIVATION:
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_POST_VAP_ACTIVATION_STATE); 		
		/* Signal to Process Manager Excecution Has Fisnished  Process*/		
		dummyMsg = BssManagerVapManager_GetDummyMessage();
		OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
		break; 
		
	case VAP_MANAGER_STOP_TRAFFIC:
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_STOPPING_TRAFFIC_STATE); 
		BssManager_VapManager_SetState(vapId, VAP_MANAGER_POST_STOP_TRAFFIC_STATE);
		bssManagerPostStopTraffic(VapManagerDb[vapId].eventConfirmation[VAP_MANAGER_STOP_TRAFFIC].pStoredMsg);
		break;
		
	case VAP_MANAGER_POST_STOP_TRAFFIC:	
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_POST_STOP_TRAFFIC_STATE); 
		BssManager_VapManager_SetState(vapId, VAP_MANAGER_WAITING_FOR_REMOVE_STATE);
		DEBUG_ASSERT(VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg != NULL); 	
		OSAL_SEND_MESSAGE(UMI_BSS_STOP_VAP_TRAFFIC_CFM, TASK_UM_IF_TASK, VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg, vapId);
		VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg = NULL;
		break;
		
	case VAP_MANAGER_REMOVE_VAP:
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_REMOVING_STATE); 
		BssManager_VapManager_SetState(vapId, VAP_MANAGER_POST_REMOVING_STATE);
		bssManagerVapManagerPostVapRemoval(VapManagerDb[vapId].eventConfirmation[eventIndex].pStoredMsg); 
		break;
		
	case VAP_MANAGER_POST_VAP_REMOVAL: 
		DEBUG_ASSERT(VapManagerDb[vapId].state == VAP_MANAGER_POST_REMOVING_STATE); 		
		/* Signal to Process Manager Excecution Has Fisnished  Process*/		
		dummyMsg = BssManagerVapManager_GetDummyMessage();
		OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, vapId);
		break;
	default:
		DEBUG_ASSERT(0);
		break;
	}
}


/**********************************************************************************

BssManager_VapManager_Init 

Description:
------------
	Initialize the evens pool 
	
Input:
-----
	None
		
Output:
-------
	

Returns:
--------
	VOID
	
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void BssManager_VapManager_Init(void)
{
	uint8 vapIndex; 
	uint8 eventIndex; 
	uint8 clientIndex;
	
	for(vapIndex = 0; vapIndex < HW_NUM_OF_VAPS; vapIndex++)
	{
		BssManager_VapManager_SetState(vapIndex, VAP_MANAGER_INACTIVE_STATE);

		for(eventIndex =0 ; eventIndex < TOTAL_VAP_MANAGER_EVENTS;eventIndex++)
		{
			VapManagerDb[vapIndex].eventConfirmation[eventIndex].pendingBitmap = 0; 
			VapManagerDb[vapIndex].eventConfirmation[eventIndex].pStoredMsg = NULL; 
		}
	}

	// Init number of clients registered for each event. It can change depending on compilation flags.
	for(eventIndex =0 ; eventIndex < TOTAL_VAP_MANAGER_EVENTS;eventIndex++)
	{
		for (clientIndex = 0 ; clientIndex < BSS_MANAGER_VAP_MANAGER_MAX_CLIENTS; clientIndex++)
		{
			if (VapManager_RegDb.clientDb[eventIndex][clientIndex].msgId != OSAL_TASK_UNUSED_MSG)
			{
				VapManager_RegDb.numClients[eventIndex]++;
			}

		}
		
	}

#if defined(ENET_INC_ARCH_WAVE600)
	bssManagerVapsDb.numOfActiveVaps[CONFIGURATION_MANAGER_BAND_0] = 0;
	bssManagerVapsDb.numOfActiveVaps[CONFIGURATION_MANAGER_BAND_1] = 0;
#else
	bssManagerVapsDb.numOfActiveVaps = 0;
#endif
	memset(&BssManager_VapManagerProcessDb, 0, sizeof(BssManager_VapManagerProcessDb_t));
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif


