/***********************************************************************************
 File:			BssManager_StaManager.h
 Module:		Tx Manager 
 Purpose: 		To handle Tx packets whose transmission proccess was ended
 Description:	This file contains all definitions and the structures of the Tx 
 				manager	which is responsible to handle Tx packets whose transmission 
 				proccess was ended
************************************************************************************/
#ifndef BSS_MANAGER_STA_MANAGER_H_
#define BSS_MANAGER_STA_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void BssManager_AddSta(K_MSG *pMsg);
extern void BssManager_SetFilter(K_MSG *pMsg);
extern void BssManager_StopTraffic(K_MSG *pMsg);
extern void BssManager_CloseSta(K_MSG *pMsg);
extern void BssManager_StaManagerRegConfirm(K_MSG *pMsg);
extern void BssManager_StaManagerInit(void);

#endif /* BSS_MANAGER_STA_MANAGER_H_ */



