/***********************************************************************************
 File:			BaAnalyzer_Api.h
 Module:		BA Analyzer 
 Purpose: 		To create a driver for the BA analyer which process the BA response
 Description:   This file is the API of the BA anaylzer module 
				which is responsible of processing the BA response and releasing PDs
************************************************************************************/
#ifndef BA_ANALYZER_API_H_
#define BA_ANALYZER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "PacketDescriptor.h"
#include "linkAdaptation_api.h"
#include "BaAnalyzer.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define BAA_REPORT_TYPE_SU	0x4 
#define BAA_REPORT_TYPE_MU	0x5 

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Externals						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------


void BaAnalyzer_InitializeBaaStatusFifo(void);
#ifndef ENET_INC_ARCH_WAVE600
void BaAnalyzer_GetFifoEntry(BaaRateAdaptiveFifo_t* pCurrentBaaTxReport);
void BaAnalyzer_IncrementFifoEntryPtr(void);
void BaAnalyzer_DecFifoNumEntriesCount(uint8 value);
void BaAnalyzer_processBaaReportQueuePostSeq(StaId staIndex,uint16 numberOfElementInBaaFifo,bool isReportValid );
#else
ISR_VOID isr_BaAnalyzerInterruptErrorHandler(void);
#endif
void BaAnalyzer_processBaaReportQueue(K_MSG *psMsg);
void BaAnalyzer_Initialize(void);

#ifndef ENET_INC_ARCH_WAVE600

#ifdef ENET_INC_UMAC

ISR_VOID isr_BaAnalyzer_UmacStatusFifoNotEmpty(void);
#else /* #ifdef ENET_INC_UMAC */

#endif /* #ifdef ENET_INC_LMAC */


#else /*ENET_INC_ARCH_WAVE600*/

void baAnalyzer_StatusFifoNotEmptyEventHandler(void);

#endif /*ENET_INC_ARCH_WAVE600*/
#ifdef ENET_INC_ARCH_WAVE600D2
void BaAnalyzer_SetAidForStaMode(uint16 aid);
#endif

#endif /* BA_ANALYZER_API_H_ */

