/***************************************************************
 File:		BaAnalyzer.h
 Module:	  	Ba Analyzer
 Purpose: 	
 Description:  
***************************************************************/
#ifndef BA_ANALYZER_H_
#define BA_ANALYZER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define MAX_TX_BAA_FIFO_SIZE	64 

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

#define	BAA_PROCESS_BAA_REPORT_QUEUE(psMsg)  BaAnalyzer_processBaaReportQueue(psMsg);

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum txType
{
	TX_TYPE_FLAT,
	TX_TYPE_STBC,
	TX_TYPE_IMPLICIT_BF,
	TX_TYPE_EXPLICIT_BF
}txType_e;

typedef struct _BaaRateAdaptiveFifoCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 transactionNumber : 8;  //bits [0..7]
			uint32 txType            : 4;  //bits [8..11]
			uint32 cca               : 6;  //bits [12..17]
			uint32 scp               : 1;  //bit [18]
			uint32 hwGroupDbGroup    : 7;  //bits [19..25]
			uint32 bwModifycca       : 1;  //bit [26]
			uint32 bwModifyOther     : 1;  //bit [27]
			uint32 primary           : 1;  //bit [28]
			uint32 reportType        : 3;  //bits [29..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 txqId : 18; //bits [0..17]
			uint32       : 14;
		};
		struct
		{
			uint32 txqTid : 3;  //bits [0..2]
			uint32        : 29;
		};
		struct
		{
			uint32              : 3;
			uint32 txqStationId : 8;  //bits [3..10]
			uint32              : 21;
		};
		struct
		{
			uint32          : 11;
			uint32 txqVapId : 4;  //bits [11..14]
			uint32          : 17;
		};
		struct
		{
			uint32            : 15;
			uint32 txqGroupId : 3;  //bits [15..17]
			uint32            : 14;
		};
		struct
		{
			uint32         : 18;
			uint32 timeout : 1;  //bit [18]
			uint32         : 13;
		};
		struct
		{
			uint32        : 19;
			uint32 pdType : 4;  //bits [19..22], values from PdTypeOld_e
			uint32        : 9;
		};
		struct
		{
			uint32         : 23;
			uint32 mpduCnt : 7;  //bits [23..29]
			uint32         : 2;
		};
		struct
		{
			uint32                : 30;
			uint32 firstAfterData : 1;  //bit [30]
			uint32                : 1;
		};
		struct
		{
			uint32         : 31;
			uint32 otherRx : 1;  //bit [31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 weitedSuccessMpdu : 14; //bits [0..13]
			uint32 res               : 2;  //bits [14..15]
			uint32 weitedFailMpdu    : 14; //bits [16..29]
			uint32 txParamOveride    : 1;  //bit [30]
			uint32 protectionSent    : 1;  //bit [31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 totalSizeAllMpdu     : 14; //bits [0..13]
			uint32 bw                   : 2;  //bits [14..15], values from Bw_e
			uint32 totalSizeSuccessMpdu : 14; //bits [16..29]
			uint32 phyMode              : 2;  //bits [30..31], values from PhyModeOld_e
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 successMpdu  : 7;  //bits [0..6]
			uint32 failedMpdu   : 7;  //bits [7..13]
			uint32 rate         : 6;  //bits [14..19]
			uint32 power        : 6;  //bits [20..25]
			uint32 reportNumber : 6;  //bits [26..31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 totalSizeOfAllZld : 15; //bits [0..14]
			uint32                   : 17;
		};
		struct
		{
			uint32      : 15;
			uint32 res2 : 1;  //bit [15]
			uint32      : 16;
		};
		struct
		{
			uint32        : 16;
			uint32 sender : 16; //bits [16..31]
		};
		struct
		{
			uint32                : 16;
			uint32 isFastProbUsp0 : 1;  //bit [16]
			uint32                : 15;
		};
		struct
		{
			uint32                : 17;
			uint32 isFastProbUsp1 : 1;  //bit [17]
			uint32                : 14;
		};
		struct
		{
			uint32                : 18;
			uint32 isFastProbUsp2 : 1;  //bit [18]
			uint32                : 13;
		};
		struct
		{
			uint32                : 19;
			uint32 isFastProbUsp3 : 1;  //bit [19]
			uint32                : 12;
		};
		struct
		{
			uint32                : 20;
			uint32 psduTime  	  : 8;  //bit [20..27]
			uint32                : 4;
		};
		struct
		{
			uint32                : 28;
			uint32 ccaSetByPTA    : 1;  //bit [28]
			uint32                : 3;
		};

		struct
		{
			uint32                : 29;
			uint32 senderReserved : 3;  //bits [29..31] 
		};

	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 deliaReportLow : 32; //bits [0..31]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 deliaReportHigh : 32; //bits [0..31]
		};
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 baResultLow : 32; //bits [0..31]
		};
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 baResultHigh : 32; //bits [0..31]
		};
	};
} BaaRateAdaptiveFifoCommon_t;

typedef BaaRateAdaptiveFifoCommon_t BaaRateAdaptiveFifo_t;

typedef struct _BaaRateAdaptiveCommonFifoCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 seqTransactionNumber : 8;  //bits [0..7]
			uint32 baaTransactionNumber : 8;  //bits [8..15]
			uint32 numOfUsers           : 7;  //bits [16..22]
			uint32 reportType           : 3;  //bits [23..25], values from TxopType_e
			uint32 phyMode              : 3;  //bits [26..28], values from PhyMode_e
			uint32 txqGroupId           : 3;  //bits [29..31], values from TxqGroupId_e
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 planIndex     : 7;  //bits [0..6]
			uint32 muPrimaryUsp  : 2;  //bits [7..8], values from Usp_e
			uint32 pdType        : 5;  //bits [9..13], values from PdType_e
			uint32 cca           : 5;  //bits [14..18]
			uint32 scp           : 1;  //bit [19]
			uint32 heCp          : 2;  //bits [20..21]
			uint32 bwModifycca   : 1;  //bit [22]
			uint32 bwModifyOther : 1;  //bit [23]
			uint32 rfPower       : 8;  //bits [24..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 antenaSelection : 16; //bits [0..15]
			uint32 antBoost        : 16; //bits [16..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 firstAfterData : 1;  //bit [0]
			uint32 bw             : 2;  //bits [1..2], values from Bw_e
			uint32 txParamOveride : 1;  //bit [3]
			uint32 duration       : 17; //bits [4..20]
			uint32 tcrType        : 1;  //bit [21]
			uint32 phaseIndex     : 4;  //bits [22..25]
			uint32 protectionSent : 1;  //bit [26]
			uint32 reserved3      : 5;  //bits [27..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 senderReservedWord0 : 32; //bits [0..31]
		}; //Configuration register
		struct
		{
			uint32 ccaSetByPta : 1;  //bit [0]
			uint32             : 31;
		}; //Configuration register
		struct
		{
			uint32                                 : 1;
			uint32 senderReservedWord0ReservedBits : 31; //bits [1..31]
		}; //Configuration register
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 senderReservedWord1 : 32; //bits [0..31]
		};
	};
} BaaRateAdaptiveCommonFifoCommon_t;

typedef BaaRateAdaptiveCommonFifoCommon_t BaaRateAdaptiveCommonFifo_t;

typedef struct _BaaRateAdaptiveUserFifoCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 baaTransactionNumber : 8;  //bits [0..7]
			uint32 txQVapId             : 7;  //bits [8..14]
			uint32 txQStaId             : 9;  //bits [15..23]
			uint32 txUserId             : 7;  //bits [24..30]
			uint32 reserved0            : 1;  //bit [31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tidBitmap                : 9;  //bits [0..8]
			uint32 reportNumber             : 7;  //bits [9..15]
			uint32 primary                  : 1;  //bit [16]
			uint32 phyTxBf                  : 1;  //bit [17]
			uint32 timeout                  : 1;  //bit [18]
			uint32 otherRx                  : 1;  //bit [19]
			uint32 baACtrlRsp               : 1;  //bit [20]
			uint32 baACtrlAck               : 1;  //bit [21]
			uint32 tcrMcsNssRate            : 8;  //bits [22..29]
			uint32 altRateReasonSlowProbing : 1;  //bit [30]
			uint32 altRateReasonFastProbing : 1;  //bit [31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 successMpduCnt         : 12; //bits [0..11]
			uint32 totalSuccessMpduLength : 17; //bits [12..28]
			uint32 twt                    : 1;  //bit [29]
			uint32 twtType                : 1;  //bit [30]
			uint32 twtSp                  : 1;  //bit [31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 failedMpduCnt       : 12; //bits [0..11]
			uint32 totalFailMpduLength : 17; //bits [12..28]
			uint32 ldpc                : 1;  //bit [29]
			uint32 reserved3           : 2;  //bits [30..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 maxPsduLength : 17; //bits [0..16]
			uint32 deliaMpduCnt  : 12; //bits [17..28]
			uint32 reserved4     : 3;  //bits [29..31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 totalLength : 22; //bits [0..21]
			uint32             : 10;
		}; //duration*phy_rate - 64B quantized	phy_rate from STD User
		struct
		{
			uint32        : 22;
			uint32 errors : 8;  //bits [22..29]
			uint32        : 2;
		};
		struct
		{
			uint32                 : 22;
			uint32 unexpectedStaid : 1;  //bit [22]
			uint32                 : 9;
		}; //MBA aid is wrong
		struct
		{
			uint32               : 23;
			uint32 unexpectedTid : 1;  //bit [23]
			uint32               : 8;
		}; //unexpected TID, set when received 	BA on an unexpected response TID
		struct
		{
			uint32                         : 24;
			uint32 unexpectedAckType0Tid15 : 1;  //bit [24]
			uint32                         : 7;
		}; //unexpected M-BA ack type 0 on TID 15
		struct
		{
			uint32                   : 25;
			uint32 unexpectedFragNum : 1;  //bit [25]
			uint32                   : 6;
		}; //unexpected fragment number field 	within BA frame
		struct
		{
			uint32                    : 26;
			uint32 unexpectedBaLength : 1;  //bit [26]
			uint32                    : 5;
		}; //BA length is wrong, ended unexpectedly in the middle of a subfield format
		struct
		{
			uint32                : 27;
			uint32 errorsReserved : 3;  //bits [27..29]
			uint32                : 2;
		};
		struct
		{
			uint32           : 30;
			uint32 reserved5 : 2;  //bits [30..31]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 sender : 32; //bits [0..31]
		};
	};
} BaaRateAdaptiveUserFifoCommon_t;

typedef BaaRateAdaptiveUserFifoCommon_t BaaRateAdaptiveUserFifo_t;


typedef struct BaaRateAdaptiveFullFifo
{
	BaaRateAdaptiveCommonFifo_t commonReport;
	BaaRateAdaptiveUserFifo_t	userReport; 
}BaaRateAdaptiveFullFifo_t;


#endif /*BA_ANALYZER_H_ */
