/***********************************************************************************
 File:			BeaconHandler_api.h
 Module:			Beacon Handler
 Purpose: 		Manages beacon HW configuration and preparing Beacon frames for transmission
 Description:		This header is the API to the Beacon Handler module
				which is responsible for configuring the Beacon HW and preparing Beacon frames
				for transmission.
************************************************************************************/
#ifndef BEACON_HANDLER_API_H_
#define BEACON_HANDLER_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "shram_man_msgs.h"
#include "OSAL_Kmsg.h"
#include "BeaconHandler.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct BeaconHwParams
{
	uint32 beaconLCM;
	uint32 beaconOffset;
	uint16 beaconInterval;
	uint16 dtimInterval;
} BeaconHwParams_t;

typedef struct BeaconHandlerVapDb_s
{
	TxPd_t*   			pPendingTemplateHead; // Head pointer to the reserve list of PDs we use when updating a Beacon template
	TxPd_t*   			pPendingTemplateTail; // Tail pointer to the reserve list of PDs we use when updating a Beacon template
	BeaconHostBuffer_t  beaconBuffers[BEACON_MAX_HOST_BUFFERS_NUM];
	bool				isVht;
	bool				isBeaconQueueActive; 
	bool				csaOverwrite; 					/* This bit indicates that template Update was overwritten by CSA start, used to ignore lock confirmation */
	bool				isDtimAndBeaconIntervalsSet;	/* We may set the interval only once in a VAP's life cycle */
	UmiOperationMode_e	operationMode;					/* VAP or STA */		
} BeaconHandlerVapDb_t;

#ifdef ENET_INC_ARCH_WAVE600B
typedef struct MbssIdParams
{
	BeaconHwParams_t transmitVapBeaconHwParams;
	uint8 transmitVapId;
	uint8 numOfVapsInGroup;
	uint8 numOfAddedVapsInGroup;
	uint8 reserved;
} MbssIdParams_t;
#endif
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void BeaconHandler_Init(void);
void BeaconHandler_TemplatesInit(void);
void BeaconHandler_TemplateUpdate(K_MSG *beaconHandlerMessage);
void BeaconHandler_AddVap(UMI_SET_AP_BEACON_INFO* setBssStructurePtr); 
void BeaconHandler_BeaconDeactivate(K_MSG *psMsg);
void BeaconHandler_SetWmmParameters(uint8 vapIndex);
void BeaconHandler_QueueIsLocked(K_MSG *beaconHandlerMessage);
void BeaconHandler_QueueIsDisabled(K_MSG *beaconHandlerMessage);
void BeaconHandler_BeaconCsaStart(K_MSG *beaconHandlerMessage);
void BeaconHandler_BeaconCsaStop(K_MSG *beaconHandlerMessage);
void BeaconHandler_BeaconCsaLock(K_MSG *beaconHandlerMessage);
void BeaconHandler_BeaconCsaPd(K_MSG *beaconHandlerMessage);
bool beaconHandlerBssLoadIeIsSupported(uint8 vapId);
void beaconHandlerBssLoadIeSetIsSupported(uint8 vapId, bool isBssLoadIe);
void BeaconBlockingManagerAddVap(uint8 vapId, uint16 beaconInterval);
void BeaconBlockingManagerDisable(void);
void BeaconBlockingManagerSet(K_MSG* beaconBlockingManagerMessage);
void BeaconBlockingManagerStart(K_MSG* beaconBlockingManagerMessage);
void BeaconBlockingManagerStop(K_MSG* beaconBlockingManagerMessage);
void BeaconBlockingManagerRestart(K_MSG* beaconBlockingManagerMessage);
void BeaconBlockingManagerTimer(K_MSG* beaconBlockingManagerMessage);
#if defined (ENET_INC_ARCH_WAVE600)
void BeaconHandlerUpdateBssLoadIeAdmissionCapacity(K_MSG *kMsg_p);
#endif


#endif //BEACON_HANDLER_API_H_
