/***********************************************************************************
 File:			BeaconBlockingManager.h
 Module:			Beacon Blocking Manager
 Purpose: 		Manages beacon blocking
 Description:		This header is the API to the Beacon Blocking module
************************************************************************************/
#ifndef BEACON_BLOCKING_MANAGER_H_
#define BEACON_BLOCKING_MANAGER_H_


//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "shram_man_msgs.h"
#include "OSAL_Kmsg.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void BeaconBlockingManagerAddBeacon(uint8 vapId);
extern void BeaconBlockingManagerRemoveBeacon(uint8 vapId);
extern void BeaconBlockingManager_Init(void);



#endif //BEACON_BLOCKING_MANAGER_H_


