/***********************************************************************************
 File:			BeaconHandler_api.h
 Module:			Beacon Handler
 Purpose: 		Manages beacon HW configuration and preparing Beacon frames for transmission
 Description:		This header is the API to the Beacon Handler module
				which is responsible for configuring the Beacon HW and preparing Beacon frames
				for transmission.
************************************************************************************/
#ifndef BEACON_HANDLER_H_
#define BEACON_HANDLER_H_


//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "shram_man_msgs.h"
#include "OSAL_Kmsg.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
/* size of registers block for configuring a VAP */
#define REG_BEACON_HANDLER_VAP_CONFIG_SIZE	(REG_BEACON_VAP1_BEACON_ACTIVATE - REG_BEACON_VAP0_BEACON_ACTIVATE)

#define BEACON_FIELD_UPDATE_TYPE_DTIM_FIRST_PERIOD  0x1 
#define BEACON_FIELD_UPDATE_TYPE_CSA_COUNTER        0x2
#define BEACON_FIELD_UPDATE_TYPE_COLOR_COUNTER      0x3

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void beaconHandlerFlushIEsPdList(uint8 vapId);
void beaconHandlerSwapIEsPdList(uint8 vapId);
void beaconHandlerReleasePdList(uint8 vapId);
void beaconHandlerUpdateIEsPdList(uint8 vapId, BeaconHostBuffer_t*  pBuffersArray);
bool beaconHandlerIsVapActive(uint8 vapIdx);
void BeaconHandler_SetCsaOverwrite(uint8 vapId);
void BeaconHandler_SetVapVHT(uint8 vapId, bool isVht);

#endif //BEACON_HANDLER_H_


