/***********************************************************************************
 File:			BeaconHandler_api.h
 Module:			Beacon Handler
 Purpose: 		Manages beacon HW configuration and preparing Beacon frames for transmission
 Description:		This header is the API to the Beacon Handler module
				which is responsible for configuring the Beacon HW and preparing Beacon frames
				for transmission.
************************************************************************************/
#ifndef BEACON_CSA_MANAGER_H_
#define BEACON_CSA_MANAGER_H_


//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "shram_man_msgs.h"
#include "OSAL_Kmsg.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void BeaconCsaManagerAddVap(uint8 vapId, uint16 beaconInterval);
extern void BeaconCsaManagerRemoveVap(uint8 vapId);
extern void BeaconCsaManagerUpdateTemplate(uint8 vapId, BeaconHostBuffer_t *beaconBuffers);
extern void BeaconCsaManagerStartReq(K_MSG* beaconCsaManagerMessage);
extern void BeaconCsaManagerStopReq(K_MSG* beaconCsaManagerMessage);
extern void BeaconCsaManagerLockCfm(K_MSG* beaconCsaManagerMessage);
extern void BeaconCsaManagerPdCfm(K_MSG* beaconCsaManagerMessage);
extern bool BeaconCsaManagerCsaInProgress(void);
extern bool BeaconCsaManagerCsaRequired(void);
extern void BeaconCsaManagerBuildCsaIe(TxPd_t *pd);
extern bool BeaconCsaManagerCsaWrapperRequired(void);
extern void BeaconCsaManagerBuildCsaWrapperIe(TxPd_t *pd);
extern void BeaconCsaManager_Init(void);

#endif //BEACON_CSA_MANAGER_H_

