/***********************************************************************************
 File:		<ActionPoints_api.h>
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
#ifndef __ACTION_POINTS_API_H__
#define __ACTION_POINTS_API_H__


/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/


#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"


/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/


typedef enum ap_actionTarget
{
	AP_TARGET_INSTRUCTION_ADDRESS, 		// 0b0000, Instruction address Trigger on specified PC value.
	AP_TARGET_INSTRUCTION_DATA,	 		// 0b0001, Instruction data Trigger on specified instruction data.
	AP_TARGET_MEMORY_ADDRESS,			// 0b0010, Memory address Trigger on access to specific memory address, from processor core only.
	AP_TARGET_MEMORY_DATA,		 		// 0b0011, Memory data Trigger on a data value written to, or read from memory, from the processor core only.
	AP_TARGET_AUX_REGISTER_ADDRESS, 	// 0b0100, Auxiliary register address Trigger on access to specific auxiliary register address.
	AP_TARGET_AUX_REGISTER_DATA, 		// 0b0101, Auxiliary register data Trigger on data value written to, or read from an auxiliary register from the core only.
	AP_TARGET_EXTERNAL_PARAMETER_0, 	// 0b0110, External parameter 0 Trigger on a specific value.
	AP_TARGET_EXTERNAL_PARAMETER_1, 	// 0b0111, External parameter 1 Trigger on a specific value.
} ap_actionTarget_e;

typedef enum ap_transactionType
{
	AP_TRANSACTION_TYPE_DISABLED, 		// 0b00, Disable the associated actionpoint.
	AP_TRANSACTION_TYPE_WRITE,	 		// 0b01, Trigger when the transaction is a write and the target value matches.
	AP_TRANSACTION_TYPE_READ,		 	// 0b10, Trigger when the transaction is a read and the target value matches.
	AP_TRANSACTION_TYPE_WRITE_OR_READ, 	// 0b11, Trigger when the transaction is a write or read and the target value matches. If the target is memory, there is an implicit selection of the write data value.
} ap_transactionType_e;

typedef enum ap_mode
{
	AP_MODE_TRIGGER_IN_RANGE, 			// 0b0, Trigger when in range
	AP_MODE_TRIGGER_OUTSIDE_OF_RANGE,	// 0b1, Trigger when outside range
} ap_mode_e;

typedef enum ap_number
{
	ACTION_POINT_0, 			
	ACTION_POINT_1, 			
	ACTION_POINT_2, 			
	ACTION_POINT_3, 			
} ap_number_e;



/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/


// AP_AC (ActionPoint Control) registers - 0x222, 0x225, 0x228, 0x22B (we have only 4 action points)
typedef union
{
	uint32 val;
	struct
	{
		uint32 at			:4; // ActionPoint Target (values from ap_actionTarget_u)
		uint32 tt 			:2;	// Transaction type (values from ap_transactionType_u)
		uint32 m 			:1;	// Trigger Mode (values from ap_mode_u).
		uint32 p 			:1;	// Pair with next ActionPoint.
		uint32 aa 			:1;	// ActionPoint action (0x0 - halt processor, 0x1 - raise exception)
		uint32 q 			:1;	// Quad with next 3 ActionPoint.
		uint32 Reserved1	:22;
	} bitFields;

} RegApAc_u;


/*---------------------------------------------------------------------------------
/						Static Function Declaration
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/	

void ActionPoints_Disable(uint32 apNumber);
void ActionPoints_Set(uint32 apNumber, uint32 matchValue, uint32 matchMask, ap_actionTarget_e target, ap_transactionType_e type, ap_mode_e mode, bool isPair, bool isQuad);
void ActionPoints_Init(void);


#endif // #define __ACTION_POINTS_API_H__
