/***********************************************************************************
 File:		<RealTimeCounter_api.h>
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
#ifndef __REAL_TIME_COUNTER_API_H__
#define __REAL_TIME_COUNTER_API_H__


/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/


#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"


/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/

// RTC Control Register, AUX_RTC_CTRL - 0x103 
typedef union
{
	uint32 val;
	struct
	{
		uint32 enable				:1;		// Enables the RTC. A value of 0 means disabled; 1 means enable counting
		uint32 clear				:1;		// Clear the counter. A value of 1 clears the AUX_RTC_LOW and AUX_RTC_HIGH registers.		
		uint32 reserved0			:28;
		uint32 atomic0				:1;		// atomic0 and atomic1 bits track the atomicity of reads from the RTC Count High Register, AUX_RTC_HIGH and RTC Count Low Register,
		uint32 atomic1				:1;		// AUX_RTC_LOW registers. For the description of the state machine, see Figure 3-66 on page 180.
	} bitFields;
} RegRtcControl_u;


// RTC Count Low Register, AUX_RTC_LOW - 0x104 
typedef union
{
	uint32 val;
	struct
	{
		uint32 rtcLowValue			:32;	// LSB 32-bits of the free-running RTC
	} bitFields;
} RegRtcLow_u;


// RTC Count High Register, AUX_RTC_HIGH - 0x105
typedef union
{
	uint32 val;
	struct
	{
		uint32 rtcHighValue			:32;	// MSB 32-bits of the free-running RTC
	} bitFields;
} RegRtcHigh_u;



/*---------------------------------------------------------------------------------
/						Static Function Declaration
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/	
void GetRealTimeCounterValue(uint32 *RtcLowValue, uint32 *RtcHighValue);
uint32 GetRealTimeCounterLow(void);
uint32 GetRealTimeCounterHigh(void);
void RealTimeCounterInit(void);


#endif // #define __REAL_TIME_COUNTER_API_H__
