/***********************************************************************************
 File:		<mpu_api.h>
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
#ifndef __MPU_API_H__
#define __MPU_API_H__


/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/


#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"


/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/

// MPU Enable Register (MPU_EN) - 0x409 
typedef union
{
	uint32 val;
	struct
	{
		uint32 Reserved0		:3;
		uint32 UE 				:1;	// General Execute Permission.
		uint32 UW 				:1;	// General Write Permission.
		uint32 UR 				:1;	// General Read Permission.
		uint32 KE 				:1;	// Kernel-only Execute Permission.
		uint32 KW 				:1;	// Kernel-only Write Permission.
		uint32 KR 				:1;	// Kernel-only Read Permission.
		uint32 Reserved1		:21;
		uint32 EN 				:1; // Enables the MPU
		uint32 Reserved2		:1;		
	} bitFields;

} RegMPUEnable_u;

// MPU Region Descriptor Base Register (MPU_RDB)
typedef union
{
	uint32 val;
	struct
	{
		uint32 V 				:1;	// Valid.
		uint32 Reserved0		:4;
		uint32 baseAddress		:27;		
	
	} bitFields;
} RegMPU_RDB_u;

// MPU Region Descriptor Permissions Register (MPU_RDP)
typedef union
{
	uint32 val;
	struct
	{
		uint32 size0			:2; // size of the region - LSB
		uint32 Reserved0		:1; 
		uint32 UE				:1; // General Execute Permission.
		uint32 UW				:1; // General Write Permission.
		uint32 UR				:1; // General Read Permission.
		uint32 KE				:1; // Kernel-only Execute Permission.
		uint32 KW				:1; // Kernel-only Write Permission.
		uint32 KR				:1; // Kernel-only Read Permission.
		uint32 size1			:3; // size of the region - MSB.
		uint32 Reserved1		:20;
	} bitFields;

} RegMPU_RDP_u;

typedef enum {
	DISALLOW_REGION=0x0,
	ALLOW_REGION
} actionType_e;

typedef enum {
	NO_CONFIG=0x0,
	CONFIG
} configType_e;

typedef enum {
	READ_ACCESS=0x0,
	WRITE_ACCESS,
	EXECUTE
} accessType_e;


/*---------------------------------------------------------------------------------
/						Static Function Declaration
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Private Functions Definitions
/----------------------------------------------------------------------------------*/

void 	mpu_configRegsPair(uint32 regNumber, uint32 baseAddress, uint32 size, actionType_e action);
void 	mpu_BlockNullPointerWithReg0(void);
uint32 	mpu_getBiggestAlignedAddress(uint32 startAddress, uint32 endAddress);
uint32 	mpu_configRegs(uint32 address1, uint32 address2, configType_e config, actionType_e action, uint32 regNumber);
uint32 	mpu_get_closest_size(uint32 size);
uint32 	mpu_getBiggestAlignedBlockSize(uint32 address);
uint32 	mpu_get_index_from_size(uint32 size);
uint32 	mpu_checkFreeReg(void);


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/	
void		MpuInit(void);
RetVal_e	Mpu_protectRegion(uint32 address, uint32 size, actionType_e readAccess, actionType_e writeAccess, actionType_e executeAccess);


#endif // #define __MPU_API_H__ 
