/***********************************************************************************
 File:		<smart_api.h>
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
#ifndef __SMART_API_H__
#define __SMART_API_H__


/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/


#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"


/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/

#define SMART_STACK_SIZE	(256)	// Number of entries in the smart memory in HW

// Taken from the Smart documentation. Smart Control Register (0x700) 
typedef enum SmartControlIdx
{
	SMART_SRC_ADDR,		// 0x0
	SMART_DEST_ADDR,	// 0x1
	SMART_FLAGS,		// 0x2
	SMART_RESERVED,		// 0x4
} SmartControlIdx_e;

typedef enum SmartControlEn
{
	SMART_TRACE_DISABLED,	// 0x0
	SMART_TRACE_ENABLED,	// 0x1
} SmartControlEn_e;

/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/

// Smart control Register (SMART_CONTROL) - 0x700 
typedef union
{
	uint32 val;
	struct
	{
		uint32 En				:1;		// Enables the trace mechanism (SmartControlEn_e)
		uint32 reserved0		:7;
		uint32 Idx				:2;		// Controls which value is returned in the SMART_DATA register (SmartControlIdx_e)
		uint32 LocationPointer	:22;	// Sets the value of the stored instruction stack pointer.
	} bitFields;
} RegSmartControl_u;

// Smart Data Register (SMART_DATA flags) - 0x701 
typedef union
{
	uint32 val;
	struct
	{
		uint32 Reserved0		:8;
		uint32 UserMode			:1;		// Set if the processor is in user mode after program-flow change.
		uint32 Exception		:1;		// Indicates that the program-flow change is a result of an exception or interrupt
		uint32 Repeat			:1;		// Used to indicate that the same program-flow change occurred more than once
		uint32 Reserved1		:20;	//
 		uint32 Valid			:1;		// Indicates that the value in the stack is valid.
 	} bitFields;
} RegSmartDataFlags_u;


typedef struct _smartEntry
{
	uint32 				sourceAddress;
	uint32 				destinationAddress;
	RegSmartDataFlags_u flags;
} smartEntry_t;


/*---------------------------------------------------------------------------------
/						Static Function Declaration
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/	
void SmartDumpMemory(void);
void SmartDisable(void);
void SmartInit(void);


#endif // #define __SMART_API_H__
