; copyright(c) 2009; ARC International

.if $on(a601) || $lpc_width != 32
    ; arc601, 8-bit lp_count
    .define reduced_lp, 1
.else
    .define reduced_lp, 0
.endif

.if $lpc_width == 0
    .define removed_lp, 1
.else
    .define removed_lp, 0
.endif

.if $is_arcv2 && $core_version >= 0x41
    .define av2_interrupts, 1
.else
    .define av2_interrupts, 0
.endif

.define delay_slots, $on("delay_slots")

.if $defined(_SYNC_CACHE_BYPASS) && "\&DI\&" == ".di"
    ; cr98408 workaround hardware bug in AXI bridge by inserting sync
    ; between cache bypass loads and stores
    ; Note that this affects only bitfield-setting helpers in the "misc"
    ; group of routines.  Bitfield setting helpers do a load and then a store,
    ; and the sync is needed between them.  The compiler takes care of
    ; emitting sync surrounding the bit helper and misaligned memory helper
    ; routines so generally we don't need to insert sync inside the routines
    ; themselves.
    .macro sync_cache_bypass
	sync
    .endm
.else
    .macro sync_cache_bypass
    .endm
.endif

.macro sync_ccm
    .ifdef _SYNC_CCM
	sync
    .endif
.endm

.macro shiftvar,	op,dest,src,cnt
.ifdef __Xbarrel_shifter
    op dest,src,cnt
.else
    asr.f	%lp_count,cnt
    .if "\&dest\&" != "\&src\&"
    mov	dest,src
    .endif
    bnc		$1
    ; if shift count is odd, do the extra shift required
    op	dest,dest
    $1:
    lpnz	$2
    op	dest,dest
    op	dest,dest
    $2:
.endif
.endm

.macro shiftvar_nolp,	op,dest,src,cnt
    ; We sometimes want a version that doesn't use the loop mechanism if we
    ; might be in a context where the loop mechanism is already active.
    ; For example, bitfield helper functions can be generated inside of a
    ; ZD loop.  We also take care to preserve the flags since bit-helpers
    ; are designated as preserving them.
.ifdef __Xbarrel_shifter
    op dest,src,cnt
.else
    ; we rely on the assumption that cnt will never be the same as src or dest
    push	cnt
    .if "\&dest\&" != "\&src\&"
    mov	dest,src
    .endif
    bbit0	cnt, 0, $1
    ; if shift count is odd, do the extra shift required
    op	dest,dest
    $1:
    asr		cnt, cnt
    breq	cnt, 0, $3
    $2:
    op	dest,dest
    op	dest,dest
    sub	cnt, cnt, 1
    brne	cnt, 0, $2
    $3:
    pop		cnt
.endif
.endm

; shift by constant amount  (amount can't be 0)
; 
; Example:
;   shiftcon   ror, r0, r1, 2
;
.macro shiftcon,	op,dest,src,cnt	; shift by constant amount
.ifdef __Xbarrel_shifter
    op dest,src,cnt
.else
    op	dest,src
    .rep (cnt & 0x1f) - 1
	op	dest,dest
    .endr
.endif
.endm

.if $isa == "ARC" && $core_version <= 0x05
    .macro nop_a4
	nop
    .endm
.else
    .macro nop_a4
    .endm
.endif
