/*********************************************************************
(C) Copyright 2002-2015 Synopsys Corp.
*********************************************************************/
#include <string.h>
#include <stdlib.h>
//#include <alloca.h>

#include "performanceCounters_api.h"
#include "cache.h"
#include "smart_api.h"
#include "System_CoreTimersApi.h"
#include "RealTimeCounter_api.h"
#include "mpu_api.h"
#include "ErrorHandler_Api.h"
#include "ActionPoints_api.h"


extern int main(int, char *[]);
extern void _init_fast_interrupts(void);
void __arc_main(void);

int __main_at = 0;	// line number where main called, for iprof_ct.c

#if __CCAC__
#define WEAK __attribute__((weak))
#else
#define WEAK
#endif
extern WEAK char _fbss[], _ebss[];   /* defined by the linker */
extern WEAK char _fsbss[], _esbss[]; /* defined by the linker, or weak */


//
// This is the first C entry point of the ARC runtime library initialization.
//
void __arc_main(void) {


	// Zero the BSS before first access unless we've been instructed not to do so
	// by the debugger.
	memset( _fbss, 0, _ebss - _fbss );
	if (_fsbss != NULL)
	{
	    memset( _fsbss, 0, _esbss - _fsbss );
	}

	// Init the shadow bank register
	_init_fast_interrupts();


	// Configure cached/uncached regions (granularity of 256Mb - 0xX0000000:0xXfffffff)
	configureArcCacheRegions();


    // after initcopy and memset, invalidate the dcache to make sure the
    // data goes to memory in case of subsequent cache-bypass accesses.
    _invalidate_dcache();
	
	//init the arc timers
	System_CoreTimersInit();

	// Init the real time counter (cycle accurate. Can be used to measure time)
	RealTimeCounterInit();

	// Init the SMART debug module
	SmartInit();

	// Init MPU module
	MpuInit();

	// Init action points
	ActionPoints_Init();

	
	ErrorHandler_EnableDivideByZeroException();



	// call out to main.  This routine never returns.
    //_mwcall_main();
    __main_at = __LINE__ + 1;



	main(0,0);
    }

