/*
 * (c) Copyright (c) 2007 ARC International.
 */

#include <time.h>

/* set by debugger's -inform_target_speed=NNN (not yet implemented) */
unsigned long __TARGET_SPEED__ = 1;  // in Mhz.

unsigned long _timer_clocks_per_sec(void) {
    return __TARGET_SPEED__ * 1000000;
    }


enum {  t0_count = 0x21, t0_control = 0x22, t0_limit = 0x23,
	t1_count = 0x100, t1_control = 0x101, t1_limit = 0x102,
	timer_build = 0x75
        };

#define T0_PRESENT_MASK 0x100
#define T1_PRESENT_MASK 0x200

// The default timer can be set here.  It is intended to be used internally
// in the runtime library to support the clock() ansi function.
#define DEFAULT_TIMER 0

int _timer_present(int timer_no) {
    unsigned bcr = _lr(timer_build);
    unsigned ver = bcr & 0xff;
    if (ver == 0) return 0;
    else if (ver == 1) return 1;
    else if (timer_no == 0)
	return ((bcr & T0_PRESENT_MASK) != 0);
    else if (timer_no == 1)
	return ((bcr & T1_PRESENT_MASK) != 0);
    else return 0;
    }

int _timer0_present(void) {
    return _timer_present(0);
    }
int _timer1_present(void) {
    return _timer_present(1);
    }
int _timer_default_present(void) {
    return _timer_present(DEFAULT_TIMER);
    }


void _timer_reset(int timer_no) {
    // the sequence here is based on the recommendations in the ARC700 PRM
    unsigned ctrl, t_control, t_count, t_limit;
    if (_timer_present(timer_no)) {
	if (timer_no == 0) {
	    t_control = t0_control; t_count = t0_count; t_limit = t0_limit;
	    }
	else if (timer_no == 1) {
	    t_control = t1_control; t_count = t1_count; t_limit = t1_limit;
	    }
	else
	    return;
	ctrl = _lr(t_control);
	_sr(0, t_control);  // disable timer interrupts while programming
    #if _ARCOMPACT
	_sr(0xffffffff, t_limit);
    #else
	// A4 timers are  only 24-bits wide.
	_sr(0x00ffffff, t_limit);
    #endif
	_sr(ctrl | 2, t_control);  // count only when processor running
	_sr(0, t_count);
	}
    }

void _timer0_reset(void) {
    _timer_reset(0);
    }
void _timer1_reset(void) {
    _timer_reset(1);
    }
void _timer_default_reset(void) {
    _timer_reset(DEFAULT_TIMER);
    }

unsigned _timer_read(int timer_no) {
    if (_timer_present(timer_no)) {
	if (timer_no == 0)
	    return _lr(t0_count);
	else if (timer_no == 1)
	    return _lr(t1_count);
	}
    return 0;
    }

unsigned _timer0_read(void) {
    return _timer_read(0);
    }
unsigned _timer1_read(void) {
    return _timer_read(1);
    }
unsigned _timer_default_read(void) {
    return _timer_read(DEFAULT_TIMER);
    }
