;/***********************************************************************************
;File:			bootloader.s		
;Module:		 
;Purpose:		 
;Description:	This file implements the Ecxeption/Timers/Interrupt Vector Table
;************************************************************************************/



.file "bootLoader.s"
#include "MT_Build_Config.h"

.section .bootloader,text
;; This directive forces this section to stay resident even if stripped out by the -zpurgetext linker option
.sectflag .bootloader,include

.long	_bootloader;								// Common entry point for all ARCs. Pointer to a common function.


/**********************************************************************************

_bootloader

Description:
------------
	This function is common for all ARCs. It identify which ARC is it,
	Reallocate the vectors table and jump to the init of that ARC.
Input:
-----
	None	
Output:
-------
	None		
Returns:
--------
	None
**********************************************************************************/	
.global	_bootloader
.type	_bootloader, @function
_bootloader:

	lr		r0, [IDENTITY]			; Get IDENTITY register. Bits 8-15 are "arcnum" (0=LM0, 1=LM1, 2=UM)
	xbfu	r1, r0, 8, 8			; extract bitfield (8 bits, starting bit 8). Get only the 8 bits on "arcnum"
	cmp		r1, 2					; Compare arcnum to "2" which is UM
	beq		_upperMacload			; if ARC is UM, go to UM handler.
	cmp		r1, 0					; Compare arcnum to "0" which is LM0 (connected to single band HW)
	beq		_lowerMac0load			; if ARC is LM0, go to LM0 handler.

_lowerMac1load:						; fallthrough to LM1 handler.

	mov		r2, _fvectors_lm1		; Get the first adress of LM1, where vectors are loaded.
	b		_setVectorsAndStart		; Jump to common part. 

_lowerMac0load:

	mov		r2, _fvectors_lm0		; Get the first adress of LM1, where vectors are loaded.
	b 		_setVectorsAndStart		; Jump to common part. 

_upperMacload:
	mov		r2, _fvectors_um		; Get the first adress of LM1, where vectors are loaded. (fallthrough to "_setVectorsAndStart")

_setVectorsAndStart:
	sr		r2, [INT_VECTOR_BASE]	; Set the first adress of this ARC as his VECTOR address.
	ld		r3, [r2, 0]				; Get the address of the start function in VECTORS[0]
	j		[r3]					; Jump to the start function from VECTORS[0]



