/***********************************************************************************
 File:		<cache.c>
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "cache.h"
#include "arc_reg.h"

/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/	

/**********************************************************************************

configureArcCacheRegions()

Description:
------------
Set the boundry in memory, from which a non-cached are begins.

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void configureArcCacheRegions(void)
{
	uint32 regValue;

	regValue = AUX_NON_VOLATILE_LIMIT_VALUE;
	
	// Configure the uncached region (0xA0000000). The 4 MSbits are not connected to real physical address. It's jsut used for non-cache access.
	_sr(regValue, REG_AUX_NON_VOLATILE_LIMIT);
}


/**********************************************************************************

sys_flush_caches()

Description:
------------
First flush entire DCACHE, then invalidate entire ICACHE

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void sys_flush_caches(void)
{
	_invalidate_icache();
	_invalidate_dcache();
}


