; Copyright (c) 2000-2009 ARC International
	.file	"crt1.s"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Startup
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	.extern __arc_main
	.extern	main; in case main is in user library (like eembc tests)
	.text
	.weak	_SDA_BASE_

	.macro jmpl,target
	    .if $core_version > 5
		jl	target		; "large" model call
	    .else
		lr	%blink, [%status]
		add	%blink, %blink, 3
		j	target
	    .endif
	.endm

	.if $isa == "ARC" && $core_version <= 0x05
	    .macro nop_a4
		nop
	    .endm
	.else
	    .macro nop_a4
	    .endm
	.endif

	.if $arc_family == "ARC600"
	    ; st825222 sometimes a nop is needed after a BRcc instr:
;Since the BRZ_S here has a positive offset then it is predicted not taken.
;The following jump is fetched and moves through the pipeline one stage behind
;the BRZ_S. The BRZ_S does not resolve until it reaches the final stage (5)
;of the pipeline, but the jump is taken from stage 3, so before the BRZ_S can
;resolve and kill the incorrect instructions in the pipe, the jump has caused
;the PC to change to the value from r2 and a fetch from this address to be made.
	    .macro nop_a6
		nop
	    .endm
	.else
	    .macro nop_a6
	    .endm
	.endif

    .if $isa == "ARCompact"
    	.on	assume_short, assume_nop_short
	.define S, _s
    .else
	.define S,
    .endif

	.global	_start
	.type	_start, @function
_start:
.if $arc_family != "ARC700"
	; for ram-based registers files! If you use flop-based, then
	; this code can be commented out. A700 family is always flop-based
	; and those come up in a known state.

	; Initialize the register file.  This is necessary because
	; of an idiosyncracy of the register file implementation.
	; Compiled code may generate sub  r0, r1, r1, expecting to
	; load 0 into r0, but the individual reads of r1 for the two source
	; operands may return different (garbage) values if r1 had never
	; been written to since reset.

    .ifdef _ARC_RF16
	.irep num, 1, 2, 3, 10, 11, 12, 13, 14, 15
		mov	r\&num, 0
	.endr
    .else
	.irep num, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25
		mov	r\&num, 0
	.endr
    .endif

.endif

	.weak __xcheck

.ifndef _PICTABLE
    .if $isa == "ARCompact"
	mov	r0, __xcheck
	breq\&S	r0, 0, .Lsetstack
	nop_a6
	jl	[r0]
    .else
        mov.f	r0, __xcheck
	nop_a4
	beq	.Lsetstack
	mov	r0, 0
	jmpl	__xcheck	; check compiled extensions against ARC build
    .endif
.else
	; under PICTABLE, r0 is assumed to contain the base of the data segment
	; so must preserve it.  __xcheck modifies only r0 and r1 and is
	; position-independent
	mov	r2, r0
        mov.f	r0, __xcheck
	nop_a4
	beq	.Linit_pic

	bl	__xcheck

    .Linit_pic:
	mov	r0, r2
	.weak	__PICTABLE__
	; In PIC mode, we assume that we were loaded by a loader and may not
	; reside at the addresses that the ELF file was linked with.  In
	; this case, the address of where the data segment has been loaded
	; is passed to _start in the r0 register.  We figure out the new code
	; segment base ourselves.
	mov	r2, __PICTABLE__
	sub.f	0, r2, 0
	nop		; required for -a4 -core5
	beq	no_pic
	bl	_init_pic

no_pic:
.endif

    .Lsetstack:
	mov	sp, _estack	; initialize stack pointer
	mov	gp, _SDA_BASE_	; initialize small-data base register
    .if $isa == "ARCompact"
	.cfa_bf	_start

	.if $is_arcv2
	    .define INIT_JLI, _init_jli
	.else
	    .define INIT_JLI, _init_spe
	.endif
	.weak	INIT_JLI
	; must do this after %sp %gp are setup
    	mov	%r2, INIT_JLI
	breq\&S	%r2, 0, .Lcheck_ldi
	nop_a6
	jl	[%r2]
    .Lcheck_ldi:
	.if $is_arcv2
	.weak	_init_ldi
	.weak	_init_ei
	.weak	_init_ad
	mov	%r2, _init_ldi
	breq\&S	%r2, 0, .Lcheck_ei
	jl	[%r2]
    .Lcheck_ei:
	mov	%r2, _init_ei
	breq\&S	%r2, 0, .Lcheck_ad
	jl	[%r2]
    .Lcheck_ad:
	mov	%r2, _init_ad
	breq\&S	%r2, 0, .Lcheck_end
	jl	[%r2]
    .Lcheck_end:
        .endif

    .if 0
	; this code is faster but larger
	mov.f	r2,INIT_JLI
	jlnz	[%r2]

	.if $is_arcv2
	.weak	_init_ldi
	mov.f	r2,_init_ldi
	jlnz	[%r2]

	.weak	_init_ei
	mov.f	r2,_init_ei
	jlnz	[%r2]

	.weak	_init_ad
	mov.f	r2,_init_ad
	jlnz	[%r2]
	.endif
    .endif


    .else
	; $isa is not ARCompact
	sub	sp, sp, 16	; allocate expected call frame
    .endif
	mov	fp, 0		; initialize frame pointer
	jmpl	__arc_main
	b	_exit_halt
	.reloc	main, 0; force main in if its in a library
	.if $isa == "ARCompact"
	.cfa_ef
	.endif


	.global	_exit_halt
	.type	_exit_halt, @function
_exit_halt:
	.if $isa == "ARCompact"
	.cfa_bf	_exit_halt
	.endif

	flag	0x01
	nop
    .if ! $is_arcv2
	; ARC 700 serializes on 'flag', so no way to get back to here.
	nop
	nop
    .endif
	b	_exit_halt

	.if $isa == "ARCompact"
	.cfa_ef
	.endif

	; weak versions of small data symbols normally defined by the linker.
	.weak	_fsbss
	.weak	_esbss
	.set	_fsbss,0
	.set	_esbss,0

	; weak versions of BSS section symbols in case there is no .bss section
	.weak	_fbss
	.weak	_ebss
	.set	_fbss,0
	.set	_ebss,0

	; weak versions of heap section boundaries.  If a .heap section
	; is provided, our low-level allocator "sbrk" allocates within it.
	; If no .heap is provided, we allocate from _end to the end of memory.
	.weak	_fheap
	.weak	_eheap
	.set	_fheap,0
	.set	_eheap,0

	; reference the beginning of the stack for debugger's stack checking
	.weak	_fstack
	.set	_fstack,0

	.end

