

#include "MT_Build_Config.h"


/**********************************************************************************

_fast_interrupt_handler

Description:
------------
	this is the fast interrupt main handler. It assumes shadow set is used for
	all interrupts with fast IRQ and HW Stack Check is on.
Input:
-----
	None	
Output:
-------
	None		
Returns:
--------
	None
**********************************************************************************/	
.global	_fast_interrupt_handler
.type	_fast_interrupt_handler, @function
_fast_interrupt_handler:

	// The following section is responsible to get the most updated SP from register bank 0.
	
	lr		r0, [LP_START]		; We use LP_START as a temp register. Store its content
	mov 	r4, ilink			; We use ilink (R29) as a temp register. Store its content
	lr		ilink, [STATUS32]	; Get the value of status32 after interrupt. RB is currently 1.
	bclr	ilink, ilink, 16	; Change the RB to 0 in order to move to register bank 0
	kflag	ilink				; Apply status32 changes (trigger a switch to bank 0)
	sr 		sp, [LP_START]		; Store SP from bank0 into LP_START (just a temp register in AUX space) 
	bset	ilink, ilink, 16	; Change the RB to 1 in order to move back to register bank 1 and do the ISR (ilink is not per bank)
	kflag	ilink				; Apply status32 changes (trigger a switch to bank 1)
	lr		sp, [LP_START]		; Get the value of SP which was stored before in LP_START
	sr		r0, [LP_START]		; Recover the value of LP_START to the original value
	mov 	ilink, r4			; Recover the value of ilink (R29) to the original value


    bl      _tx_thread_context_fast_save


	// Check which interrupt has occurred and activate the ISR
	
	lr 		r2, [ICAUSE]								; ICAUSE holds the active interrupt number of the highest active priority in AUX_IRQ_ACT (always priority 0 in our code)
	sub 	r2, r2, 16
	ld.as	r3, [InterruptManagerIsrHandlersArc, r2]	; Get the address of the ISR from the interrupt handlers table
	jl		[r3]

	// ISR is done. Now wrap up this interrupt and go back to task (UM - threadx / LM - just return)
   b       _tx_thread_context_fast_restore



/**********************************************************************************

_fast_interrupt_handler

Description:
------------
	this is the fast interrupt main handler. It assumes shadow set is used for
	all interrupts with fast IRQ and HW Stack Check is on.
Input:
-----
	None	
Output:
-------
	None		
Returns:
--------
	None
**********************************************************************************/	
.align 4
.global	_init_fast_interrupts
.type	_init_fast_interrupts, @function
_init_fast_interrupts:
    sub     sp, sp, 8                                   ; Build a small stack frame to hold the setup information
    st      gp, [sp, 0]                                 ; Save gp in the frame
    mov     ilink, sp                                   ; Move the stack frame into ilink
    lr      r3, [status32]                              ; Pickup status32 register
    bset_s  r3, r3, 16                                  ; Build new status32 register
    kflag   r3                                          ; Move to the hardware register bank
    mov     r0, ilink                                   ; Place stack pointer in r0
    mov     fp, 0                                       ; Setup fp
    ld      gp, [r0, 0]                                 ; Setup gp
    mov     blink, 0                                    ; Setup blink
    mov     r0, 0                                       ; Clear r0
    lr      r3, [status32]                              ; Pickup status32 register
    bclr    r3, r3, 16                                  ; Build register bank 0 value
    kflag   r3                                          ; Move back to register bank 0
    j_s.d   [blink]                                     ; Return to caller
    add     sp, sp, 8                                   ;




