; (C) Copyright (c) 2002-2007 ARC International;  Santa Cruz, CA 95060
;
; $Id: invcache.s,v 1.2 2000/06/12 02:54:25 marcusm Exp $
;
; $Log: invcache.s,v $
; Revision 1.2  2000/06/12 02:54:25  marcusm
; Added code for data cache invalidate.
;
;
; CR896 ARCompact icache invalidate rarely caused fetch of LIMM as instruction
; Kevin Delaney
;
; Revision 1.1  2000/06/11 23:56:32  marcusm
; libinstall on file owned by: marcusm
;
;

;
; These routines to invalidate the Instruction and Data caches
; may need to be changed by the customer, since the method is not
; fixed by ARC.
;
	.file	"invcache.s"
	#include "miscmacro.i"

	.if $isa == "ARCompact"
	    .option	assume_short
	    .macro	nop_a4
		; no nop required for ARCompact.
	    .endm
	.else
	    .off	emit_cfa
	    .macro	nop_a4
		nop
	    .endm
	.endif

; In the standard way of doing things, any write to the AUX_IVIC register
; serves to invalidate the cache.  By writing the same value as the
; aux register value, we can encode the instruction in one 4-byte word.
	.define I_CACHE_BUILD, 0x77
	.define AUX_IVIC, 0x10
	.global	_invalidate_icache
	.type	_invalidate_icache, @function
	.align	4
_invalidate_icache:
	.cfa_bf	_invalidate_icache
    .if $isa == "ARC"		// OSur isa is not "ARC". It's "ArCompact"
	j.d	[blink]
	sr	AUX_IVIC, [AUX_IVIC]
    .else
	; cr90953, cr90955
	; first check for the presence of a icache and do nothing if no cache.


// **** Our ARC has cache so those checks are redundant. It can be removed if we choose to.
	
	lr	r0, [IDENTITY]
	lr	r1, [I_CACHE_BUILD]
	; if the build reg is equal to the identity reg or the version field is
	; 0, assume no icache.
	cmp_s	r0, r1
	and.ne.f	r1, r1, 0xff
	jeq	[blink]

// **** End of redundant section

	mov	r0, 0
	sr	r0, [AUX_IVIC]

	; cr91374
	; The IVIC causes the processor to lock up in the case where Bcc,
        ; LPcc, BBITx, Jcc, BL is in the shadow of the IVIC where the PC
	; is pointing to misaligned address. An IVIC should be followed by
	; 3 NOPs (or atleast linear instructions) before having non-linear
	; instruction.
	nop
	nop
	nop


    .if delay_slots
	j.d	[blink]
	nop     ; CR896
    .else
	j	[blink]
	; no cr896 hardware workaround in this case but shouldn't be needed now.
    .endif

    .endif
	.cfa_ef


	.define D_CACHE_BUILD, 0x72
	.define DC_IVDC, 0x47
	.define DC_CTRL, 0x48
	.define FS_MASK, 0x100
	.global	_invalidate_dcache
	.type	_invalidate_dcache, @function
	.align	4
_invalidate_dcache:
	.cfa_bf	_invalidate_dcache

// **** Our ARC has cache so those checks are redundant. It can be removed if we choose to.

	; first check for the presence of a dcache and do nothing if no cache.
	lr	r1, [D_CACHE_BUILD]
	and.f	r1, r1, 0xff  ; check the version field--must be non-zero
	nop_a4
	jeq	[blink]

// **** End of redundant section

	lr	r1, [DC_CTRL]
	mov	r0, 0xc2	;set to invalidate and flush, flush locked lines
	sr	r0, [DC_CTRL]
	mov	r0, 1
	sr	r0, [DC_IVDC]	;invalidate (and flush)
	; now poll Flush Status bit to wait for operation to complete
dcache_wait:
	lr	r0, [DC_CTRL]
	and.f	r0, r0, FS_MASK
	nop_a4
	bnz	dcache_wait
    .if delay_slots
	j.d	[blink]
	sr	r1, [DC_CTRL]	; restore control register
    .else
	sr	r1, [DC_CTRL]	; restore control register
	j	[blink]
    .endif

	.cfa_ef
	.end

