; Copyright (c) 2002-2004 ARC International
; 
; Routines for performing double-word  arithmetic shift right for ARC
; ARC5+ (w/ barrel-shift)
; Inputs:  r0,r1 = operand
;          r2 = shift amount
; Outputs: r0,r1 = result
;
	.file	"lsrabs.s"
	.include "miscmacro.i"
    .if $isa == "ARCompact"
	.option isa_ac, assume_short
	.define DF,
    .else
	.option isa_arc
	.off	emit_cfa
	.define DF, .f
    .endif
    .if $isa == "ARC" && $core_version <= 0x05
	.macro nop_a4
	    nop
	.endm
    .else
	.macro nop_a4
	.endm
    .endif
	.text


	.ifdef _BE
	.define rlo,r1
	.define rhi,r0
	.else
	.define rlo,r0
	.define rhi,r1
	.endif

	.global _Lsrabs
	.cfa_bf	_Lsrabs
	.align 4
_Lsrabs:
    .if $isa == "ARCompact"
	bmsk.f	r2,r2,5
	jz	[blink]
	rsub.f	r3,r2,32
    .else
	and.f	r2,r2,0x3f
	nop_a4
	jz\&DF	[blink]
	sub.f	r3,32,r2
	nop_a4
    .endif
	ble	.L1
	// 32 bit shift
	asl	r12,rhi,r3
	asr	rhi,rhi,r2
	lsr	rlo,rlo,r2
    .if delay_slots
	j.d\&DF	[blink]
	or	rlo,rlo,r12
    .else
	or	rlo,rlo,r12
	j\&DF	[blink]
    .endif
.L1:
	// 64 bit shift
    .if $isa == "ARCompact"
	neg	r3,r3
    .else
	sub	r3, 0, r3
    .endif
	asr	rlo,rhi,r3
    .if delay_slots
	j.d\&DF	[blink]
	asr	rhi,rhi,31
    .else
	asr	rhi,rhi,31
	j\&DF	[blink]
    .endif
	.cfa_ef


