/***********************************************************************************
 File:		<smart.c>
 Module:		
 Purpose:	driver for the SMART (small real time trace) feature of the ARC		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "string.h"
#include "arc_reg.h"
#include "arc_intrinsics.h"
#include "smart_api.h"

/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables
/----------------------------------------------------------------------------------*/

//Dump of the SMART memory. Line 0 is always the newest.
smartEntry_t smartDump[SMART_STACK_SIZE];


/*---------------------------------------------------------------------------------
/						Static Functions Definitions
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/	


/**********************************************************************************

SmartDumpMemory()

Description:
------------
Take a dump of the SMART memory for offline debugging.

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void SmartDumpMemory(void)
{
	RegSmartControl_u 	regSmartControl;
	uint32				smartStackIndex = 0;

	regSmartControl.val = 0;

	// Loop over all lines in SMART memory
	for (smartStackIndex = 0 ; smartStackIndex < SMART_STACK_SIZE ; smartStackIndex++)
	{
		// Configure which line we want to dump from SMART memory
		regSmartControl.bitFields.LocationPointer = smartStackIndex;

		// Get the source address
		regSmartControl.bitFields.Idx = SMART_SRC_ADDR;
		_sr(regSmartControl.val, SMART_CONTROL);	
		smartDump[smartStackIndex].sourceAddress = _lr(SMART_DATA);

		// Get the destination address
		regSmartControl.bitFields.Idx = SMART_DEST_ADDR;
		_sr(regSmartControl.val, SMART_CONTROL);	
		smartDump[smartStackIndex].destinationAddress = _lr(SMART_DATA);

		// Get the flags
		regSmartControl.bitFields.Idx = SMART_FLAGS;
		_sr(regSmartControl.val, SMART_CONTROL);	
		smartDump[smartStackIndex].flags.val = _lr(SMART_DATA);		
	}
}


/**********************************************************************************

SmartDisable()

Description:
------------
Disable the SMART module (stop recording)

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void SmartDisable(void)
{
	RegSmartControl_u regSmartControl;

	regSmartControl.val = 0;
	
	// turn off the SMART feature
	regSmartControl.bitFields.En = SMART_TRACE_DISABLED;
	_sr(regSmartControl.val, SMART_CONTROL);
}

/**********************************************************************************

SmartInit()

Description:
------------
Initialize smart (small real time trace) module - Turn it on and clean the dump array

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void SmartInit(void)
{
	RegSmartControl_u regSmartControl;

	regSmartControl.val = 0;
	
	// Initialize the memory dump array
	memset(&smartDump[0], 0, (sizeof(smartEntry_t)*SMART_STACK_SIZE));

	// turn on the SMART feature
	regSmartControl.bitFields.En = SMART_TRACE_ENABLED;
	_sr(regSmartControl.val, SMART_CONTROL);

}


