/***********************************************************************************
 File:		<stackCheck.c>
 Module:		
 Purpose:		
 Description:	
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes
/----------------------------------------------------------------------------------*/

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "arc_reg.h"
#include "arc_intrinsics.h"
#include "stackCheck_api.h"

/*---------------------------------------------------------------------------------
/						Defines
/----------------------------------------------------------------------------------*/

// _fSECTION_NAME and _eSECTION_NAME are the start/end of a given section (It's defined by ARC linker).
extern char _fstack[];
extern char _estack[];



/*---------------------------------------------------------------------------------
/						Macros
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/	

/**********************************************************************************

StackCheckChangeStackLocation()

Description:
------------
Configure stack checking in ARC HW to point at a given stack location (doesn't change feature enable/disable)

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void StackCheckChangeStackLocation(uint32 stackBaseAddress, uint32 stackTopAddress)
{
	// Mark the beginning and end of system stack (section .stack)
	_sr(stackBaseAddress, KSTACK_BASE);
	_sr(stackTopAddress, KSTACK_TOP);
}


/**********************************************************************************

StackCheckInit()

Description:
------------
Configure stack checking in ARC HW to point at system stack and turn on the feature

Input:
-----

Output:
-------

Returns:
--------

**********************************************************************************/
void StackCheckInit(void)
{
	uint32 regStatus32;

	// Mark the beginning and end of system stack (section .stack)
	//_sr((int)_estack, KSTACK_BASE);
	//_sr((int)_fstack, KSTACK_TOP);
	StackCheckChangeStackLocation((uint32)_estack,(uint32)_fstack);

	// Get value in status32 register
	regStatus32 = _lr(REG_STATUS32);

	// Enable the feature by turning on the stack checking bit. If for some reason we need to turn it off -clear this bit.
	regStatus32 |= REG_STATUS32_SC_BIT;

	// Write status32 back (it is composed of "flags"). NOP is needed after it.
	_kflag(regStatus32);
	_nop();
}


