;/***********************************************************************************
;File:			vectors.s		
;Module:		 
;Purpose:		 
;Description:	This file implements the Ecxeption/Timers/Interrupt Vector Table
;************************************************************************************/



.file "vectors.s"
#include "MT_Build_Config.h"

#if defined (ENET_INC_UMAC)
.section .vectors_um,text
;; This directive forces this section to stay resident even if stripped out by the -zpurgetext linker option
.sectflag .vectors_um,include
#endif

#if defined (ENET_INC_LMAC0)
.section .vectors_lm0,text
;; This directive forces this section to stay resident even if stripped out by the -zpurgetext linker option
.sectflag .vectors_lm0,include
#endif
#if defined (ENET_INC_LMAC1)
.section .vectors_lm1,text
;; This directive forces this section to stay resident even if stripped out by the -zpurgetext linker option
.sectflag .vectors_lm1,include
#endif

;//	name											type 			number 			name               	offset in IVT (hex/dec)

//start exception
.long	_start;										//exception   	0   			program entry point	offset  0x0     0

;//error exception
.long	_exceptionHandler;							//exception   	1   			memory_error       	offset  0x4     4
.long	_exceptionHandler;      					//exception   	2  				instruction_error   offset  0x8     8
.long	_exceptionHandler;      					//exception   	3   			EV_MachineCheck     offset  0xC     12
.long	_exceptionHandler;     						//exception   	4   			EV_TLBMissI         offset  0x10    16
.long	_exceptionHandler;      					//exception   	5   			EV_TLBMissD        	offset  0x14    20
.long	_exceptionHandler;      					//exception   	6   			EV_ProtV            offset  0x18    24
.long	_exceptionHandler;      					//exception   	7   			EV_PrivilegeV       offset  0x1C    28
.long	_exceptionHandler;      					//exception   	8   			EV_SWI              offset  0x20    32
.long	_trapExceptionHandler;     					//exception   	9   			EV_Trap             offset  0x24    36
.long	_exceptionHandler;      					//exception   	10  			EV_Extension       	offset  0x28    40
.long	_exceptionHandler;      					//exception   	11  			EV_DivZero          offset  0x2C    44
.long	_exceptionHandler;     						//exception   	12  			EV_DCError          offset  0x30    48
.long	_exceptionHandler;      					//exception   	13  			EV_Maligned         offset  0x34    52
.long	_exceptionHandler;     						//exception   	14  			unused             	offset  0x38    56
.long	_exceptionHandler;      					//exception   	15  			unused              offset  0x3C    60

;//IRQ Timers
.long	_fast_interrupt_handler;					// IRQ        	16  			Timer 0             offset  0x40    64
.long	_fast_interrupt_handler;					// IRQ        	17  			Timer 1             offset  0x44    68

;//interrupts																															unmapped 		mapped 		arc
																												
.long	_fast_interrupt_handler;					// IRQ        	18  			IRQ		           	offset  0x48    72				22				1			18
.long	_fast_interrupt_handler;					// IRQ        	19  			IRQ		           	offset  0x4C    76				23				2			19
.long	_fast_interrupt_handler;					// IRQ        	20  			IRQ		           	offset  0x50    80				--				--			--
.long	_fast_interrupt_handler;					// IRQ        	21  			IRQ		           	offset  0x54    84				19				3			21
.long	_fast_interrupt_handler;					// IRQ        	22  			IRQ		           	offset  0x58    88				10				4			22
.long	_fast_interrupt_handler;					// IRQ        	23  			IRQ		           	offset  0x5c    92				24				5			23
.long	_fast_interrupt_handler;					// IRQ        	24  			IRQ		           	offset  0x60    96				25				6			24
.long	_fast_interrupt_handler;					// IRQ        	25  			IRQ		           	offset  0x64    100				13				7			25
.long	_fast_interrupt_handler;					// IRQ        	26  			IRQ		           	offset  0x68    104				27				8			26
.long	_fast_interrupt_handler;					// IRQ        	27  			IRQ		           	offset  0x6c    108				26				9			27
.long	_fast_interrupt_handler;					// IRQ        	28  			IRQ		           	offset  0x70    112				21				12			28
.long	_fast_interrupt_handler;					// IRQ        	29  			IRQ		           	offset  0x74    116				--				--			--
.long	_fast_interrupt_handler;					// IRQ        	30  			IRQ		           	offset  0x78    120
.long	_fast_interrupt_handler;					// IRQ        	31  			IRQ		           	offset  0x7c    124
.long	_fast_interrupt_handler;					// IRQ        	32  			IRQ		           	offset  0x80    128
.long	_fast_interrupt_handler;					// IRQ        	33  			IRQ		           	offset  0x84    132
.long	_fast_interrupt_handler;					// IRQ        	34  			IRQ		           	offset  0x88    136
.long	_fast_interrupt_handler;					// IRQ        	35  			IRQ		           	offset  0x8c    140
.long	_fast_interrupt_handler;					// IRQ        	36  			IRQ		           	offset  0x90    144
.long	_fast_interrupt_handler;					// IRQ        	37  			IRQ		           	offset  0x94    148
.long	_fast_interrupt_handler;					// IRQ        	38  			IRQ		           	offset  0x98    152
.long	_fast_interrupt_handler;					// IRQ        	39  			IRQ		           	offset  0x9c    156
.long	_fast_interrupt_handler;					// IRQ        	40  			IRQ		           	offset  0xA0   	160
.long	_fast_interrupt_handler;					// IRQ        	41  			IRQ		           	offset  0xA4   	164
.long	_fast_interrupt_handler;					// IRQ        	42  			IRQ		           	offset  0xA8   	168
.long	_fast_interrupt_handler;					// IRQ        	43  			IRQ		           	offset  0xAc   	172
.long	_fast_interrupt_handler;					// IRQ        	44  			IRQ		           	offset  0xB0   	176
.long	_fast_interrupt_handler;					// IRQ        	45  			IRQ		           	offset  0xB4   	180
.long	_fast_interrupt_handler;					// IRQ        	46  			IRQ		           	offset  0xB8  	184
.long	_fast_interrupt_handler;					// IRQ        	47  			IRQ		           	offset  0xBc  	188
.long	_fast_interrupt_handler;					// IRQ        	48  			IRQ		           	offset  0xC0  	192
.long	_fast_interrupt_handler;					// IRQ        	49  			IRQ		           	offset  0xC4   	196



