/* CMSynergyVer %full_filespec: mt_cachedefs.h;3:incl:1 % */
#ifndef __MT_CACHEDEFS_H__
#define __MT_CACHEDEFS_H__

#include "System_GlobalDefinitions.h"

/*****************************************************************************
*        Global Definitions
*****************************************************************************/
//#if defined(MT_GLOBAL)
//   #define extern
//   #define I(x) x
//#else
//   #define extern extern
//   #define I(x)
//#endif

/* Platform attributes */
extern uint32 sys_processor;
extern uint32 sys_platform;
extern uint32 sys_corecard;
extern uint32 sys_manid;
extern uint32 sys_manpd;
extern uint32 sys_nb_base;
extern uint32 sys_ramsize;
extern uint32 sys_freemem;

/* CPU attributes */
extern uint8   sys_64bit;
extern uint8   sys_mips32_64;
extern uint8   sys_mips16e;
extern uint8   sys_smallpage_support;
extern uint8   sys_ejtag;
extern uint8  sys_arch_rev;
extern uint32 sys_fpu;

/* CPU support for hw cache coherency */
extern uint8   sys_cpu_cache_coherency;

/* Level 2 cache configuration */
extern uint8   sys_l2cache;
extern uint8   sys_l2cache_enabled;
extern uint32 sys_l2cache_lines;
extern uint32 sys_l2cache_linesize;
extern uint32 sys_l2cache_assoc;

/* Level 1 cache configuration */
extern uint32 sys_icache_linesize;
extern uint32 sys_icache_lines;
extern uint32 sys_icache_assoc;
extern uint32 sys_dcache_linesize;
extern uint32 sys_dcache_lines;
extern uint32 sys_dcache_assoc;

/* Array with count type */
typedef struct
{
    uint32 count;
    uint32 *array;
}
t_sys_array;

/* Structure for holding data for cpu configuration */
typedef struct
{
    uint32 i_bpw;
    uint32 i_assoc;
    uint32 d_bpw;
    uint32 d_assoc;
    uint8   mmu_tlb;  /* TRUE -> TLB, FALSE -> Fixed */
}
t_sys_cpu_decoded;

void sys_cpu_config( uint8 icache, uint8 dcache, 
			uint32 i_bpw, uint32 i_assoc, uint32 d_bpw, uint32 d_assoc );
void sys_cpu_cache_bpw( uint8 icache, t_sys_array  *sys_array );
void sys_cpu_cache_assoc( uint8 icache,  t_sys_array  *sys_array );
#ifdef SDL_IGNORE_UNUSED_FUNCTION
static uint8 validate_cache( uint8   icache, uint32 bpw, uint32 assoc );
uint8 validate_cpuconfig( void );
#endif
void sys_dcache_flush_all( void );
void sys_icache_invalidate_all( void );
void sys_flush_caches( void );
void sys_flush_cache_line( void *addr );


void sys_init_cache( void );	
void cache_params( void );
void test( void );
uint32 sys_determine_l2cache_linesize_flash( uint32 processor_ID );
uint32 sys_determine_l2cache_line_flash( uint32 processor_ID );
uint32 sys_determine_l2cache_assoc_flash( uint32 processor_ID );
uint32 sys_determine_l2cache_avail_flash( uint32 processor_ID );
uint32 sys_determine_icache_linesize_flash( uint32 processor_ID );
uint32 sys_determine_icache_lines_flash( uint32 processor_ID );
uint32 sys_determine_icache_assoc_flash( uint32 processor_ID );
uint32 sys_determine_dcache_linesize_flash( uint32 processor_ID );
uint32 sys_determine_dcache_lines_flash( uint32 processor_ID );
uint32 sys_determine_dcache_assoc_flash( uint32 processor_ID );
void sys_init_l2cache_flash( uint32 cache_size, uint32 line_size, uint32 processor_ID );
void sys_init_icache( uint32 cache_size, uint32 line_size );
void sys_init_dcache( uint32 cache_size, uint32 line_size, uint32 processor_ID );
void sys_cpu_icache_config ( uint32, uint32, uint32, uint32 );
void sys_cpu_dcache_config ( uint32, uint32, uint32, uint32 );
void sys_icache_invalidate_index ( uint32 index );
void sys_icache_get_parameters(void);
void sys_icache_invalidate_addr ( uint32 address, uint8 flash_after_init );
void sys_dcache_flush_index ( uint32 index );
void sys_dcache_get_parameters(void);
void sys_dcache_flush_addr ( uint32 address );
void sys_flush_pipeline ( void );
uint32 sys_cp0_read32( uint32 register_num, uint32 sel_field );


//#undef extern
//#undef I
#endif /* #ifndef __MT_CACHEDEFS_H__ */
