/* CMSynergyVer %full_filespec: mt_cache.c;4:csrc:1 % */

/************************************************************************
 *
 *  mt_cache.c
 *
 *  cache specific functions
 *
 *
 ************************************************************************/
#include "mt_archdefs.h"
#include "mt_mips.h"
#include "mt_sysdefs.h"
#include "mt_cachedefs.h"


uint8   sys_64bit;

uint8   sys_l2cache_enabled;

// Use default values so that it will not be zero-ed during init 
uint32 sys_icache_linesize = 0xFFFF;
uint32 sys_icache_lines = 0xFFFF;
uint32 sys_dcache_linesize = 0xFFFF;
uint32 sys_dcache_lines = 0xFFFF;


/************************************************************************
 *
 *                          sys_dcache_flush_all
 *  Description :
 *  -------------
 *
 *  Flush entire DCACHE.
 *
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void sys_dcache_flush_all( void )
{
    uint32 line;
    uint32 addr;

	sys_dcache_get_parameters();

    for( line = 0, addr = KSEG0(0);  line < sys_dcache_lines; 
	 	line++, addr += sys_dcache_linesize )
    {
        sys_dcache_flush_index( addr );
    }
}  


/************************************************************************
 *
 *                          sys_icache_invalidate_all
 *  Description :
 *  -------------
 *
 *  Invalidate entire ICACHE.
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void sys_icache_invalidate_all( void )
{
    uint32 line;
    uint32 addr;

	sys_icache_get_parameters();

    for( line = 0, addr = KSEG0(0); line < sys_icache_lines; 
         line++, addr += sys_icache_linesize )
    {
        sys_icache_invalidate_index( addr );
    }

	// We saw that for some reason, this function enables the interrupts, and we can get an interrupt while in assert.
    //sys_flush_pipeline();
}


/************************************************************************
 *
 *                          sys_flush_caches
 *  Description :
 *  -------------
 *
 *  First flush entire DCACHE, then invalidate entire ICACHE
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void sys_flush_caches( void )
{
    sys_dcache_flush_all();
    sys_icache_invalidate_all();
}


/************************************************************************
 *
 *                          sys_flush_cache_line
 *  Description :
 *  -------------
 *
 *  First flush DCACHE line, then invalidate ICACHE line
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
void sys_flush_cache_line( void *addr )
{
    addr = (void *)((uint32)addr & ~0x3);

    sys_dcache_flush_addr( (uint32)addr );
    sys_icache_invalidate_addr( (uint32)addr, TRUE );
}


