	
/************************************************************************
 *
 *  mt_sys.s
 *
 *  cpu functions
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/
//#include "System_Configuration.h"
//#include "System_PlatformConfiguration.h"

#include "mt_sysdefs.h"
#include "mt_mips.h"


	.set noreorder
			
/************************************************************************
 *
 *                          sys_enable_int
 *  Description :
 *  -------------
 *
 *  Enable interrupt: set IE in CP0-status.
 *  
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_enable_int)

    MFC0(   v0, C0_Status)
    or      v0, M_StatusIE
    MTC0(   v0, C0_Status)
    j       ra
    nop

END(sys_enable_int)


/************************************************************************
 *
 *                          sys_disable_int
 *  Description :
 *  -------------
 *
 *  UINT32 sys_disable_int( void )
 *
 *  Disable interrupt: clear IE in CP0-status.
 *  
 *  Return values :
 *  ---------------
 *
 *  Old IE bit
 *
 ************************************************************************/
LEAF(sys_disable_int)

    MFC0(   v0, C0_Status)
    li	    t0, ~M_StatusIE
    nop
    and     v1, v0, t0
    MTC0(   v1, C0_Status)
    li	    t0, M_StatusIE
    j       ra
    and	    v0, t0

END(sys_disable_int)

/************************************************************************
 *
 *                          sys_icache_get_parameters
 *  Description :
 *  -------------
 *
 *  Get I-Cache sizes
 *
 *	
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_icache_get_parameters)

    mfc0    $10, $16, 1            /* # .word 0x400a8001 */
    nop

    /* # Isolate I$ Line Size */
    sll     $11, $10, 10
    srl     $11, 29

    /* # Skip ahead if No I$ */
    beq     $11, $0, icache_missing
    nop
    li      $14, 2
    sllv    $11, $14, $11           /* # Now have true I$ line size in bytes */

    sll     $12, $10, 7
    srl     $12, 29
    li      $14, 64
    sllv    $12, $14, $12           /* # I$ Sets per way */

    sll     $13, $10, 13
    srl     $13, 29                 /* # I$ Assoc (-1) */
    add     $13, 1
    mul     $12, $12, $13           /* # Total number of sets */

	la	$15, sys_icache_lines	
	sw	$12, 0($15)			
	nop		
	la	$15, sys_icache_linesize
	sw	$11, 0($15)			
	nop

	jr ra
	nop	

icache_missing:

	lui $12, 0x8880
	lui $11, 0x7770
	la	$15, sys_icache_lines	
	sw	$12, 0($15)			
	nop		
	la	$15, sys_icache_linesize
	sw	$11, 0($15)			
	nop

	jr ra
	nop	

END(sys_icache_get_parameters)





/************************************************************************
 *
 *                          sys_icache_invalidate_index
 *  Description :
 *  -------------
 *
 *  Invalidate I cache line containing specified index
 *
 *  a0 holds the index
 *	
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_icache_invalidate_index)

SET_MIPS3()
	ICACHE_INDEX_INVALIDATE_OP(a0,a1)
SET_MIPS0()

	jr	ra
	nop
	
END(sys_icache_invalidate_index)


/************************************************************************
 *
 *                          sys_icache_invalidate_addr
 *
 *  Description :
 *  -------------
 *  Invalidate I cache line containing specified address.
 *
 *  a0 holds the address
 *  a1 != 0 => flush pipeline after the invalidation
 *
 *  Address MUST be KSEG0/KSEG1
 *	
 *  Return values :
 *  ---------------
 *  None
 *
 ************************************************************************/
LEAF(sys_icache_invalidate_addr)

	MFC0( t1, C0_Config )
	andi  t1, M_ConfigK0
	xori  t1, K_CacheAttrU << S_ConfigK0
	beq   t1, zero, 2f
	nop
	
	la	t1, sys_l2cache_enabled
	lb	t1, 0(t1)
	beq	t1, zero, 1f
	nop

SET_MIPS3()
	SCACHE_ADDR_HIT_WB_INVALIDATE_OP(a0)
	sync
1:		
	ICACHE_ADDR_INVALIDATE_OP(a0,t1)
SET_MIPS0()
2:
	bne	a1, zero, sys_flush_pipeline
	nop
	jr      ra
	nop	

END(sys_icache_invalidate_addr)


/************************************************************************
 *
 *                          sys_flush_pipeline
 *  Description :
 *  -------------
 *
 *  Flush pipeline
 *
 *  a0 holds the index
 *	
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_flush_pipeline)

	MFC0(	t0, C0_Status )
	
	/* Set STATUS in a well defined state so that we can perform
	 * a controlled eret (one without modifying shadow registers
	 * in case of a MIPS32/MIPS64 release 2 CPU).
	 *
	 * We need to make sure STATUS has the following settings :
	 *
	 * ERL = 0  (so EPC is used rather than ErrorEPC)
	 * BEV = 1  (so shadowsets are not shifted)
	 * IE  = 0  (so interrupts are disabled)
	 * KSU = 00 (so that we end up in kernel mode after eret)
	 */


	/* First set KSU=00, IE=0 */
	ori	t1, t0, (M_StatusKSU | M_StatusIE)
	xori	t1,     (M_StatusKSU | M_StatusIE)
	MTC0(	t1, C0_Status )
	/* Now set BEV */	
	li	t2, M_StatusBEV
	or	t1, t2
	MTC0(	t1, C0_Status )
	/* Finally, clear ERL */
	ori	t1, M_StatusERL
	xori	t1, M_StatusERL
	MTC0(	t1, C0_Status )

	la	t1, sys_64bit
	lb	t1, 0(t1)
	bne	t1, zero, 1f
	nop

	/* 32 bit CPU */
	MFC0(   t1, C0_EPC ) /* Store EPC */

	/* Now setup EPC and perform eret */	
	la	t2, after_eret32
	MTC0(	t2, C0_EPC )

SET_MIPS3()
	eret
SET_MIPS0()

after_eret32 :
	MTC0(   t1, C0_EPC ) /* Restore EPC */
	b	2f
	nop
	
1:	
	/* 64 bit CPU */
SET_MIPS3()
        
        //Danny TBD
	/*DMFC0(  t1, C0_EPC ) Store EPC */

	/* Now setup EPC and perform eret */	
	la	t2, after_eret64
        //Danny TBD
	/*DMTC0(	t2, C0_EPC )*/

	eret

after_eret64 :
        //Danny TBD
	/*DMTC0(  t1, C0_EPC )  Restore EPC */
SET_MIPS0()
	
2:	
	/* Restore STATUS and return */
	MTC0(	t0, C0_Status )
	jr	ra
	nop

END(sys_flush_pipeline)

/************************************************************************
 *
 *                          sys_dcache_get_parameters
 *  Description :
 *  -------------
 *
 *  Get D-Cache sizes
 *
 *  a0 holds the index
 *	
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_dcache_get_parameters)

    mfc0    $10, $16, 1            /* # .word 0x400a8001 */
    nop

    sll     $11, $10, 19
    srl     $11, 29

    /* # Skip ahead if No D$ */
    beq     $11, $0, dcache_missing
    nop
    li      $14, 2
    sllv    $11, $14, $11           /* # Now have true D$ line size in bytes */

    sll     $12, $10, 16
    srl     $12, 29
    li      $14, 64
    sllv    $12, $14, $12           /* # D$ Sets per way */

    sll     $13, $10, 22
    srl     $13, 29                 /* # D$ Assoc (-1) */
    add     $13, 1

    mul     $12, $12, $13           /* # Get total number of sets */

	la	$15, sys_dcache_lines	
	sw	$12, 0($15)			
	nop		
	la	$15, sys_dcache_linesize
	sw	$11, 0($15)			
	nop

	jr ra
	nop	

dcache_missing:

	lui $12, 0x8880
	lui $11, 0x7770
	la	$15, sys_dcache_lines	
	sw	$12, 0($15)			
	nop		
	la	$15, sys_dcache_linesize
	sw	$11, 0($15)			
	nop

	jr ra
	nop	

END(sys_dcache_get_parameters)




	
/************************************************************************
 *
 *                          sys_dcache_flush_index
 *  Description :
 *  -------------
 *
 *  Flush D cache line containing specified index
 *
 *  a0 holds the index
 *	
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_dcache_flush_index)

SET_MIPS3()
	cache	DCACHE_INDEX_WRITEBACK_INVALIDATE, 0(a0)
SET_MIPS0()
	sync
	jr ra
	nop	

END(sys_dcache_flush_index)


/************************************************************************
 *
 *                          sys_dcache_flush_addr
 *  Description :
 *  -------------
 *  Flush D cache line containing specified address.
 *
 *  We bypass the cache operations if CPU is running uncached.
 *  (We assume Config.k0 == K_CacheAttrU is the
 *  only uncached mode used).
 *
 *  a0 holds the address 
 *
 *  Address MUST be KSEG0/KSEG1
 *	
 *  Return values :
 *  ---------------
 *  None
 *
 ************************************************************************/
LEAF(sys_dcache_flush_addr)

	MFC0( t1, C0_Config )
	andi  t1, M_ConfigK0
	xori  t1, K_CacheAttrU << S_ConfigK0
	beq   t1, zero, 2f
	nop
	
	la	t1, sys_l2cache_enabled
	lb	t1, 0(t1)
	beq	t1, zero, 1f
	nop

	/*  This secondary cache operation will also flush $D,
	 *  so we don't need to flush $D.
	 */
SET_MIPS3()
	cache	DCACHE_ADDR_HIT_WRITEBACK_INVALIDATE, 0(a0)
	sync
	SCACHE_ADDR_HIT_WB_INVALIDATE_OP(a0)
SET_MIPS0()
	b	2f
	nop
1:		
SET_MIPS3()
	cache	DCACHE_ADDR_HIT_WRITEBACK_INVALIDATE, 0(a0)
SET_MIPS0()
2:
	sync
	jr	ra
	lb	zero, 0(a0)

END(sys_dcache_flush_addr)


#ifdef SW_CACHE_CONFIG

/************************************************************************
 *
 *                          sys_enable_int_mask
 *  Description :
 *  -------------
 *
 *  Enable specific interrupt: set IM[x] bit in CP0-status.
 *  
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_enable_int_mask)

    MFC0(   v0, C0_Status)
    li	    t0, 1
    addiu   a0, S_StatusIM
    sllv    t0, t0, a0
    or	    v0, t0
    MTC0(   v0, C0_Status)
    j       ra
    nop

END(sys_enable_int_mask)

/************************************************************************
 *
 *                          sys_disable_int_mask
 *  Description :
 *  -------------
 *
 *  Disable specific interrupt: set IM[x] bit in CP0-status.
 *  
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF(sys_disable_int_mask)

    MFC0(   v0, C0_Status)
    li	    t0, 1
    addiu   a0, S_StatusIM
    sllv    t0, t0, a0
    li	    t1, 0xffffffff
    xor	    t0, t1
    and	    v0, t0
    MTC0(   v0, C0_Status)
    j       ra
    nop

END(sys_disable_int_mask)

	
/************************************************************************	
 *
 *                          sys_cpu_k0_config
 *  Description :
 *  -------------
 *
 *  Configure K0 field of CP0 CONFIG register
 *
 *  a0 holds the requested K0 setting
 *	
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF( sys_cpu_k0_config )

	/* Reserve space on stack */
	addiu	sp, -8*4

	/* Store registers */
	sw	ra, 0(sp)
	sw	s0, 4(sp)
	sw	s1, 8(sp)	

	/* Copy registers to preserved registers */
	move	s0, a0
	
	/* Disable interrupts */
	MFC0(   s1, C0_Status )	
	li	t0, ~M_StatusIE
	and	t0, s1
	MTC0(   t0, C0_Status )

	/* Flush D-Cache */
	addiu	sp, -4*4
	la      t0, sys_dcache_flush_all
	jal	t0
	nop
	addiu	sp, 4*4

        /* Invalidate I-Cache */
	addiu	sp, -4*4
	la      t0, sys_icache_invalidate_all
	jal	t0
	nop
	addiu	sp, 4*4

	/* Shift to uncached */
	la	t0, sys_cpu_k0_config_uncached
	li	t1, KSEG1BASE
	or	t0, t1
	jr	t0
	nop

sys_cpu_k0_config_uncached :

	/* Set K0 field */
	sll	s0, S_ConfigK0
	MFC0(   t1, C0_Config )
	li	t0, ~M_ConfigK0
	and	t1, t0
	or	t1, s0
	MTC0(   t1, C0_Config )

	/* Restore CP0 STATUS */
	MTC0(   s1, C0_Status )

	/* Restore registers */
	lw	ra, 0(sp)
	lw	s0, 4(sp)
	lw	s1, 8(sp)
	
	jr	ra
	addiu	sp, 8*4
	
END( sys_cpu_k0_config )
	

/************************************************************************
 *
 *                          sys_sync
 *  Description :
 *  -------------
 *
 *  Issue "sync" instruction
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF( sys_sync )

        sync
	jr	ra
	nop

END( sys_sync )



/******* Functions for access to CP0 registers ******/

	
/************************************************************************
 *
 *                          sys_cp0_read32
 *  Description :
 *  -------------
 *
 *  Read 32 bit CP0 register
 *
 *  a0 holds register number
 *  a1 holds sel field
 *
 *  Return values :
 *  ---------------
 *
 *  v0 = Value read
 *
 ************************************************************************/
LEAF( sys_cp0_read32 )

	/* Look if a0,a1 happen to be C0_Status, sel0 */
	li	t0, R_C0_Status
	bne	a0, t0, 1f
	nop
	bne	a1, zero, 1f
	nop
	MFC0(   v0, C0_Status)
	jr	ra
	nop
	
1:
	/* Reserve space on stack and store ra, C0_Status */
	addiu	sp, -2*4
	sw	ra, 0(sp)

	/* Disable interrupts */
	MFC0(   t2, C0_Status)
	sw	t2, 4(sp)
	or	t2, M_StatusIE
	xor	t2, M_StatusIE
	MTC0(   t2, C0_Status)

        /*  Calc specific MFC0 opcode :
	 *
	 *  MFC0 rt, rd 
	 *
	 *  010000 00000 rt rd 00000000 sel
	 *
	 *  rt[4:0]  = v0 ($2) 
	 *  rd[4:0]  = Value of a0
	 *  sel[2:0] = Value of a1
         */
	
	li      t0, 0x40000000 | (0x2 << 16)
	or  	t0, a1   /* sel */
	sll 	a0, 11
	or  	t0, a0

	/* Store instruction */
	la  	a0, mfc0_location
	sw 	t0, 0(a0)

	/* Whenever an instruction has been stored to KSEG0, we must
	 * make sure the instruction has been flushed to physical memory
	 * and invalidate the corresponding I-Cache line.
	 */
	jal     sys_dcache_flush_addr
	nop
	jal	sys_icache_invalidate_addr
	li	a1, 1				/* Flush pipeline */	

mfc0_location :
	nop	/* Placeholder for MFC0 operation */

	/* MFC0 has now been performed, so restore cp0_status and return */
	lw	t2, 4(sp)
	MTC0(   t2, C0_Status)

	lw      ra, 0(sp)
	jr	ra
	addiu	sp, 2*4

END( sys_cp0_read32 )	


/************************************************************************
 *
 *                          sys_cp0_read64
 *  Description :
 *  -------------
 *
 *  Read 64 bit CP0 register
 *
 *  a0 holds register number
 *  a1 holds sel field
 *
 *  Return values (Note that C-code is compiled for 32 bit !) :
 *  -----------------------------------------------------------
 *
 *  Little endian :
 *  v0 = 32 lsb of value read
 *  v1 = 32 msb of value read 
 *
 *  Big endian :
 *  v0 = 32 msb of value read
 *  v1 = 32 lsb of value read
 *
 ************************************************************************/
LEAF( sys_cp0_read64 )

	/* Reserve space on stack and store ra, C0_Status */
	addiu	sp, -2*4
	sw	ra, 0(sp)

	/* Disable interrupts */
	MFC0(   t2, C0_Status)
	sw	t2, 4(sp)
	or	t2, M_StatusIE
	xor	t2, M_StatusIE
	MTC0(   t2, C0_Status)

        /*  Calc specific DMFC0 opcode :
	 *
	 *  DMFC0 rt, rd 
	 *
	 *  010000 00001 rt rd 00000000 sel
	 *
	 *  rt[4:0]  = v0 ($2) 
	 *  rd[4:0]  = Value of a0
	 *  sel[2:0] = Value of a1
         */
	
	li      t0, 0x40200000 | (0x2 << 16)
	or  	t0, a1   /* sel */
	sll 	a0, 11
	or  	t0, a0

	/* Store instruction */
	la  	a0, dmfc0_location
	sw 	t0, 0(a0)

	/* Whenever an instruction has been stored to KSEG0, we must
	 * make sure the instruction has been flushed to physical memory
	 * and invalidate the corresponding I-Cache line.
	 */
	jal     sys_dcache_flush_addr
	nop
	jal	sys_icache_invalidate_addr
	li	a1, 1				/* Flush pipeline */		

dmfc0_location :
	nop	/* Placeholder for DMFC0 operation */

SET_MIPS3()
#ifdef EB
        move	v1, v0
	dsrl	v0, v1, 32
#else
	dsrl	v1, v0, 32
#endif	
SET_MIPS0()
	
	/* DMFC0 has now been performed, so restore cp0_status and return */
	lw	t2, 4(sp)
	MTC0(   t2, C0_Status)

	lw      ra, 0(sp)
	jr	ra
	addiu	sp, 2*4

END( sys_cp0_read64 )	
	

/************************************************************************
 *
 *                          sys_cp0_write32
 *  Description :
 *  -------------
 *
 *  Write 32 bit CP0 register
 *
 *  a0 holds register number
 *  a1 holds sel field
 *  a2 holds value to be written
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF( sys_cp0_write32 )

	/* Look if a0,a1 happen to be C0_Status, sel0 */
	li	t0, R_C0_Status
	bne	a0, t0, 1f
	nop
	bne	a1, zero, 1f
	nop
	MTC0(   a2, C0_Status)
	jr	ra
	nop
	
1:
	/* Reserve space on stack and store ra, a2, C0_Status */
	addiu	sp, -3*4
	sw	ra, 0(sp)
	sw	a2, 4(sp)	

	/* Disable interrupts */
	MFC0(   t2, C0_Status)
	sw	t2, 8(sp)
	or	t2, M_StatusIE
	xor	t2, M_StatusIE
	MTC0(   t2, C0_Status)

        /*  Calc specific MTC0 opcode :
	 *
	 *  MTC0 rt, rd 
	 *
	 *  010000 00100 rt rd 00000000 sel
	 *
	 *  rt[4:0]  = a2 ($6)
	 *  rd[4:0]  = Value of a0
	 *  sel[2:0] = Value of a1
         */
	
	li      t0, 0x40800000 | (0x6 << 16)
	or  	t0, a1   /* sel */
	sll 	a0, 11
	or  	t0, a0

	/* Store instruction */
	la  	a0, mtc0_location
	sw 	t0, 0(a0)

	/* Whenever an instruction has been stored to KSEG0, we must
	 * make sure the instruction has been flushed to physical memory
	 * and invalidate the corresponding I-Cache line.
	 */
	jal     sys_dcache_flush_addr
	nop
	jal	sys_icache_invalidate_addr
	li	a1, 1				/* Flush pipeline */

	/* Restore a2 (value to be written) */
	lw	a2, 4(sp)		

mtc0_location :
	nop	/* Placeholder for MTC0 operation */

	/* MTC0 has now been performed, so restore cp0_status and return */
	lw	t2, 8(sp)
	MTC0(   t2, C0_Status)

	lw      ra, 0(sp)
	jr	ra
	addiu	sp, 3*4

END( sys_cp0_write32 )	


/************************************************************************
 *
 *                          sys_cp0_write64
 *  Description :
 *  -------------
 *
 *  Write 64 bit CP0 register
 *
 *  a0 holds register number
 *  a1 holds sel field
 *
 *  Little endian (Note that C-code is compiled for 32 bit !) :
 *
 *  a2 holds 32 lsb of value to be written
 *  a3 holds 32 msb of value to be written
 *
 *  Big endian :
 *
 *  a2 holds 32 msb of value to be written
 *  a3 holds 32 lsb of value to be written
 *
 *  Return values :
 *  ---------------
 *
 *  None
 *
 ************************************************************************/
LEAF( sys_cp0_write64 )

SET_MIPS3()
		
	/* Reserve space on stack and store ra, a2, a3, C0_Status */
	addiu	sp, -4*4
	sw	ra, 0(sp)
	sw	a2, 4(sp)
	sw	a3, 8(sp)

	/* Disable interrupts */
	MFC0(   t2, C0_Status)
	sw	t2, 12(sp)
	or	t2, M_StatusIE
	xor	t2, M_StatusIE
	MTC0(   t2, C0_Status)

        /*  Calc specific DMTC0 opcode :
	 *
	 *  DMTC0 rt, rd 
	 *
	 *  010000 00101 rt rd 00000000 sel
	 *
	 *  rt[4:0]  = a2 ($6)
	 *  rd[4:0]  = Value of a0
	 *  sel[2:0] = Value of a1
         */
	
	li      t0, 0x40a00000 | (0x6 << 16)
	or  	t0, a1   /* sel */
	sll 	a0, 11
	or  	t0, a0

	/* Store instruction */
	la  	a0, dmtc0_location
	sw 	t0, 0(a0)

	/* Whenever an instruction has been stored to KSEG0, we must
	 * make sure the instruction has been flushed to physical memory
	 * and invalidate the corresponding I-Cache line.
	 */
	jal     sys_dcache_flush_addr
	nop
	jal	sys_icache_invalidate_addr
	li	a1, 1				/* Flush pipeline */	

	/* Restore a2, a3 (value to be written) */
	lw	a2, 4(sp)
	lw	a3, 8(sp)

#ifdef EB
	dsll	a3, 32
	dsrl	a3, 32 
	dsll	a2, 32
	or	a2, a3
#else
	dsll	a2, 32
	dsrl	a2, 32
	dsll	a3, 32
	or	a2, a3
#endif

dmtc0_location :
	nop	/* Placeholder for DMTC0 operation */

	/* DMTC0 has now been performed, so restore cp0_status and return */
	lw	t2, 12(sp)
	MTC0(   t2, C0_Status)

	lw      ra, 0(sp)
	jr	ra
	addiu	sp, 4*4

SET_MIPS0()
		
END( sys_cp0_write64 )

#endif /* SW_CACHE_CONFIG */
