/***************************************************************
 File:		Bsrc_Api.h
 Module:	Bsrc
 Purpose: 	holds all the definitions of the Bsrc API functions
 Description:  This file is the API to the Bsrc module which is responsible
 			for handling buffer status reports from STA in HE MU
***************************************************************/
#ifndef BSRC_API_H_
#define BSRC_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "Bsrc.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#if defined (BSRC_ARTIFICIAL_UPDATE_FOR_UL)
typedef struct BsrcTfInterval
{
	bool isFixedInterval;
	uint8 tfInterval;	
	uint16 reserved;
}BsrcTfInterval_t;

#define BSRC_DEFAULT_TF_INTERVAL	(1) // default TF interval in 10ms (1 means 10 ms)
#endif

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
#ifdef ENET_INC_ARCH_WAVE600D2
#define BSRC_NDPF_FIFO_SIZE 4
#define BSRC_NDPF_FIFO_SIZE_MASK  (BSRC_NDPF_FIFO_SIZE - 1)

typedef struct _BsrcFifoParams_
{
	uint16 currentIndexInFifo;
	uint16 numOfValidEntries;
} BsrcFifoParams_t;

typedef struct BsrcDb_
{
	uint16	fifoReadIndex;					// Next entry to provide to FW		
	uint16 fifoFullCounter;
	
} BsrcDb_t;
#endif
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void Bsrc_Initialize(void);
void Bsrc_Command(uint16 stationId, uint8 tIdMask, uint32 counter, BsrcCommands_e command);
void Bsrc_SetCounterInitMode(uint16 stationId, BsrcCounterInitType_e eInitType);
uint16 Bsrc_GetCounter(uint16 stationId, uint8 tId);
#ifdef BSRC_ARTIFICIAL_UPDATE_FOR_UL
void Bsrc_SetTfFixedInterval(uint8 tfInterval, bool isFixedInterval);
uint8 Bsrc_GetTfInterval(void);
uint8 Bsrc_GetTfFixedInterval(void);
#endif
#ifdef ENET_INC_ARCH_WAVE600D2
void Bsrc_UpdateStationNfrpSupport(StaId stationId, bool isNfrpSupport);
void Bsrc_ErrorHandler(void);
void Bsrc_GetFifoParameters(BsrcFifoParams_t *fifoParams);
void Bsrc_SetFifoParameters(BsrcFifoParams_t *fifoParams);
void Bsrc_reportFifoNotEmptyEventHandler(void);
#endif
#endif /* BSRC_API_H_ */


