/***************************************************************
 File:		Bsrc.h
 Module:	BSRC
 Purpose: 	holds the definions for the BSRC HW module 
 Description:  This file is the API to the Bsrc module which is responsible
 			for handling buffer status reports from STA in HE MU
***************************************************************/
#ifndef _BSRC_H_
#define _BSRC_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#ifdef BSRC_QSIZE_GET_WRONG_VAL_WORKAROUND
#define BSRC_MAX_MPDU_HEADER_LENGTH (28) // (https://jira-chd.intel.com/browse/WLANVLSIIP-3033)
#else
#define BSRC_MAX_MPDU_HEADER_LENGTH (46) // 28+18=46 bytes (the maximal MPDU header value: UC management with WAPI encryption)
#endif

#define BSRC_AGER_DEFAULT_STROBE_COUNT (9999) //Ager strobe counter value. Resolution is 1usec. Default is 9999, meaning once per 10msec Ager counters are decremented by 1.
#define BSRC_DEFAULT_AGER_PERIOD (0)

#define BSRC_FW_CLR_AGER_PERIOD (0) //Value to set ager when counter reach 0
#define BSRC_FW_SET_AGER_PERIOD (0) //Value to set ager on each counter change (other than reaching 0)

#define BSRC_NUM_OF_DATA_TIDS (8)
#define BSRC_SIZE_OF_COUNTER_IN_BYTES (2)
#define BSRC_SIZE_OF_MASK_IN_BYTES (1)
#define BSRC_SIZE_OF_AGER_IN_BYTES (2)
#define BSRC_NUM_OF_BITS_IN_UINT16 (16)

#define BSRC_COUNTER_RESET_VALUE (0)
#define BSRC_MASK_RESET_VALUE (0)
#define BSRC_AGER_RESET_VALUE (0)

#define BSRC_MIN_COUNTER_VAL 		(64)	  // minimum counter size because it's 64 bytes quantized
//this size is marked as unlimited in HW and is not decremented
// the source of this number is from the spec., the queue size received in QoS control is 8 bits size: Scaling Factor - bits 6-7, Unscaled Value - bits 0-5
//255 is considred as "undefined" so the largest number possible is 254 and the calculation is: 148480+32768*UV where UV=62
#define BSRC_COUNTER_VAL_UNLIMITED	(2180096)

/*An interrupt or higher priority task may preempt the running task while it is waiting for the BSRC command to be completed
Since we do not want to disable interrupts for this we use a timeout (in microsec.) value that should also take this into consideration*/
#define BSRC_MAX_WAITING_FOR_DONE_TIMEOUT (10000)

#define BSRC_DIVIDE_BY_64(x) 					 ((x)>>6)
#define BSRC_GET_SW_INIT_REGISTER_OFFSET(x) 	 ((x)>>5)
#define BSRC_MODULO_32(x) 	 					 ((x)&0x1F)
#define BSRC_MODULO_2(x) 	 					 ((x)&0x1)
#define BSRC_GET_TID_COUNTER_REGISTER_OFFSET(x)  ((x)>>1)

#ifdef ENET_INC_ARCH_WAVE600D2
#define BSRC_NDPFB_VAL_BELOW_THRESH	(4)   //64 bit. 2^8:64
#define BSRC_NDPFB_VAL_ABOVE_THRESH	(512) //64 bit. 2^15:64
#endif

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef enum
{
	BSRC_COMMAND_MASK = 0,
	BSRC_COMMAND_UNMASK,
	BSRC_COMMAND_CLEAR,
	BSRC_COMMAND_SET,
	BSRC_COMMAND_INIT,
	BSRC_COMMAND_LAST
} BsrcCommands_e;

typedef enum
{
	BSRC_COUNTER_INIT_HW = 0,
	BSRC_COUNTER_INIT_SW = 1,
	BSRC_COUNTER_INIT_INVALID
} BsrcCounterInitType_e;


#endif /* _BSRC_H_ */

