/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET Upper MAC SW
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/bss_manage_task.c $
 **
 ** VERSION:        $Revision: #10 $
 **
 ** DATED:          $Date: 2004/03/26 $
 **
 ** AUTHOR:         S Sondergaard/Peter Hall
 **
 ** DESCRIPTION:    BSS manage task
 **
 ** LAST MODIFIED BY:   $Author: prh $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom Limited
 *
 ****************************************************************************/

 
/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "RegAccess_Api.h"
#include "bss_manage_task.h"
#include "TsManager_API.h"
#include "ieee80211.h"
#include "frame.h"
#include "msgid.h"
#include "umi.h"
#include "mib_id.h"
#include "mib_ms.h"
#include "mhi_umi_propr.h"
#include "shram.h"
#include "shram_man_msgs.h"
#include "shram_rx_buffer.h"
#include "init_ifmsg.h"
#include "queue_utility.h"
#include "database.h"
#include "PhyDriver_API.h"  /* PHY specific routines */
#include "enet_pas.h"
#include "mhi_mac_event.h"
#include "mt_sysrst.h"
#include "shram_lmi_vectors.h"
#include "mt_phy_statistics.h"
#include "ErrorHandler_Api.h"
#include "CoC_Api.h"
#include "BSSmanager_API.h"
#include "CalibrationDefs.h"
#include "lmi.h"
#include "CalibrationManager.h"
#include "um_interface.h"
#include "Hdk_Api.h"
#include "ProcessManager_Api.h"
#include "ErrorHandler_Api.h"
#include "VapDatabase_Api.h"
#include "Pac_Api.h"
#include "PacManager_api.h"
#include "PSD.h"
#include "Dut_Api.h"
#include "TsManager_API.h"
#include "lm.h"
#include "HdkTask.h"
#include "TpcClbrHndlr.h"


/***************************************************************************/
/***                  Local Constants                                    ***/
/***************************************************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_BSS
#define LOG_LOCAL_FID 0





/***************************************************************************/
/***                  Function prototypes                                ***/
/***************************************************************************/
static void vBSS_PacStartCfm(K_MSG *psMsg);



/***************************************************************************/
/***                  Extern data                                        ***/
/***************************************************************************/

/***************************************************************************/
/***                  Static data                                        ***/
/***************************************************************************/


/***************************************************************************/
/***       UMI UM IF indications                                         ***/
/***************************************************************************/

/* Table containing data about each management and control packet type */
static const FunctionEntry_t afpTaskTable[TASK_BSS_MANAGE_END-TASK_BSS_MANAGE_START]=
{
	{vBSS_ReturnUmiResource,					DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_BSS_RETURN_RESOURCE)},
	{vBSS_ReturnUmiResource,					DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_UM_NETWORK_EVENT_RES)},
	{vBSS_PacStartCfm,							DOUBLE_CHECK_MSG_TYPE(BSS_MANAGE_PAC_START_CFM)},
};

/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/

/****************************************************************************
 **
 ** NAME:           vBSS_Task
 **
 ** PARAMETERS:
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    main entry point for task
 **
 ****************************************************************************/

void vBSS_Task(K_MSG *psMsg)
{
    /* Use common task switching and Table */
	vTaskDispatcher(psMsg, afpTaskTable, TASK_BSS_MANAGE_START, TASK_BSS_MANAGE_END);
}

/***************************************************************************/
/***                  State handling routines                            ***/
/***************************************************************************/


/****************************************************************************
 **
 ** NAME:           vBSS_Initialise
 **
 ** PARAMETERS:     Message from UMI task
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    Initialize the BSS by configuring the LM and going to
 **                 to the idle state.
 **
 ****************************************************************************/
void vBSS_Initialise(uint8 vapId)
{
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(PacManagerStart_t));
	PacManagerStart_t *sStart_p = (PacManagerStart_t *)pK_MSG_DATA(kMsg_p);

	sStart_p->loggerStationIndex = LoggerApi_GetLoggerStationIndex(); 


	ILOG2_V("vBSS_Initialize, send PAC_MANAGER_START_REQ");
	SLOG0(0, 0, PacManagerStart_t, sStart_p);
	
	/* START BSS */
	OSAL_SEND_MESSAGE(PAC_MANAGER_START_REQ, TASK_PAC_MANAGER, kMsg_p, vapId);
		
	vMIB_Adopt(FALSE);
}

/****************************************************************************
 **
 ** NAME:           vBSS_PAcStartCfm
 **
 ** PARAMETERS:
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    The PAC has been started.  
 **
 ****************************************************************************/
static void vBSS_PacStartCfm(K_MSG *psMsg)
{
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = BssManagerVapManager_GetDummyMessage();

 	/* Signal to Process Manager Excecution Has Fisnished  Process*/		
	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, psMsg->header.vapId);
}



/****************************************************************************
 **
 ** NAME:           vBSS_ReturnUmiResource
 **
 ** PARAMETERS:
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    The CFM message is returned to the LMI free queue
 **
 ****************************************************************************/
void vBSS_ReturnUmiResource(K_MSG *psMsg)
{
    /* Return NV Start Message to LM store */
    OSAL_QUEUE_MSG(&sUmiIndFreeQueue,psMsg);
}





