/***********************************************************************************
File:			ChannelSwitchManager_Api.h
Module:		ChannelSwitchManager
Purpose: 		
Description:   
************************************************************************************/
#ifndef CHANNEL_SWITCH_MANAGER_API_H_
#define CHANNEL_SWITCH_MANAGER_API_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/

/* center frequency = LOW Channel - 2 + BW/2/5 
   where 2: is the number of indexes to reduce from the low channel in order to get to the first channel
   where BW/2/5: is the shift from the first channel to the center frequency
   hence, for 20MHz: (-2) + (20/2/5) = 0 (and 2 for 40MHz and 6 for 80MHz
*/
#define BW_20_OFFSET_TO_FREQ_INDEX (0)
#define BW_40_OFFSET_TO_FREQ_INDEX (2)
#define BW_80_OFFSET_TO_FREQ_INDEX (6)
#define BW_80_HIGH_OFFSET_TO_FREQ_INDEX (22) //Offset to higher 80BW inside 160BW
#define BW_160_OFFSET_TO_FREQ_INDEX (14)
#define BW_160_PRIMARY_CHANNEL_HIGH_START_INDEX (4) //use to calculate if primary ch. is in the lower 80MHz or the higher

/*---------------------------------------------------------------------------------
/						Macros					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data type definitions					
/----------------------------------------------------------------------------------*/
typedef struct _ChannelSwitchManager_BeaconLockNotification_t
{
	uint32 vapIdx;
} ChannelSwitchManager_BeaconLockNotification_t;

typedef struct _HdkSetChannelCfmParams_t
{
	uint8 antennaMask;
} HdkSetChannelCfmParams_t;

typedef struct _ChannelSwitchManagerChannelLoadDb_t
{
	uint32	totalChannelLoad;				// Total channel load between PHY status REQ
	uint32	totalChannelUtilization;		// Total channel utilization between PHY status REQ
	uint32	totalChannelLoadBssLoad;		// Total channel load between channel load timeouts - used to update BSS load IE
 	uint32	channelLoadMesStartTime;		// Start time of channel load measurements - used for channel load and channel utilization
 	uint32	channelLoadMesStartTimeBssLoad;	// Start time of BSS load measurements - used for BSS load IE
	bool   	timerActive;
}ChannelSwitchManagerChannelLoadDb_t;


/*---------------------------------------------------------------------------------
/						Public functions declarations			
/----------------------------------------------------------------------------------*/
void ChannelSwitchManager_Initialize(void);
void ChannelSwitchManager_PostInit(void);
uint8 ChannelSwitchManager_GetSecondaryChannelOffset(uint8 low_chan_num, uint8 low_chan_num2, uint8 chan_width, uint8 primary_chan_idx);
uint8 ChannelSwitchManager_GetChannelWidth(uint8 chan_width);
#ifdef ENET_INC_ARCH_WAVE600
uint8 ChannelSwitchManager_GetCenterFreq0Idx(uint8 low_chan_num, uint8 chan_width, uint8 primary_chan_idx);
uint8 ChannelSwitchManager_GetCenterFreq1Idx(uint8 low_chan_num, uint8 chan_width);
#else
uint8 ChannelSwitchManager_GetCenterFreq0Idx(uint8 low_chan_num, uint8 chan_width);
#endif //ENET_INC_ARCH_WAVE600
void channelSwitchManager_CalcChannelLoad(void);
#endif // CHANNEL_SWITCH_MANAGER_API_H_

