/***********************************************************************************
File:		ChannelSwitchManager.h
Module:		ChannelSwitchManager
Purpose: 		
Description:   
************************************************************************************/
#ifndef CHANNEL_SWITCH_MANAGER_H_
#define CHANNEL_SWITCH_MANAGER_H_

/*---------------------------------------------------------------------------------
/						includes					
/----------------------------------------------------------------------------------*/

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"



/*---------------------------------------------------------------------------------
/						defines				
/----------------------------------------------------------------------------------*/
typedef enum _ChannelSwitchManagerStates_e
{
	CHANNEL_SWITCH_MANAGER_STATE_INIT,
	CHANNEL_SWITCH_MANAGER_STATE_IDLE,
	CHANNEL_SWITCH_MANAGER_STATE_WAIT_FOR_PROCESS_START,
	CHANNEL_SWITCH_MANAGER_STATE_WAIT_FOR_PROCESS_FINISH,
	CHANNEL_SWITCH_MANAGER_STATE_WAIT_FOR_SET_CHANNEL_CFM_FROM_HDK,
	CHANNEL_SWITCH_MANAGER_STATE_WAIT_FOR_NOTIFY_CFM,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_SCAN_WAIT_FOR_TX_QUEUE_LOCK,
	CHANNEL_SWITCH_MANAGER_STATE_SCAN_WAIT_FOR_TX_RESUME,
	CHANNEL_SWITCH_MANAGER_STATE_SCAN_WAIT_FOR_RX_RESUME,
	CHANNEL_SWITCH_MANAGER_STATE_SCAN,
	CHANNEL_SWITCH_MANAGER_STATE_POST_SCAN_WAIT_FOR_TX_PAUSE,
	CHANNEL_SWITCH_MANAGER_STATE_POST_SCAN_WAIT_FOR_RX_PAUSE,
	CHANNEL_SWITCH_MANAGER_STATE_POST_SCAN_WAIT_FOR_TX_QUEUE_LOCK,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT_FOR_BEACONS_UPDATE,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT_FOR_VAP_PAUSE,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT_FOR_VAP_PAUSE_STOP,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT_FOR_TX_PAUSE,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT_FOR_RX_PAUSE,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT_FOR_STOP_CSA_BEACONS,
	CHANNEL_SWITCH_MANAGER_STATE_PRE_CHANNEL_SWITCH_WAIT_FOR_CSA_MANAGER,
	CHANNEL_SWITCH_MANAGER_STATE_POST_CHANNEL_SWITCH_WAIT_FOR_RX_RESUME,
	CHANNEL_SWITCH_MANAGER_STATE_POST_CHANNEL_SWITCH_TX_PAUSED,
	CHANNEL_SWITCH_MANAGER_STATE_WAIT_FOR_RSSI_SET_CFM,
	CHANNEL_SWITCH_MANAGER_STATE_WAIT_FOR_RSSI_RX_CFM,
	CHANNEL_SWITCH_MANAGER_STATE_RSSI
} ChannelSwitchManagerStates_e;


/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/
typedef struct _ChannelSwitchManagerParams_t
{
	K_MSG *pSetChannelRequest; //pointer to original set channel request from driver
	UM_SET_CHAN_PARAMS *pUmSetChannelParams; //pointer to the payload carried in the original set channel request from driver
	uint32 activeVapsBitmap; //bitmap of current active vaps
	uint32 staModeVapsBitmap; //bitmap of current STA mode VAPs
	uint32 activeSessionBitmap; //a template bitmap of vaps, used to check which vaps are considered active in a specific session (e.g. which vaps GPLP queues are yet to be locked before scan)
	uint32 vapPauseBitmap;
	uint8  actualLowChannel;
	uint8  actualBW;
	uint8  actualPrimaryChannel;
	ChannelSwitchManagerStates_e state; //state machine's state
	bool csaManagerStartConfirm;
	bool csaManagerStopConfirm;
	uint8 notifyReqCnt;
	uint8 notifyCfmCnt;
} ChannelSwitchManagerParams_t;
#endif // CHANNEL_SWITCH_MANAGER_H_

