/***********************************************************************************
 File:			CoC_Api.h
 Module:			CoC
 Purpose: 		Manages changing number of active antennas
 Description:		This header is the API to the CoC module
				which is responsible changing configuration of active antennas
************************************************************************************/

#ifndef _COC_API_H_
#define _COC_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "database.h"
#include "ConfigurationManager_api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

typedef enum
{
	COC_DECREASE_NUM_OF_ANTS = 0x0,
	COC_INCREASE_NUM_OF_ANTS = 0x1,
} cocUpDown_e;

typedef enum
{
	COC_STATUS_HDK_IS_READY,
	COC_STATUS_HDK_IS_NOT_READY,
} cocHdkStatus_e;

typedef enum
{
	COC_STATE_IDLE,
	COC_STATE_WAIT_FOR_PROCESS_START,
	COC_STATE_WAIT_FOR_HDK_SET_AND_CFM,
	COC_STATE_WAIT_FOR_LINK_ADAPTIVE_SET_AND_CFM,
	COC_STATE_WAIT_FOR_GROUP_MANAGER_SET_AND_CFM,
	COC_STATE_WAIT_FOR_PROCESS_END,
	COC_STATE_HDK_IS_NOT_READY_WAIT_FOR_PROCESS_END,
} cocState_e;
typedef struct cocUpdateAntMaskMsg
{
	BandId_e band;
	uint8 currentTxAntsMask;
	uint8 currentRxAntsMask;
	uint8 currentTxAntsNum;
}cocUpdateAntMaskMsg_t;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct cocReq_t_
{
	uint8 			requestedTxAntsMask;
	uint8 			requestedRxAntsMask;
	uint8			requestedNumOfAnts;
	cocUpDown_e 	upOrDown;			 // 0x0 = down, 0x1 = up.
	cocHdkStatus_e	hdkStatus;
} cocReq_t;

typedef struct cocChannelWidth_t_
{
	uint8 			channelWidth;
} cocChannelWidth_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------


void  CoC_task(K_MSG* psMsg);
void  CoC_InitNumAnts(void);
uint8 CoC_getNumActiveTxAnts(void);
uint8 CoC_getNumActiveRxAnts(void);
uint8 CoC_getMaskActiveTxAnts(void);
uint8 CoC_getMaskActiveRxAnts(void);
cocState_e CoC_getState(void);
void  CoC_Init(void);
void CoC_updateNewAntennaMask(uint8 antennaMask);
void CoC_sendSmps(void);



#endif /* _COC_API_H_ */

