/***********************************************************************************
 File:		CoC.h
 Module:		Code Of Conduct
 Purpose: 	Manages changing number of active antennas
 Description:	This is the header file of the CoC module
			which is responsible changing configuration of active antennas
************************************************************************************/
#ifndef COC_H_
#define COC_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ServicesHandler_Api.h"

#include "OSAL_Kmsg.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define PROCESS_COC_PRE_SERVICES_BITMAP			(1 << SERVICE_ID_PAUSE_ALL)
#define PROCESS_COC_POST_SERVICES_BITMAP		(1 << SERVICE_ID_RESUME_ALL)

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _cocDb_t
{
	cocState_e	CoCstate;
	uint8 		requestedTxAntsMask;
	uint8		requestedTxAntsNum;	
	uint8 		requestedRxAntsMask;
	uint8		requestedRxAntsNum;	
	uint8 		currentTxAntsMask;
	uint8		currentTxAntsNum;	
	uint8 		currentRxAntsMask;	
	uint8		currentRxAntsNum;
	uint8		maxRxAntsNum;
	uint8		numOfVaps;
} cocDb_t;


//---------------------------------------------------------------------------------
//						Static Function Declaration				
//---------------------------------------------------------------------------------
void CoC_SetAntsReq(K_MSG* psMsg);
void CoC_StartSetAntsProcess(K_MSG* psMsg);
void CoC_FinalizeSetAntsProcess(K_MSG* psMsg);
void CoC_HdkSetAntsDone(K_MSG* psMsg);
void CoC_LinkAdaptiveSetAntsDone(K_MSG* psMsg);
void CoC_AddVap(K_MSG* psMsg);
void CoC_RemoveVap(K_MSG* psMsg);
void CoC_MuResetOperationCfm(K_MSG* psMsg);
void CoC_SendNotificationToOtherModule(K_MSG_TYPE kmsgType, K_TASKID taskId);
void CoC_updateOtherCoreOnAntChange(void);
void CoC_UpdateAntConfigFromHdk(K_MSG* psMsg);

#endif //COC_H_


