/************************************************************************************
*    
*    File:		  ConfigurationManager_api.h
*    Class/Module: 
*    Description: 
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/


#ifndef CONFIGURATION_MANAGER_API_H
#define CONFIGURATION_MANAGER_API_H

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND1				(0)
#define CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND0_IN_DUAL_BAND	(16)
#define CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND0_IN_SINGLE_BAND	(0)

#define CONFIGURATION_MANAGER_LAST_VAP_IN_BAND1					(15)
#define CONFIGURATION_MANAGER_LAST_VAP_IN_BAND0_IN_DUAL_BAND	(31)
#define CONFIGURATION_MANAGER_LAST_VAP_IN_BAND0_IN_SINGLE_BAND	(15)

#define CONFIGURATION_MANAGER_FIRST_SID_IN_BAND1				(0)
#define CONFIGURATION_MANAGER_FIRST_SID_IN_BAND0_IN_DUAL_BAND	(128)
#define CONFIGURATION_MANAGER_FIRST_SID_IN_BAND0_IN_SINGLE_BAND	(0)


#ifdef ALPHA_FILTER_MIN_RSSI_FOR_LAST_STATION_IN_BAND // because of HW bug described in https://jira-chd.intel.com/browse/WLANVLSIIP-2962 avoid using SID 127 in CDB mode
#define CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND1	(HW_NUM_OF_STATIONS / 2 - 1);
#else
#define CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND1	(HW_NUM_OF_STATIONS / 2 );
#endif // endif ALPHA_FILTER_MIN_RSSI_FOR_LAST_STATION_IN_BAND
#define CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND0_IN_DUAL_BAND		(HW_NUM_OF_STATIONS/2 - 1); // last SID reserved to logger
#define CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND0_IN_SINGLE_BAND	(HW_NUM_OF_STATIONS - 1); // last SID reserved to logger


typedef enum
{
	CONFIGURATION_MANAGER_BAND_0 = 0,
	CONFIGURATION_MANAGER_BAND_1,
	NUM_OF_CONFIGURATION_MANAGER_BANDS,
	CONFIGURATION_MANAGER_COMMON_BAND = NUM_OF_CONFIGURATION_MANAGER_BANDS,	
	CONFIGURATION_MANAGER_INVALID_BAND, // TBD - is it needed? maybe it should be replaced with ASSERT wherever it is used
	MAX_CONFIGURATION_MANAGER_BANDS = 0xFF
} BandId_e;



typedef enum
{
	CONFIGURATION_MODE_SINGLE_BAND = 0,
	CONFIGURATION_MODE_DUAL_BAND,
	NUM_OF_CONFIGURATION_MODE,
	MAX_CONFIGURATION_MODE = 0xFF
} BandConfigurationMode_e;

typedef enum
{
	CONFIGURATION_PCI_MODE_SINGLE_PCI = 0,
	CONFIGURATION_PCI_MODE_DUAL_PCI,
	CONFIGURATION_PCI_MODE_MAX_VAL = 0xFF
} CardConfigurationPciMode_e;

typedef enum
{
	DUAL_BAND_ZWDFS_DIS = 0,
	DUAL_BAND_ZWDFS_EN,

}ZWDFSstat_e;

#ifdef ENET_INC_HW_FPGA
typedef enum
{
	CONFIGURATION_TEST_PLATFORM_TYPE_FPGA = 0,
	CONFIGURATION_TEST_PLATFORM_TYPE_PDXP,
} CardConfigurationTestPlatformType_e;
#endif //ENET_INC_HW_FPGA

typedef struct _CARD_CONFIGURATION_MODE
{
	BandConfigurationMode_e 				CardConfigurationBandMode;
	CardConfigurationPciMode_e 				CardConfigurationPciMode;
#ifdef ENET_INC_HW_FPGA
	CardConfigurationTestPlatformType_e		CardConfigurationTestPlatformType;
#endif //ENET_INC_HW_FPGA
#ifdef ENET_INC_ARCH_WAVE600
	uint32 									totalDmaTp;
	ZWDFSstat_e									isZWDFS;
#endif //ENET_INC_ARCH_WAVE600
} CARD_CONFIGURATION_MODE;


typedef enum
{
	PCI_FIRST_GEN_TYPE = 1,
	PCI_GEN_TYPE_GEN_1 = PCI_FIRST_GEN_TYPE,		
	PCI_GEN_TYPE_GEN_2,
	PCI_GEN_TYPE_GEN_3,
	TOTAL_PCI_GEN_TYPES,
} PciConfigurationType_e;


typedef enum
{
	PCI_LINK_WIDTH_FIRST_TYPE = 1,
	PCI_LINK_WIDTH_TYPE_SINGLE_LANE = PCI_LINK_WIDTH_FIRST_TYPE,		
	PCI_LINK_WIDTH_TYPE_DUAL_LANE,
	TOTAL_PCI_LINK_WIDTH_TYPES,
} LinkWidthType_e;



//taken from PCI Express Base Specification Revision 3.0
typedef struct _PcieCapabilitiesElement_
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 pciExpressCapId          		: 8;
			uint32 nextCapPointer           		: 8;
			uint32 pciExpressCapabilitiesRegister  : 16;
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 deviceCapabilities   			: 32;
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 deviceControl					 : 16;
			uint32 deviceStatus              		 : 16;
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 linkCapabilities					 : 32; //bits [0..15]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 linkControl						 : 16;
			uint32 linkstatus  						 : 16;
		};
		struct
		{
			uint32 									 : 16;
			uint32 curentLinkSpeed					 : 4; //enum from PciConfigurationType_e
			uint32									 : 12;
		};
		struct
		{
			uint32 									 : 20;
			uint32 negotiatedLinkWidth				 : 6; //enum from LinkWidthType_e
			uint32									 : 8;
		};
		struct
		{
			uint32 									 : 26;
			uint32 undefined						 : 1;
			uint32									 : 5;
		};
		struct
		{
			uint32 									 : 27;
			uint32 linkTraining						 : 1;
			uint32									 : 4;
		};
		struct
		{
			uint32 									 : 28;
			uint32 slotClockConfiguration			 : 1;
			uint32									 : 3;
		};
		struct
		{
			uint32 									 : 29;
			uint32 dataLinkLayerLinkActive			 : 1;
			uint32									 : 2;
		};
		struct
		{
			uint32 									 : 30;
			uint32 linkBandwithManagementStatus		 : 1;
			uint32									 : 1;
		};
		struct
		{
			uint32 									 : 31;
			uint32 linkAutonomousBandwithStatus		 : 1;
		};		
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 slotCapabilities					 : 32;
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 slotControl						 : 16;			
			uint32 slotStatus						 : 16;
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 rootControl						 : 16;			
			uint32 rootCapabilities					 : 16;
		};
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 rootStatus						 : 32;			
		};
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 deviceCapabilities2				 : 32;			
		};
	};
	union //word10
	{
		uint32 word10;
		struct
		{
			uint32 deviceControl2					 : 16;
			uint32 deviceStatus2              		 : 16;
		};
	};
	union //word11
	{
		uint32 word11;
		struct
		{
			uint32 linkCapabilities2				: 32; //bits [0..15]
		};
	};
	union //word12
	{
		uint32 word12;
		struct
		{
			uint32 linkControl2						 : 16;
			uint32 linkstatus2  					 : 16;
		};
	};
	union //word13
	{
		uint32 word13;
		struct
		{
			uint32 slotCapabilities2				 : 32;
		};
	};
	union //word14
	{
		uint32 word14;
		struct
		{
			uint32 slotControl2						 : 16;			
			uint32 slotStatus2						 : 16;
		};
	};
} PcieCapabilitiesElement_t;



#define	PCIE_0_DBI_REGISTERS_OFFSET_FROM_TOP_REGBLOCK			(0xB000)
#define	PCIE_1_DBI_REGISTERS_OFFSET_FROM_TOP_REGBLOCK			(0xF000)
#define	PCIE_CAPABILITIES_STRUCTURE_OFFSET_IN_PCIE_DBI_EGISTERS	(0x70) //the PCIE capabilities is a linked list. This offset points to a specific element in the linked list (always in same location)

#ifdef ENET_INC_ARCH_WAVE600

//dma total TP per pcie configuration
#define DMA_TOTAL_TP_SINGLE_EP_GEN1_SINGLE_LANE	(1200000) // in Kb/s 
#define DMA_TOTAL_TP_SINGLE_EP_GEN2_SINGLE_LANE	(2400000) // in Kb/s 
#define DMA_TOTAL_TP_SINGLE_EP_GEN2_DUAL_LANE	(MAX_DMA_TOTAL_TP) // in Kb/s 
#define DMA_TOTAL_TP_DUAL_EP_GEN2_SINGLE_LANE	(MAX_DMA_TOTAL_TP) // in Kb/s 
#define DMA_TOTAL_TP_SINGLE_EP_GEN3_SINGLE_LANE	(MAX_DMA_TOTAL_TP) // in Kb/s 
#define DMA_TOTAL_TP_SINGLE_EP_GEN3_DUAL_LANE	(MAX_DMA_TOTAL_TP) // in Kb/s

#define MAX_DMA_TOTAL_TP						(4800000) // in Kb/s


#define DMA_TOTAL_TP_CONFIGURATION_NOT_VALID	(0xFFFFFFFF)

#endif //ENET_INC_ARCH_WAVE600


/*---------------------------------------------------------------------------------
/						Prototypes						
/----------------------------------------------------------------------------------*/
BandConfigurationMode_e ConfigurationManager_GetBandConfigurationMode(void);
CardConfigurationPciMode_e ConfigurationManager_GetConfigurationPciMode(void);
ZWDFSstat_e ConfigurationManager_GetIsDualBandZWDFS(void);
bool ConfigurationManager_IsZwdfsVap(uint8 vapId);


#ifdef ENET_INC_HW_FPGA
CardConfigurationTestPlatformType_e ConfigurationManager_GetConfigurationTestPlatformType(void);
#endif //ENET_INC_HW_FPGA

CARD_CONFIGURATION_MODE *ConfigurationManager_GetCardConfiguration(void);

#ifdef ENET_INC_ARCH_WAVE600
uint32 ConfigurationManager_GetTotalDmaTp(void);
#endif //ENET_INC_ARCH_WAVE600
uint8 ConfigurationManager_GetNumOfActiveBands(void);
uint8 ConfigurationManager_GetFirstVapForBand1(void);
uint8 ConfigurationManager_GetFirstVapForBand0(void);
uint8 ConfigurationManager_GetLastVapForBand1(void);
uint8 ConfigurationManager_GetLastVapForBand0(void);
uint8 ConfigurationManager_GetFirstVapForBand(BandId_e band);
BandId_e ConfigurationManager_GetBandForVap(uint8 vapId) ;
#if defined(ENET_INC_UMAC) 
uint8 ConfigurationManager_GetBandForStation(StaId stationId);
#endif
#if defined (ENET_INC_ARCH_WAVE600)
uint8 ConfigurationManager_GetBandForGroup(uint8 groupId);
#endif
StaId ConfigurationManager_GetFirstSidInMyBand(void);
StaId ConfigurationManager_GetFirstSidForBand(BandId_e band);
StaId ConfigurationManager_GetFirstSidForBand0(void);
StaId ConfigurationManager_GetFirstSidForBand1(void);




uint16 ConfigurationManager_GetNumOfSupportedStationsInMyBand(void);
uint16 ConfigurationManager_GetNumOfSupportedStationsForBand(BandId_e band);
uint16 ConfigurationManager_GetNumOfSupportedStationsForBand1(void);
uint16 ConfigurationManager_GetNumOfSupportedStationsForBand0(void);


BandId_e ConfigurationManager_GetMyBand(void);
uint8 ConfigurationManager_GetAntMask(void);
uint8 ConfigurationManager_GetNumOfVapsInMyBand(void);
uint8 ConfigurationManager_GetNumOfVapsInBand(BandId_e band);
uint8 ConfigurationManager_ConvertVapAndRadioToActualVap(uint8 Radio, uint8 VapId) ;
uint8 ConfigurationManager_ConvertActualVapToVapAndRadio(uint8 ActualVapIndex, uint8 *Radio);
uint8 ConfigurationManager_GetFirstVapForMyBand(void);
uint8 ConfigurationManager_GetLastVapForMyBand(void);

void ConfigurationManager_ReadConfigurationModeFromDriver(void);
#ifdef ENET_INC_ARCH_WAVE600
void ConfigurationManager_ReadDmaConfiguration(void);
#endif //#ifdef ENET_INC_ARCH_WAVE600

#if defined(ENET_INC_LMAC)&&defined (ENET_INC_ARCH_WAVE600) 
void ConfigurationManager_Init(void);
#endif //defined(ENET_INC_UMAC) 

#endif //CONFIGURATION_MANAGER_API_H
