/**************************************************************************
***************************************************************************
**
** COMPONENT:        ConfigurationManager.c
**
** MODULE:          
**
** VERSION:          $Revision: #10 $
**
** AUTHOR:           
**
** DESCRIPTION:      
**
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/

#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ConfigurationManager_api.h"
#include "StaDatabase_Api.h"
#include "loggerAPI.h"
#include "RegAccess_Api.h"
#include "HostInterface_API.h"
#include "GroupManager_API.h"
#include "SocRegsRegs.h"
#if defined (ENET_INC_ARCH_WAVE600) && defined(ENET_INC_LMAC) 
#include "MacGeneralRegs.h"
#endif //defined(ENET_INC_UMAC)
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
	
#define LOG_LOCAL_GID	GLOBAL_GID_CONFIGURATION_MANAGER
#define LOG_LOCAL_FID 	0



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Globals							
/----------------------------------------------------------------------------------*/

// band configuration mode global - needed in all CPUs, since they can all check on it.
CARD_CONFIGURATION_MODE CardConfiguration;



//static table for all DMA configuration options for single and dual end point

#ifdef ENET_INC_ARCH_WAVE600

const uint32 singleEpDmaConfiguration[TOTAL_PCI_GEN_TYPES - 1][TOTAL_PCI_LINK_WIDTH_TYPES - 1] = 
{
//					single lane							dual lane	
	{DMA_TOTAL_TP_SINGLE_EP_GEN1_SINGLE_LANE, DMA_TOTAL_TP_CONFIGURATION_NOT_VALID},
	{DMA_TOTAL_TP_SINGLE_EP_GEN2_SINGLE_LANE, DMA_TOTAL_TP_SINGLE_EP_GEN2_DUAL_LANE},
	{DMA_TOTAL_TP_SINGLE_EP_GEN3_SINGLE_LANE, DMA_TOTAL_TP_SINGLE_EP_GEN3_DUAL_LANE},
};


const uint32 dualEpDmaConfiguration[TOTAL_PCI_GEN_TYPES - 1][TOTAL_PCI_LINK_WIDTH_TYPES - 1] = 
{
//					single lane							dual lane	
	{DMA_TOTAL_TP_CONFIGURATION_NOT_VALID, DMA_TOTAL_TP_CONFIGURATION_NOT_VALID},
	{DMA_TOTAL_TP_DUAL_EP_GEN2_SINGLE_LANE, DMA_TOTAL_TP_CONFIGURATION_NOT_VALID},
	{DMA_TOTAL_TP_CONFIGURATION_NOT_VALID, DMA_TOTAL_TP_CONFIGURATION_NOT_VALID},
};

#endif //ENET_INC_ARCH_WAVE600


// acoifman debug, for integration only

CARD_CONFIGURATION_MODE *ConfigurationManager_GetCardConfiguration(void)
{
	return &CardConfiguration; 
}


/**********************************************************************************

ConfigurationManager_GetConfigurationPciMode

Description:
----------
	
**********************************************************************************/
CardConfigurationPciMode_e ConfigurationManager_GetConfigurationPciMode(void)
{
	return CardConfiguration.CardConfigurationPciMode; 
}


#ifdef ENET_INC_HW_FPGA
/**********************************************************************************

ConfigurationManager_GetConfigurationTestPlatformType

Description:
----------
	
**********************************************************************************/
CardConfigurationTestPlatformType_e ConfigurationManager_GetConfigurationTestPlatformType(void)
{
	return CardConfiguration.CardConfigurationTestPlatformType; 
}
#endif //ENET_INC_HW_FPGA


/**********************************************************************************

ConfigurationManager_GetBandConfigurationMode

Description:
----------
	
**********************************************************************************/
BandConfigurationMode_e ConfigurationManager_GetBandConfigurationMode(void)
{
	return CardConfiguration.CardConfigurationBandMode; 
}

/**********************************************************************************

ConfigurationManager_GetisDualBandZWDFS

Description:
----------
	
**********************************************************************************/
ZWDFSstat_e ConfigurationManager_GetIsDualBandZWDFS(void)
{
	return CardConfiguration.isZWDFS; 
}

/**********************************************************************************

ConfigurationManager_IsZwdfsVap


Description:
----------
	
**********************************************************************************/
bool ConfigurationManager_IsZwdfsVap(uint8 vapId)
{

	if ((CONFIGURATION_MANAGER_BAND_1 == ConfigurationManager_GetBandForVap(vapId)) && (DUAL_BAND_ZWDFS_EN == ConfigurationManager_GetIsDualBandZWDFS()))
	{
		return TRUE; 
	}
	else
	{
		return FALSE;
	}
}


/**********************************************************************************

ConfigurationManager_ReadConfigurationModeFromDriver

Description:
----------
	
**********************************************************************************/
#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif

void ConfigurationManager_ReadConfigurationModeFromDriver(void)
{
	// Read the configuration mode from the CHI VECTOR as it was written by driver

	CardConfiguration.CardConfigurationBandMode = CONFIGURATION_MODE_SINGLE_BAND;
	CardConfiguration.isZWDFS = DUAL_BAND_ZWDFS_DIS;
	
#if defined(ENET_INC_ARCH_WAVE600)

	if (sCHIvectorArea.sCardConfigExt.sData.u32BandConfiguration == BAND_CONFIGURATION_MODE_DUAL_BAND)
	{
		CardConfiguration.CardConfigurationBandMode = CONFIGURATION_MODE_DUAL_BAND;
	}
	else if (sCHIvectorArea.sCardConfigExt.sData.u32BandConfiguration == BAND_CONFIGURATION_MODE_SINGLE_BAND_WITH_SCAN)
	{
		//FATAL("BAND_CONFIGURATION_MODE_SINGLE_BAND_WITH_SCAN not supported!");
		CardConfiguration.CardConfigurationBandMode = CONFIGURATION_MODE_DUAL_BAND;
		CardConfiguration.isZWDFS = DUAL_BAND_ZWDFS_EN;	
	}

	CardConfiguration.CardConfigurationPciMode = CONFIGURATION_PCI_MODE_SINGLE_PCI;
		
	if (sCHIvectorArea.sCardConfigExt.sData.u32PCIeCardConfiguration == CARD_CONFIGURATION_PCI_MODE_DUAL_PCI)
	{
		CardConfiguration.CardConfigurationPciMode = CONFIGURATION_PCI_MODE_DUAL_PCI;
	}

#ifdef ENET_INC_HW_FPGA
	switch (sCHIvectorArea.sCardConfigExt.sData.u32TestPlatformType)
	{
		case TEST_PLATFORM_TYPE_FPGA:
			CardConfiguration.CardConfigurationTestPlatformType = CONFIGURATION_TEST_PLATFORM_TYPE_FPGA;
			break;
		case TEST_PLATFORM_TYPE_PDXP:
			CardConfiguration.CardConfigurationTestPlatformType = CONFIGURATION_TEST_PLATFORM_TYPE_PDXP;
			break;
		default:
			DEBUG_FATAL("TEST PLATFORM TYPE not supported!");
			break;
	}
#endif //ENET_INC_HW_FPGA
	
#endif

}

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif


#ifdef ENET_INC_ARCH_WAVE600

PcieCapabilitiesElement_t pcieCapabilitiesElement;
RegSocRegsRcuBoot_u rcuBoot;

void ConfigurationManager_ReadDmaConfiguration(void)
{
	PcieCapabilitiesElement_t* pciCapabilitiesAddress;	

#ifdef ENET_INC_HW_FPGA
	if(CardConfiguration.CardConfigurationTestPlatformType == CONFIGURATION_TEST_PLATFORM_TYPE_PDXP)
#endif //ENET_INC_HW_FPGA
	{
		rcuBoot.val = 0;
		RegAccess_Read(REG_SOC_REGS_RCU_BOOT, &rcuBoot.val);

		switch(rcuBoot.bitFields.mspsStatus)
		{
			case 0x0: //dual EP mode
			{
				pciCapabilitiesAddress = (PcieCapabilitiesElement_t*)(TOP_REGBLOCK_BASE_ADDR + PCIE_1_DBI_REGISTERS_OFFSET_FROM_TOP_REGBLOCK + PCIE_CAPABILITIES_STRUCTURE_OFFSET_IN_PCIE_DBI_EGISTERS);			

				memcpy32(&pcieCapabilitiesElement, pciCapabilitiesAddress, (sizeof(PcieCapabilitiesElement_t) >> 2));

				//validate configuration is correct before acessing to dma configuration table
				ASSERT(pcieCapabilitiesElement.curentLinkSpeed >= PCI_FIRST_GEN_TYPE && pcieCapabilitiesElement.curentLinkSpeed < TOTAL_PCI_GEN_TYPES);			
				ASSERT(pcieCapabilitiesElement.negotiatedLinkWidth >= PCI_LINK_WIDTH_FIRST_TYPE && pcieCapabilitiesElement.negotiatedLinkWidth < TOTAL_PCI_LINK_WIDTH_TYPES);			

				CardConfiguration.totalDmaTp = dualEpDmaConfiguration[pcieCapabilitiesElement.curentLinkSpeed - 1][pcieCapabilitiesElement.negotiatedLinkWidth - 1];
				break;
			}		
			case 0x1: //Single EP, 2 lane
			case 0x2: //Single EP, 1 lane
			case 0x3: //Single EP, 2 lane
			{
				pciCapabilitiesAddress = (PcieCapabilitiesElement_t*)(TOP_REGBLOCK_BASE_ADDR + PCIE_0_DBI_REGISTERS_OFFSET_FROM_TOP_REGBLOCK + PCIE_CAPABILITIES_STRUCTURE_OFFSET_IN_PCIE_DBI_EGISTERS);
				
				memcpy32(&pcieCapabilitiesElement, pciCapabilitiesAddress, (sizeof(PcieCapabilitiesElement_t) >> 2));			
				
				//validate configuration is correct before acessing to dma configuration table
				ASSERT(pcieCapabilitiesElement.curentLinkSpeed >= PCI_FIRST_GEN_TYPE && pcieCapabilitiesElement.curentLinkSpeed < TOTAL_PCI_GEN_TYPES);			
				ASSERT(pcieCapabilitiesElement.negotiatedLinkWidth >= PCI_LINK_WIDTH_FIRST_TYPE && pcieCapabilitiesElement.negotiatedLinkWidth < TOTAL_PCI_LINK_WIDTH_TYPES);

				CardConfiguration.totalDmaTp = singleEpDmaConfiguration[pcieCapabilitiesElement.curentLinkSpeed - 1][pcieCapabilitiesElement.negotiatedLinkWidth - 1];
				break;
			}
			default:
				FATAL("ConfigurationManager_ReadDmaConfiguration");
	}

	ASSERT(CardConfiguration.totalDmaTp != DMA_TOTAL_TP_CONFIGURATION_NOT_VALID);	
	}
#ifdef ENET_INC_HW_FPGA
	else
	{
		CardConfiguration.totalDmaTp = MAX_DMA_TOTAL_TP;
	}
#endif //ENET_INC_HW_FPGA
}

#endif //ENET_INC_ARCH_WAVE600


/**********************************************************************************

ConfigurationManager_GetNumOfActiveBands

Description:
----------
	
**********************************************************************************/
uint8 ConfigurationManager_GetNumOfActiveBands(void)
{
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND) 
	{
		return 1;
	}
	else
	{
		return 2;
	}
}

#ifdef ENET_INC_ARCH_WAVE600

/**********************************************************************************

ConfigurationManager_GetTotalDmaTp

Description:
----------
	
**********************************************************************************/
uint32 ConfigurationManager_GetTotalDmaTp(void)
{
	return CardConfiguration.totalDmaTp;
}

#endif //ENET_INC_ARCH_WAVE600

/**********************************************************************************

ConfigurationManager_GetFirstVapForBand1

Description:
----------
	
**********************************************************************************/
uint8 ConfigurationManager_GetFirstVapForBand1(void)
{
	ASSERT(CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND);
	return CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND1;
}


/**********************************************************************************

ConfigurationManager_GetFirstVapForBand1

Description:
----------
	
**********************************************************************************/
uint8 ConfigurationManager_GetFirstVapForBand0(void)
{
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		return CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND0_IN_SINGLE_BAND;
	}
	else
	{
		return CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND0_IN_DUAL_BAND;
	}
}

/**********************************************************************************

ConfigurationManager_GetLastVapForBand1

Description:
----------
	
**********************************************************************************/
uint8 ConfigurationManager_GetLastVapForBand1(void)
{
	ASSERT(CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND);
	return CONFIGURATION_MANAGER_LAST_VAP_IN_BAND1;
}


/**********************************************************************************

ConfigurationManager_GetLastVapForBand1

Description:
----------
	
**********************************************************************************/
uint8 ConfigurationManager_GetLastVapForBand0(void)
{
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		return CONFIGURATION_MANAGER_LAST_VAP_IN_BAND0_IN_SINGLE_BAND;
	}
	else
	{
		return CONFIGURATION_MANAGER_LAST_VAP_IN_BAND0_IN_DUAL_BAND;
	}
}

/**********************************************************************************

ConfigurationManager_GetBandForVap

Description:
----------
	
**********************************************************************************/
BandId_e ConfigurationManager_GetBandForVap(uint8 vapId) 
{
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		return CONFIGURATION_MANAGER_BAND_0;
	}
	else
	{
		if (vapId < CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND0_IN_DUAL_BAND)
		{
			return CONFIGURATION_MANAGER_BAND_1;
		}
		else
		{
			return CONFIGURATION_MANAGER_BAND_0;
		}
	}
}


/**********************************************************************************

ConfigurationManager_GetBandForStation


Description:
----------
	
**********************************************************************************/
#if defined(ENET_INC_UMAC) 
uint8 ConfigurationManager_GetBandForStation(StaId stationId) 
{
	uint8 vapId;

	StaDb_GetVapId(stationId, &vapId);	
	return ConfigurationManager_GetBandForVap(vapId);
}
#endif

/**********************************************************************************

ConfigurationManager_GetFirstSidInMyBand


Description:
----------
	
**********************************************************************************/
StaId ConfigurationManager_GetFirstSidInMyBand(void)
{
	uint8 retVal = 0;

#if defined(ENET_INC_UMAC) 
	ASSERT(0); // Illegal request in this CPU
#else

	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
#if defined(ENET_INC_LMAC0) 
		retVal = CONFIGURATION_MANAGER_FIRST_SID_IN_BAND0_IN_SINGLE_BAND;
#endif
	
#if defined(ENET_INC_LMAC1) 
		ASSERT(0); // Illegal request in this CPU
#endif
	}
	else
	{
#if defined(ENET_INC_LMAC0) 
		retVal = CONFIGURATION_MANAGER_FIRST_SID_IN_BAND0_IN_DUAL_BAND;
#endif
			
#if defined(ENET_INC_LMAC1) 
		retVal = CONFIGURATION_MANAGER_FIRST_SID_IN_BAND1;
#endif
	}
#endif
	return retVal;
}


/**********************************************************************************

ConfigurationManager_GetFirstSidInBand


Description:
----------
	
**********************************************************************************/
StaId ConfigurationManager_GetFirstSidForBand(BandId_e band)
{
	StaId firstSid;

	if (band == CONFIGURATION_MANAGER_BAND_0)
	{
		firstSid = ConfigurationManager_GetFirstSidForBand0();
	}
	else
	{
		firstSid = ConfigurationManager_GetFirstSidForBand1();
	}

	return firstSid;
}



/**********************************************************************************
ConfigurationManager_GetFirstSidForBand0


Description:
----------
	
**********************************************************************************/
StaId ConfigurationManager_GetFirstSidForBand1(void)
{
	ASSERT(CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND);
	return CONFIGURATION_MANAGER_FIRST_SID_IN_BAND1;
}

/**********************************************************************************

ConfigurationManager_GetFirstSidForBand0


Description:
----------
	
**********************************************************************************/
StaId ConfigurationManager_GetFirstSidForBand0(void)
{
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		return CONFIGURATION_MANAGER_FIRST_SID_IN_BAND0_IN_SINGLE_BAND;
	}
	else
	{
		return CONFIGURATION_MANAGER_FIRST_SID_IN_BAND0_IN_DUAL_BAND;
	}
}


/**********************************************************************************

ConfigurationManager_GetNumOfSupportedStationsInMyBand


Description:
----------
	
**********************************************************************************/
uint16 ConfigurationManager_GetNumOfSupportedStationsInMyBand(void)
{
	uint8 retVal = 0;


#if defined(ENET_INC_UMAC) 
	ASSERT(0);
#else

	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
#if defined(ENET_INC_LMAC0) 
		retVal = CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND0_IN_SINGLE_BAND;
#endif
	
#if defined(ENET_INC_LMAC1) 
		ASSERT(0); // Illegal request in this CPU
#endif
	}
	else
	{
#if defined(ENET_INC_LMAC0) 
		retVal = CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND0_IN_DUAL_BAND;
#endif
	
#if defined(ENET_INC_LMAC1) 
		retVal = CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND1;
#endif

	}
#endif
	return retVal;
}


/**********************************************************************************
ConfigurationManager_GetNumOfSupportedStationsForBand


Description:
----------
	
**********************************************************************************/
uint16 ConfigurationManager_GetNumOfSupportedStationsForBand(BandId_e band)
{
	uint16 numOfStations;

	if (band == CONFIGURATION_MANAGER_BAND_0)
	{
		numOfStations = ConfigurationManager_GetNumOfSupportedStationsForBand0();
	}
	else
	{
		numOfStations = ConfigurationManager_GetNumOfSupportedStationsForBand1();
	}

	return numOfStations;
}



/**********************************************************************************
ConfigurationManager_GetNumOfSupportedStationsForBand1



Description:
----------
	
**********************************************************************************/
uint16 ConfigurationManager_GetNumOfSupportedStationsForBand1(void)
{
	ASSERT(CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND);
	return CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND1;
}

/**********************************************************************************
ConfigurationManager_GetNumOfSupportedStationsForBand0


Description:
----------
	
**********************************************************************************/
uint16 ConfigurationManager_GetNumOfSupportedStationsForBand0(void)
{
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		return CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND0_IN_SINGLE_BAND;
	}
	else
	{
		return CONFIGURATION_MANAGER_NUM_OF_SID_IN_BAND0_IN_DUAL_BAND;
	}
}





uint8 ConfigurationManager_GetAntMask(void)
{
	return 0xF; // TBD CDB - need to fix this.
}


uint8 ConfigurationManager_GetFirstVapForMyBand(void)
{
	uint8 firstVapId = 0;
#if defined(ENET_INC_LMAC0)
	firstVapId = ConfigurationManager_GetFirstVapForBand0();
#endif
#if defined(ENET_INC_LMAC1) 
	firstVapId = ConfigurationManager_GetFirstVapForBand1();
#endif
#if defined(ENET_INC_UMAC) && defined (ENET_INC_ARCH_WAVE600)
	ASSERT(0); // UM should not ask this question. It supports all VAPs in both bands.
#endif
#if defined(ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600)
	firstVapId = ConfigurationManager_GetFirstVapForBand0();
#endif
	return firstVapId;
}

uint8 ConfigurationManager_GetLastVapForMyBand(void)
{
	uint8 lastVapId = ConfigurationManager_GetLastVapForBand0(); //Value for single_band and DualBand_Band0

#if defined(ENET_INC_LMAC1) 
	lastVapId = ConfigurationManager_GetLastVapForBand1();
#endif
#if defined(ENET_INC_UMAC) && defined (ENET_INC_ARCH_WAVE600)
	ASSERT(0); // UM should not ask this question. It supports all VAPs in both bands.
#endif
	return lastVapId;
}


#if defined (ENET_INC_ARCH_WAVE600)
uint8 ConfigurationManager_ConvertVapAndRadioToActualVap(uint8 Radio, uint8 VapId) 
{
	uint8				ActualVapIndex;

	if (VapId != INVALID_VAP)
	{
		ActualVapIndex = VapId; // Assume we are in single band. If we are in dual band we will change it.
		if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND)
		{
			// In dual band mode the actual vap is different from the given vap only for band 0
			if (Radio == CONFIGURATION_MANAGER_BAND_0)
			{
				// In dual band mode, the inexes of band 0 are from 16-31. So 0->16 and 15->31
				ActualVapIndex = (VapId + CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND0_IN_DUAL_BAND);
			}
		}
	}
	else
	{
		// VAP is invalid so this is a MSG for the band. Use the default VAP of the given band.
		if (Radio == CONFIGURATION_MANAGER_BAND_0)
		{
			ActualVapIndex = ConfigurationManager_GetFirstVapForBand0();

		}
		else 
		{
			ActualVapIndex = ConfigurationManager_GetFirstVapForBand1();

		}
	}
	
	return ActualVapIndex;
}


uint8 ConfigurationManager_ConvertActualVapToVapAndRadio(uint8 ActualVapIndex, uint8 *Radio) 
{
	uint8 perBandVapId;


	perBandVapId = ActualVapIndex & 0xF; // Take the lower 4 bits of the actual Vap Index to be the VapId.
	*Radio = CONFIGURATION_MANAGER_BAND_0; // Assume it's band 0. If not it will be changed later.
	
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND)
	{
		if (ActualVapIndex < CONFIGURATION_MANAGER_FIRST_VAP_IN_BAND0_IN_DUAL_BAND)
		{
			*Radio = CONFIGURATION_MANAGER_BAND_1;
		}
	}
	
	return perBandVapId;
}

uint8 ConfigurationManager_GetBandForGroup(uint8 groupId) 
{
	uint8 vapId;
	uint8 band;
	
	vapId = GroupManager_GetVapforGroup(groupId);
	band = ConfigurationManager_GetBandForVap(vapId);
	
	return band;
}
#endif



uint8 ConfigurationManager_GetNumOfVapsInMyBand(void)
{
#if defined(ENET_INC_UMAC) 
		ASSERT(0); // UM should not ask this question. It supports all VAPs anyway.
#else

#if defined(ENET_INC_LMAC0)
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		return HW_NUM_OF_VAPS;
	}
	else if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND)
	{
		return (HW_NUM_OF_VAPS / 2);
	}
	else
	{
		ASSERT(0);
	}
#endif
#if defined(ENET_INC_LMAC1) 
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		return 0;
	}
	else if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND)
	{
		return (HW_NUM_OF_VAPS / 2);
	}
	else
	{
		ASSERT(0);
	}
#endif
#endif
	return 0xFF;
}
uint8 ConfigurationManager_GetNumOfVapsInBand(BandId_e band)
{
	uint8 retVal = 0;
	
	if (band == CONFIGURATION_MANAGER_BAND_0)
	{
		if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
		{
			retVal = HW_NUM_OF_VAPS;
		}
		else if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND)
		{
			retVal = (HW_NUM_OF_VAPS / 2);
		}
		else
		{
			ASSERT(0);
		}
	}
	else if (band == CONFIGURATION_MANAGER_BAND_1)
	{
		if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
		{
			retVal = 0;
		}
		else if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_DUAL_BAND)
		{
			retVal = (HW_NUM_OF_VAPS / 2);
		}
		else
		{
			ASSERT(0);
		}
	}
	else
	{
			ASSERT(0);
	}
	
	return retVal;
}
BandId_e ConfigurationManager_GetMyBand(void)
{
	BandId_e band = CONFIGURATION_MANAGER_INVALID_BAND;
#if defined(ENET_INC_LMAC0) 
	band =  CONFIGURATION_MANAGER_BAND_0;
#endif
#if defined(ENET_INC_LMAC1) 
	band  = CONFIGURATION_MANAGER_BAND_1;
#endif
#if defined(ENET_INC_UMAC) 
	band  = CONFIGURATION_MANAGER_BAND_0;
#endif

	return band;
}


uint8 ConfigurationManager_GetFirstVapForBand(BandId_e band)
{
	uint8 firstVap;
	
	if (band == CONFIGURATION_MANAGER_BAND_0)
	{
		firstVap = ConfigurationManager_GetFirstVapForBand0();
	}
	else
	{
		firstVap = ConfigurationManager_GetFirstVapForBand1();
	}

	return firstVap;
	
}


#if defined(ENET_INC_LMAC0)&&defined (ENET_INC_ARCH_WAVE600) 
void ConfigurationManager_Init(void)
{
	RegMacGeneralRetryDbBand1SingleMode_u 	retryDbBand1SingleModeReg;
	RegMacGeneralConfig0_u					config0Reg;

	retryDbBand1SingleModeReg.val 	= 0;
	config0Reg.val					= 0;


	// Config retry DB (single mode or not single mode).
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{	
		retryDbBand1SingleModeReg.bitFields.retryDbBand1SingleMode = TRUE;
	}
	else
	{
		retryDbBand1SingleModeReg.bitFields.retryDbBand1SingleMode = FALSE;
	}
	RegAccess_Write(REG_MAC_GENERAL_RETRY_DB_BAND1_SINGLE_MODE, retryDbBand1SingleModeReg.val);

	// Config retry DB (single mode or not single mode).
	if (CardConfiguration.CardConfigurationBandMode == CONFIGURATION_MODE_SINGLE_BAND)
	{
		// Configuration for single band
		config0Reg.bitFields.rxcMem1Band0Usg		= TRUE;		// Selects between band0 and band1. If '1' then Band 0 supports up to 36 users.
		config0Reg.bitFields.txcMem1Band0Usg		= TRUE;		// Selects between band0 and band1. If '1' then Band 0 supports up to 36 users.
	}
	else
	{
		// Configuration for dual band
		config0Reg.bitFields.rxcMem1Band0Usg		= FALSE;	// Selects between band0 and band1. If '1' then Band 0 supports up to 36 users.
		config0Reg.bitFields.txcMem1Band0Usg		= FALSE;	// Selects between band0 and band1. If '1' then Band 0 supports up to 36 users.
	}
	config0Reg.bitFields.lmac1AutoAddrMap		= TRUE; 	// if this is set then hardware automatically adds 12MB to any access that targets Band0 address space
	config0Reg.bitFields.b1GenriscRxAutoAddrMap = TRUE; 	// if this is set then hardware automatically adds 12MB to any access that targets Band0 address space
	config0Reg.bitFields.b1GenriscTxAutoAddrMap = TRUE; 	// if this is set then hardware automatically adds 12MB to any access that targets Band0 address space
	config0Reg.bitFields.band0MinVap			= ConfigurationManager_GetFirstVapForBand0();
	config0Reg.bitFields.band0MinSta			= ConfigurationManager_GetFirstSidInMyBand();
	RegAccess_Write(REG_MAC_GENERAL_CONFIG_0, config0Reg.val);

}
#endif 

