/***********************************************************************************
 File:			CsaManager_Api.h
 Module:		CSA Manager 
 Purpose: 		To handle Transmission of CSA Action Frames during Chanel Switch
 Description:	
************************************************************************************/
#ifndef CSA_MANAGER_API_H_
#define CSA_MANAGER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
typedef enum
{
	CSA_TYPE_CSA,
	CSA_TYPE_UC_DEAUTH,
	CSA_TYPE_MC_DEAUTH,
	CSA_TYPE_NUM_OF_TYPES,
} CsaManager_csaType_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct _CsaManagerStartTxReqParams_t
{
	UM_SET_CHAN_PARAMS *pUmSetChannelParams; //pointer to the payload carried in the original set channel request from driver
	uint16				chanSwitchTime;
	uint8				low_chan_num;
	uint8				low_chan_num2; // only for use with 80+80 mode
	uint8				chan_width; // values from the chanWidth enum
	uint8				primary_chan_idx; // within the 1 to 8 channels specified by chan_width, i.e., from 0 to 7
	uint8				block_tx;
	uint8				primaryChannel;
	uint8				secChannelOffset;
} CsaManagerStartTxReqParams_t;

typedef struct CsaManagerPacketConfirmedMessage
{
	TxPd_t *pd;
} CsaManagerPacketConfirmedMessage_t;

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void csaManagerVapOpen(K_MSG* csaManagerMessage);
void csaManagerVapRemove(K_MSG* csaManagerMessage);
void csaManagerStaOpen(K_MSG* csaManagerMessage);
void csaManagerStaRemove(K_MSG* csaManagerMessage);
void csaManagerTxStartReq(K_MSG* csaManagerMessage);
void csaManagerTxStopReq(K_MSG* csaManagerMessage);
void csaManagerVapGphpLockCfm(K_MSG* csaManagerMessage);
void csaManagerStaGphpLockCfm(K_MSG* csaManagerMessage);
#if defined CSA_REMOVE_RETRY	
void csaManagerStaMngLockCfm(K_MSG* csaManagerMessage);
#endif
void csaManagerTxCfm(K_MSG* csaManagerMessage);
void csaManagerPdAlloc(K_MSG* csaManagerMessage);
void csaManager_Init(void);

CsaManager_csaType_e CsaManager_GetCurrentTxSegment(uint8 vapIndex);
void csaManagerStartTxUcDeauthTimerExpired(K_MSG* csaManagerMessage);
void csaManagerStartTxMcDeauthTimerExpired(K_MSG* csaManagerMessage);
#if defined(ENET_INC_ARCH_WAVE600)
void csaManagerStartTxUcDeauthTimerExpired_B1(K_MSG* csaManagerMessage);
void csaManagerStartTxMcDeauthTimerExpired_B1(K_MSG* csaManagerMessage);
#endif
uint32 csaManager_GetFrameLocation(uint8 bandId, uint32 vapId);
uint32 CsaManager_GetCsaDeauthFrameEnc(uint8 bandId);
uint32 csaManager_GetFrameLength(uint8 bandId, uint32 vapId);
uint16 CsaManager_VapManagerGetNumStaInVap(uint16 vapId);

#endif /* CSA_MANAGER_API_H_ */
