/***********************************************************************************
 File:			CsaManager.h
 Module:		CSA Manager
 Purpose: 		To handle Transmission of CSA Action Frames during Chanel Switch
 Description:	
************************************************************************************/
#ifndef CSA_MANAGER_H_
#define CSA_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void 	CsaManagerVapOpenInd(uint8 vapId);
void 	CsaManagerVapRemoveInd(uint8 vapId);
void 	csaManager_TxCfm(uint8 vapId);
void 	csaManager_BuildCsa(TxPd_t *pd);
void 	csaManager_BuildCsaUcDeAuth(TxPd_t *pd);
uint8	csaManager_GetChannelWidth(uint8 chan_width);

#ifdef ENET_INC_ARCH_WAVE600
uint8 	csaManager_GetCenterFreq0Idx(uint8 low_chan_num, uint8 chan_width, uint8 primary_chan_idx);
uint8 	csaManager_GetCenterFreq1Idx(uint8 low_chan_num, uint8 chan_width);
#else
uint8 	csaManager_GetCenterFreq0Idx(uint8 low_chan_num, uint8 chan_width);
#endif //ENET_INC_ARCH_WAVE600
#endif /* CSA_MANAGER_H_ */






