/***********************************************************************************
 File:			CsaManager_StaManager.h
 Module:		CSA Manager Vap Manager
 Purpose: 		To handle Transmission of CSA Action Frames during Chanel Switch
 Description:	
************************************************************************************/
#ifndef CSA_MANAGER_STA_MANAGER_H_
#define CSA_MANAGER_STA_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
bool CsaManager_StaManagerIsStaPmf(StaId sid);
uint8 CsaManager_StaManagerGetVap(StaId sid);
void CsaManager_StaManagerTxStart(StaId sid);
void CsaManager_StaManagerTxStop(StaId sid);

void CsaManager_StaManagerInit(void);
void CsaManager_StaManagerTxCfmMessageHandler(K_MSG* csaManagerMessage);

#endif /* CSA_MANAGER_STA_MANAGER_H_ */






