/***********************************************************************************
 File:			CsaManager_VapManager.h
 Module:		CSA Manager Vap Manager
 Purpose: 		To handle Transmission of CSA Action Frames during Chanel Switch
 Description:	
************************************************************************************/
#ifndef CSA_MANAGER_VAP_MANAGER_H_
#define CSA_MANAGER_VAP_MANAGER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
bool CsaManager_VapManagerIsHT(uint8 vapId);
bool CsaManager_VapManagerIsVHT(uint8 vapId);
void CsaManager_VapManagerTxStart(uint8 vapId);
void CsaManager_VapManagerTxStop(uint8 vapId);
void CsaManager_VapManagerAddStaInd(uint8 vapId, StaId sid);
void CsaManager_VapManagerRemoveStaInd(uint8 vapId, StaId sid);
void csaManager_VapManagerTxCfm(uint8 vapId, StaId sid);
void csaManager_VapManagerTxInd(TxPd_t *pd);
bool CsaManager_VapManagerRemoveStaFromSecQueue(uint8 vapId, StaId sid);
void CsaManager_VapManagerInit(void);
void CsaManager_VapManagerMcTxCfmMessageHandler(K_MSG* csaManagerMessage);

#endif /* CSA_MANAGER_VAP_MANAGER_H_ */





