/***********************************************************************************
 File:			CtsManager_Api.h
 Module:		CTS Manager 
 Purpose: 		To handle Transmission of CTS 2 Self frames
 Description:	
************************************************************************************/
#ifndef CTS_MANAGER_API_H_
#define CTS_MANAGER_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "PacketDescriptor.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
#define CTS2SELF_DURATION_MSEC_RSSI_MODE	(32)	//32 msec
#define CTS2SELF_DURATION_MSEC_NORMAL_MODE	(5)		//5 msec
#define CTS2SELF_DURATION_MSEC_EXPANDED_MODE (10)	//10 msec

/*CTS transmission REQ message*/
typedef struct CtsManagerTxReqMessage
{
	uint32				timeout;	/*timeout to wait for CTS transmission*/
	uint16				duration;	/*Duration to write into CTS packet in [msec]*/
	uint16				msgId;		/*Message to send on completion*/
	uint8				taskId;		/*Task to send confirmation to*/
	uint8				vapIndex;	/*VAP to send confirmation to*/	
	PdControlBwType_e	ctrl_bw;	/*BW to send the CTS on*/
} CtsManagerTxReqMessage_t;

/*CTS transmission CFM message*/
typedef struct CtsManagerTxCfmMessage
{
	uint8	status;		/*whether CTS transmission occurred or not*/
} CtsManagerTxCfmMessage_t;



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
extern void ctsManagerVapOpen(K_MSG* ctsManagerMessage);
extern void ctsManagerVapRemove(K_MSG* ctsManagerMessage);
extern void ctsManagerStartTx(K_MSG* ctsManagerMessage);
extern void ctsManagerStopTx(K_MSG* ctsManagerMessage);
#if defined(ENET_INC_ARCH_WAVE600)
extern void ctsManagerStopTx_B1(K_MSG* ctsManagerMessage);
#endif
extern void ctsManagerTxCfm(K_MSG* ctsManagerMessage);
extern void ctsManagerPdAlloc(K_MSG* ctsManagerMessage);
extern void ctsManagerGphpLock(K_MSG* ctsManagerMessage);
extern void ctsManager_Init(void);

#endif /* CSA_MANAGER_API_H_ */





