/**********************************************************************************
 File:			Deaggregator.h
 Module:	  		De-Aggregator & Header Conversion
 Purpose: 		holds all the definitions of the De-aggregation & Header Conversion API functions
 Description:  		This file is the API to the De-aggregation & Header Conversion module
				which is responsible of parsing AMSDUs to MSDUs and doing header converion 
***********************************************************************************/
#ifndef DEAGGREGATOR_H_
#define DEAGGREGATOR_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

// Turn on header conversion for  RD types of unicast data packets (based on RxDescriptorType_e)
#define HEADER_CONVERSION_MASK_PER_RD_TYPE 	((TRUE << RD_TYPE_UNICAST_QOS_DATA) | (TRUE << RD_TYPE_UNICAST_NON_QOS_DATA) | (TRUE << RD_TYPE_MULTICAST_DATA) | (TRUE << RD_TYPE_UNICAST_NON_QOS_DATA_PROTECTED) | (TRUE << RD_TYPE_UNICAST_QOS_DATA_PROTECTED))

// Number of cycles to wait before Deaggregator indicate that MSDU ring is stuck. 0xFFFF = ~10uSec (in 640 Mhz clock)
#define MSDU_RING_FULL_COUNT_LIMIT			(0xFFFF)

// Max supported frame length. currently - set to 2400 for the big management frames buffers in host.
#define DEAGGREGATOR_MAX_FRAME_LENGTH		(2400)


// If there is no conversion, the value of this field is added to the flow control (which already includes the frame header). 
// The Resolution is of 8 bytes (0b000 = 0 bytes, 0b111 = 56 bytes).
// This guarantees that fields in the payload which are needed by SW are already valid (for example - action category).
#define FLOW_CONTROL_BYTE_COUNT				(0x1)	


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef enum
{
	CONVERSION_TYPE_NO_CONVERSION,						// 0x0
	CONVERSION_TYPE_LLC_SNAP_CONVERSION_ETYPE_10,		// 0x1
	CONVERSION_TYPE_ETH_II_EAPOL_CONVERSION_ETYPE_11,	// 0x2
	CONVERSION_TYPE_ETH_II_CONVERSION_ETYPE_00,			// 0x3
} DeaggregatorConversionType_e;





#endif /* DEAGGREGATOR_H_ */

