/***************************************************************
 File:		DeliaRecipes_Api.h
 Module:	  	Delia Recipes
 Purpose: 	construct the Delia recipes and the recipes pointer table
 Description:  This file is the API to the construction of the Delia recipes module 
 			and the recipes pointers table
***************************************************************/
#ifndef DELIA_RECIPES_API_H_
#define DELIA_RECIPES_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "DeliaRecipes.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

#if defined (ENET_INC_ARCH_WAVE600B) 
typedef struct suTcrs
{
	TcrCommon_t common;
	TcrUser_t   user;

}SuTcrs_t;
#endif


//---------------------------------------------------------------------------------
//						Global Variables					
//---------------------------------------------------------------------------------

#if defined (ENET_INC_ARCH_WAVE600)
extern DeliaRecipes_t* 	pDeliaRecipes;
extern Tcr_t*			pDeliaAutoResponseTcrs;
#endif

#if defined (ENET_INC_ARCH_WAVE600B)
extern SuTcrs_t*		pMbfmTcrs;
#endif

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void DeliaRecipes_ConstructRecipes(void);
uint32 DeliaRecipes_GetRecipe0Address(void);
#if defined (ENET_INC_ARCH_WAVE600)
uint32 DeliaRecipes_GetAutoResponseSURecipeAddress(void);
uint32 DeliaRecipes_GetAutoResponseMUBroadcastRecipeAddress(void);
uint32 DeliaRecipes_GetAutoResponseMUUnicastRecipeAddress(void);
uint32 DeliaRecipes_GetBfReportRecipeAddress(void); 

#else
uint32* DeliaRecipes_GetAckRecipeAddress(void);
uint32* DeliaRecipes_GetBaRecipeAddress(void);
uint32* DeliaRecipes_GetCtsAutoResponseRecipeAddress (void);
uint32* DeliaRecipes_GetBfReportAutoResponseRecipeAddress(void);
#endif

#endif /* DELIA_RECIPES_API_H_ */


