/***************************************************************
 File:		DeliaRecipes.h
 Module:	  	Delia Recipes
 Purpose: 	holds the definions for construction of the Delia recipes 
 Description:  This file contains the definions of the construction of the Delia recipes module
 			and the recipes pointers table
***************************************************************/
#ifndef DELIA_RECIPES_H_
#define DELIA_RECIPES_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "protocol.h"
#include "frame.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------


/* Delia general values and sizes */						
#define TCR_LENGTH_TO_SEND              			8
#define ONE_MPDU_TO_COUNTER             			1
#define BEACON_COUNTER_ONE             				1
#define MPDU_COUNTER_ZERO               			0
#define CRC_LENGTH                      			4
#define DELIMITER_LENGTH               		 		4
#define SIZE_OF_TIMESTAMP               			8 
#define BF_ENTRY_SHIFT_SIZE             			9
#define BF_INDEX_SHIFT                  			3
#define MPDU_DESCRIPTOR_SIZE            			0xC
#define ELEMENT_DESCRIPTOR_SIZE         			0xC
#define SENDER_INTTEURPT_VAULE          			0x1
#define AUTO_FILL_START_INDICATION      			0x1
#define AUTO_FILL_END_INDICATION        			0x2
//#define TIM_HW_BYTES_LENGTH             			3
//#define TIM_ID_AND_LENGTH_SIZE          			2
#define SHIFT_WORDS_TO_BYTES            			2
#define SHIFT_WORD_TO_8_WORDS						3
#define TEMP_VAP_INDEX_VALUE            			16
#define TIM_CONSTANT_BYTES_LENGTH       			5
#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
#define RTS_WORKAROUND_LOOP_NUM_OF_NOPS_BEFORE_TCR3	30
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND


/* Delia TCRs */
#define TCR1_24GCOEX_NUMOFBITS		1
#define TCR1_24GCOEX_SHIFT	    	19
#define TCR1_24GCOEX_MASK 	    	MASK(TCR1_24GCOEX_NUMOFBITS,TCR1_24GCOEX_SHIFT,uint32)

#define TCR3_NOT_SOUNDING_NUMOFBITS 1
#define TCR3_NOT_SOUNDING_SHIFT	    1
#define TCR3_NOT_SOUNDING_MASK 	    MASK(TCR3_NOT_SOUNDING_NUMOFBITS,TCR3_NOT_SOUNDING_SHIFT,uint32)

#define TCR3_SMOOTH_NUMOFBITS	    1
#define TCR3_SMOOTH_SHIFT		    2
#define TCR3_SMOOTH_MASK 		    MASK(TCR3_SMOOTH_NUMOFBITS,TCR3_SMOOTH_SHIFT,uint32)

#define DELIA_ACK_TCR_0        0x0
#define DELIA_ACK_TCR_1        (TCR1_24GCOEX_MASK)
#define DELIA_ACK_TCR_2        0x0
#define DELIA_ACK_TCR_3        (TCR3_SMOOTH_MASK | TCR3_NOT_SOUNDING_MASK)
#define DELIA_ACK_TCR_4        SIZEOF_ACK_FRM

#define DELIA_BA_TCR_0        0x0
#define DELIA_BA_TCR_1        (TCR1_24GCOEX_MASK)
#define DELIA_BA_TCR_2        0x0
#define DELIA_BA_TCR_3        (TCR3_SMOOTH_MASK | TCR3_NOT_SOUNDING_MASK)
#define DELIA_BA_TCR_4        SIZEOF_BLOCK_ACK_FRM

#define DELIA_CTS_AUTO_RESPONSE_TCR_0        0x0
#define DELIA_CTS_AUTO_RESPONSE_TCR_1        0x0
#define DELIA_CTS_AUTO_RESPONSE_TCR_2        0x0
#define DELIA_CTS_AUTO_RESPONSE_TCR_3        (TCR3_SMOOTH_MASK | TCR3_NOT_SOUNDING_MASK)
#define DELIA_CTS_AUTO_RESPONSE_TCR_4        SIZEOF_CTS_FRM

#define DELIA_BF_REPORT_TCR_0_3_SIZE_IN_HOB  32 /* Each TCR is send as 2 words from the Delia */


/* Delia events */
#define TIMER_EVENT                  0x0001
#define BF_LENGTH_READY              0x0002
#define BF_REPORT_READY              0x0004
#define BF_REPORT_ERROR              0x0008
#define BF_REPORT_HT_CONTROL_READY   0x0010
#define DURATION_EVENT               0x0020
#define COUNTER_EVENT                0x0040
#define ALL_TCRS_IN_HOB_READY_EVENT  0x0100
#define TCR0_READY_EVENT             0x0200
#define TCR1_TO_WORD6_READY_EVENT    0x0400
#define WORD5_TO_WORD6_READY_EVENT   0x0800

#define BF_STATE_MACHINE_IDLE_EVENT  0x4000

#define ALL_TCRS_IN_HOB_READY_EVENT_BIT_OFFSET_IN_BYTE  0x0
#define ALL_TCRS_IN_HOB_READY_EVENT_BYTE_OFFSET_IN_REG  0x1


/* Delia masks */
#define BF_STATION_ID_BYTES_TO_MASK               0x1
#define BF_STATION_ID_MASK_PATTERN                0xFF
#define BF_STATION_ID_MODULO_4_MASK_PATTERN       0x3
#define BF_INDEX_ENTRY_BYTES_TO_MASK              0x1
#define BF_INDEX_ENTRY_MASK_PATTERN               0xFF
#define BF_LENGTH_BYTES_TO_MASK                   0x3
#define BF_LENGTH_MASK_PATTERN                    0xFF
#define PAYLOAD_LENGTH_BYTES_TO_MASK	          0x3
#define PAYLOAD_LENGTH_MASK_PATTERN 	          0xFF
#define PAYLOAD_ADDRESS_BYTES_TO_MASK	          0x7
#define PAYLOAD_ADDRESS_MASK_PATTERN	          0xFF
#define ELEMENT_LENGTH_BYTES_TO_MASK	          0x3 
#define ELEMENT_LENGTH_MASK_PATTERN 	          0xFF
#define TIM_BITMAP_LENGTH_BYTES_TO_MASK           0x1
#define TIM_BITMAP_LENGTH_MASK_PATTERN            0xFF
#define TIM_BITMAP_OFFSET_BYTES_TO_MASK           0x1
#define TIM_BITMAP_OFFSET_MASK_PATTERN            0xFF
#define BF_REPORT_SEQUENCE_NUMBER_BYTES_TO_MASK   0x3
#define BF_REPORT_SEQUENCE_NUMBER_MASK_PATTERN    0xFF
#define BF_REPORT_SEQUENCE_NUMBER_BYTES_TO_SAVE   0x3




//---------------------------------------------------------------------------------
//						Delia Registers						
//----------------------------------------------------------------------------------
#define R0          0
#define R1          1
#define R2          2
#define R3          3
#define R4          4
#define R5          5
#define R6          6
#define HOB         7

#define DELIA_DESCRIPTOR_REGISTER               	     R0
#define DELIA_MPDU_DESCRIPTOR_ADDREES_REGISTER  	     R0
#define DELIA_ELEMENT_DESCRIPTOR_ADDRESS_REGISTER	     R0
#define BF_TEMPORARY_ENTRY_ADDRESS_REGISTER              R0
#define AUTO_REPLY_TCR0_ADDR_REGISTER                    R0
#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
#define RTS_WORKAROUND_CB_POINTER_REGISTER				 R0
#define RTS_WORKAROUND_LOOP_COUNTER_REGISTER			 R0
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND

#define SENDER_INTERRUPT_VALUE_REGISTER                  R1
#define DELIA_MPDU_COUNTER_REGISTER                      R1
#define DELIA_BEACON_COUNTER_REGISTER	                 R1
#define DELIA_DESCRIPTOR_GENERAL_INFO_REGISTER           R1
#define BF_REPORT_NUMBER_OF_COLUMNS_REGISTER             R1
#define AUTO_REPLY_TCR2_ADDR_REGISTER                    R1
#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
#define RTS_WORKAROUND_TCR0_LOCATION_REGISTER            R1
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND

#define BF_STATION_ID_REGISTER                           R2
#define ZLD_COUNTER_REGISTER                             R2
#define TIM_BITMAP_LENGTH_REGISTER                       R2
#define RECIPE_ADDRESS_REGISTER                          R2
#define BF_REPORT_BEAMFORMEE_FINAL_SIZE_REGISTER         R2
#define START_DELIMITERS_COUNTER_REGISTER				 R2

#define HEADER_LENGTH_REGISTER                           R3
#define BF_INDEX_ENTRY_ADDRESS_REGISTER                  R3
#define TIM_BITMAP_OFFSET_REGISTER                       R3
#define BF_REPORT_SEQUENCE_NUMBER_ADDRESS_REGISTER       R3

#define HEADER_ADDRESS_REGISTER                          R4
#define BF_REPORT_ADDRESS_REGISTER                       R4
#define AUTO_FIIL_INDICATION_REGISTER                    R4
#define BF_REPORT_BEAMFORMEE_TX_BUFFER_ADDRESS_REGISTER  R4

#define PAYLOAD_LENGTH_REGISTER                          R5
#define ELEMENT_LENGTH_REGISTER				             R5
#define BF_REPORT_LENGTH_REGISTER                        R5
#define BF_REPORT_SEQUENCE_NUMBER_REGISTER               R5

#define PAYLOAD_ADDRESS_REGISTER                         R6
#define MPDU_TOTAL_LENGTH_REGISTER                       R6
#define REGULAR_ELEMENT_ADDRESS_REGISTER                 R6
#define VAP_INDEX_REGISTER						         R6
#define BF_INDEX_REGISTER                                R6
#define BF_TIMEOUT_VALUES_REGISTER                       R6


//---------------------------------------------------------------------------------
//						Delia offsets						
//----------------------------------------------------------------------------------
/* Delia descriptor common part */
#define TCR0_OFFSET_IN_DELIA_DESCRIPTOR              0x0
#define TCR1_OFFSET_IN_DELIA_DESCRIPTOR              0x4
#define TCR2_OFFSET_IN_DELIA_DESCRIPTOR              0x8
#define TCR3_OFFSET_IN_DELIA_DESCRIPTOR              0xC
#define TCR4_OFFSET_IN_DELIA_DESCRIPTOR              0x10
#define GENERAL_INFORMATION_OFFSET                   0x14
#define HEADER_LENGTH_OFFSET                         0x18
#define MPDUS_AND_ELEMENTS_DESCRIPTORS_OFFSET 	 	 0x1C
#define RECIPE_TYPE_SHIFT                            26
#define RECIPE_LOOKUP_TABLE_ENTRY_SIZE_SHIFT         2
#define LOOKUP_TABLE_ENTRY_OFFSET                    0x0


/* Delia descriptor mpdu part - legacy */
#define LEGACY_PAYLOAD_LENGTH_AND_ZLD_COUNT_OFFSET   0x1C
#define LEGACY_HEADER_ADDRESS_OFFSET                 0x20
#define LEGACY_PAYLOAD_ADDRESS_AND_LAST_BIT_OFFSET   0x24

/* Delia descriptor mpdu part -aggregation */
#define AGGREGATE_PAYLOAD_LENGTH_AND_ZLD_COUNT_OFFSET											0x0
#define AGGREAGTE_HEADER_ADDRESS_OFFSET															0x4
#define AGGREGATE_PAYLOAD_ADDRESS_AND_LAST_BIT_OFFSET											0x8
#define AGGREGATION_FIRST_MPDU_DESCRIPTOR_OFFSET												(MPDUS_AND_ELEMENTS_DESCRIPTORS_OFFSET - MPDU_DESCRIPTOR_SIZE)
#define MPDU_LAST_INDICATION_BYTE_NUMBER														3
#define MPDU_LAST_INDICATION_OFFET																(MPDU_LAST_INDICATION_BYTE_NUMBER + AGGREGATE_PAYLOAD_ADDRESS_AND_LAST_BIT_OFFSET) 
#define ZLD_COUNTER_OFFSET_IN_PAYLOAD_LENGTH_AND_ZLD_COUNT_REGISTER								16                     
#define MPDU_LAST_INDICATION_LOCATION_IN_BYTE													7
#define START_DELIMITERS_COUNTER_OFFSET_IN_HEADER_LENGTH_AND_START_DELIMITERS_COUNT_REGISTER	16                     


/* Delia descriptor beacon elements part */
#define BEACON_ELEMENT_GENERAL_REGISTER_OFFSET                       0x0
#define BEACON_ELEMENT_ADDRESS_OFFSET                                0x4
#define BEACON_VAP_INDEX_OFFSET                                      0x8
#define BEACON_FIRST_ELEMENT_DESCRIPTOR_OFFSET     					 (MPDUS_AND_ELEMENTS_DESCRIPTORS_OFFSET - ELEMENT_DESCRIPTOR_SIZE)
#define ELEMENT_LAST_INDICATION_BYTE_NUMBER                          3
#define ELEMENT_LAST_INDICATION_OFFSET	                             (ELEMENT_LAST_INDICATION_BYTE_NUMBER + BEACON_ELEMENT_GENERAL_REGISTER_OFFSET)
#define ELEMENT_TYPE_BYTE_NUMBER				                     2
#define ELEMENT_TYPE_OFFSET                                          (BEACON_ELEMENT_GENERAL_REGISTER_OFFSET + ELEMENT_TYPE_BYTE_NUMBER)
#define REGULAR_TYPE_BIT_NUMBER_IN_BYTE					             0									
#define TIM_TYPE_BIT_NUMBER_IN_BYTE						             1
#define TIMESTAMP_TYPE_BIT_NUMBER_IN_BYTE				             2
#define ELEMENT_LAST_INDICATION_LOCATION_IN_BYTE                     7
#define TIM_BITMAP_OFFSET_SHIFT                                      8
//#define TIM_ID_AND_LENGTH_OFFSET                                     0x4
//#define TIM_BITMAP_LENGTH_SHIFT                                      24


   
/* Delia descriptor BF part */
#define BF_STATION_ID_BYTE                 0
#define BF_INDICATION_BYTE                 2
#define BF_INDICATION_OFFSET               (GENERAL_INFORMATION_OFFSET + BF_INDICATION_BYTE)
#define BF_REPORT_LENGTH_OFFSET            0x1FC
#define BF_INDICATION_BIT_NUMBER_IN_BYTE   0


/* Delia BF report (auto reply) part */
#define BF_REPORT_MATRICES_EXIST_BIT_NUMBER_IN_BYTE          6
#define BF_REPORT_AFTER_NDP_BIT_NUMBER_IN_BYTE		         7
#define BF_REPORT_STATION_ID_MODULO_4_SHIFT                  30
#define BF_REPORT_BF_INDEX_SIZE_SHIFT                        3
#define BF_REPORT_BF_INDEX_SHIFT                             (BF_REPORT_STATION_ID_MODULO_4_SHIFT - BF_REPORT_BF_INDEX_SIZE_SHIFT)
#define VHT_INDICATION_BIT_NUMBER_IN_BYTE_IN_HOB             3//????
#define VALUE_TO_ADD_TO_SEQUENCE_NUMBER                      (0x1 << FM_SEQUENCE_NUMBER_SHIFT)                                  
#define BF_REPORT_SEQUENCE_NUMBER_OFFSET                     0
#define BF_REPORT_HT_CONTROL_SIZE                            4
#define BF_REPORT_HT_CONTROL_OFFSET_IN_ENTRY                 0x1FC
#define BF_REPORT_VHT_BIT_NUMBER_IN_BYTE_IN_CONTROL          4
#define BF_REPORT_ERROR_BIT_IN_BYTE_IN_CONTROL               2 
#define BF_REPORT_TOTAL_MIMO_SIZE                            3 
#define BF_REPORT_EMPTY_MIMO_VALUE                           0x007000 
#define BF_REPORT_FIRST_PART_OF_REGULAR_MIMO_SIZE            2
#define HOB_REGISTER_BF_REPORT_HTC_FIELD_SIZE				 4
#define BF_REPORT_SECOND_PART_OF_REGULAR_MIMO_SIZE           1
#define BF_REPORT_SNR_OFFSET_IN_BF_ENTRY                     0x4
#define BF_REPORT_BEAMFORMEE_MATRICES_OFFSET                 0
#define BF_REPORT_CHOOSE_ADDRESS_BIT_NUMBER_IN_BYTE			 0
#define HOB_REGISTER_ADDRESS_1_WITH_TA_BIT					 0

/* HOB registers offsets */

#define HOB_REGISTER_BA_CTRL_AND_SSN_OFFSET						          0x44
#define HOB_REGISTER_GENERAL_AUTO_REPLY_DUR_OFFSET	                      0x50
#define HOB_REGISTER_VAP_INDEX_FOR_TIMESTAMP_OFFSET			              0xB8
#define HOB_REGISTER_TIMESTAMP_RESULT_OFFSET                              0xBC
#define HOB_REGISTER_BF_REPORT_DURATION_OFFSET                            0xC4
#define HOB_REGISTER_TIM_CONSTANT_BYTES_OFFSET				    		  0xD0
//#define HOB_REGISTER_TIM_HW_BYTES_OFFSET      			                  0xD2  /* The first 2 bytes are transmitted from the Delia descriptors due to HW bug */
#define HOB_REGISTER_TIM_BITMAP_START_OFFSET                              0xD8
#define HOB_REGISTER_TIM_BITMAP_PARAMETERS_OFFSET				          0xEC
#define HOB_REGISTER_ADDRESS_1_WITH_TA_BIT_OFFSET						  0xF0
#define HOB_REGISTER_ADDRESS_1_OFFSET                                     0xF4
#define HOB_REGISTER_ADDRESS_2_OFFSET                                     0xFC

#define HOB_REGISTER_BF_ADDRESS_3_SELECT_OFFSET                           0x10C

//#define HOB_REGISTER_BF_LENGTH_OFFSET_IN_BF_REPORT                        0x1FC

#define HOB_REGISTER_BF_REPORT_CONTROL_REGISTER_OFFSET                    0x200
#define HOB_REGISTER_BF_REPORT_FRAME_LENGTH_OFFSET                        0x204
#define HOB_REGISTER_BF_REPORT_BEAMFORMEE_MATRICES_FINAL_SIZE             0x208
#define HOB_REGISTER_BF_REPORT_NUMBER_OF_COLUMNS_OFFSET                   0x20C
#define HOB_REGISTER_BF_REPORT_FIRST_PART_OF_REGULAR_MIMO_OFFSET          0x210
#define HOB_REGISTER_BF_REPORT_TEMPORARY_ENTRY_ADDRESS_OFFSET             0x214
#define HOB_REGISTER_BF_DATA_BASE_OFFSET                                  0x218
#define HOB_REGISTER_BF_INDEX_TABLE_BASE_ADDRESS_OFFSET                   0x21C
#define HOB_REGISTER_BF_REPORT_SECOND_PART_OF_REGULAR_MIMO_OFFSET         0x220
#define HOB_REGISTER_BF_REPORT_BEAMFORMEE_TX_BUFFER_BASE_ADDRESS_OFFSET   0x224
#define HOB_REGISTER_BF_REPORT_ADDRESS_1_OFFSET                           0x22C
#define HOB_REGISTER_BF_REPORT_TCR_0_3_OFFSET                             0x234
#define HOB_REGISTER_BF_REPORT_TOTAL_LENGHT_OFFSET                        0x254
#define HOB_REGISTER_BF_REPORT_VAP_DATABASE_TID_0_ADDRESS_OFFSET          0x264
#define HOB_REGISTER_BF_REPORT_HTC_FIELD_OFFSET					          0x268
#define HOB_REGISTER_BF_REPORT_ADDRESS_2_OFFSET                           0x26C
#define HOB_REGISTER_BF_REPORT_STATION_ID_OFFSET                          0x274
#define HOB_REGISTER_BF_REPORT_NDPA_VAP_INDEX_ADDRESS_OFFSET		      0x278

#define HOB_REGISTER_CRC_OFFSET                                           0x600

#define HOB_REGISTER_DELIA_COUNTER_OFFSET                                 0x800
#define HOB_REGISTER_DELIA_EVENTS_OFFSET                                  0x808
#define HOB_REGISTER_DELIA_DESCRIPTOR_OFFSET                              0x80C
#define HOB_REGISTER_SENDER_INTTEURPT_OFFSET                              0x810
#define HOB_REGISTER_AUTO_FILL_INDICATION_OFFSET                          0x814
#define HOB_REGISTER_VHT_INDICATION_OFFSET                                0x81C//????
#define HOB_REGISTER_BF_TIMEOUT_VALUES_OFFSET                             0x820
#define HOB_REGISTER_ZERO_DELIMITER_VALUE_OFFSET                          0x824
#define HOB_REGISTER_LAST_RX_CB_POINTER_OFFSET							  0x830
#define HOB_REGISTER_DELIMITER_LENGTH_OFFSET                              0x840
#define HOB_REGISTER_LEGACY_VHT_DELIMITER_LENGTH_OFFSET                   0x844
#define HOB_REGISTER_DELIMITER_RESULT_OFFSET                              0x848
#define HOB_REGISTER_DELIA_TIMER_OFFSET                                   0x84C
#define HOB_REGISTER_IS_LENGTH_ZERO_OFFSET								  0x860
#define HOB_REGISTER_BAD_DELIMITER_OFFSET								  0x864
#define HOB_REGISTER_TCR0_OFFSET										  0x868
#define HOB_REGISTER_TCR1_OFFSET										  0x86C
#define HOB_REGISTER_TCR2_OFFSET										  0x870
#define HOB_REGISTER_TCR3_OFFSET										  0x874
#define HOB_REGISTER_TCR4_OFFSET										  0x878


#define HOB_REGISTER_IS_LENGTH_ZERO_BIT									  0x0

/* Delia general offsets */
#define BF_TRANSMISSION_OFFSET          0
#define HEADER_TRANSMISSION_OFFSET      0
#define PAYLOAD_TRANSMISSION_OFFSET     0
#define ELEMENT_TRANSMISSION_OFFSET     0
#define BF_INDEX_LOAD_OFFSET            0

//---------------------------------------------------------------------------------
//						Macros					
//---------------------------------------------------------------------------------


#define START_BF        		                        (0x53000040)
#define START_DATA                                      (0x53000061)
#define RESET_CRC                                       (0x53000001)
#define SET_BUS_STATE_TO_TCR                    		(0x53000020)
#define START_RECIPE_NONE_AUTO_FRAME                    (0x53000224)
#define START_RECIPE_AUTO_FRAME                         (0x5300002c)
#define START_RECIPE_BF_REPORT                          (0x53000024)
#define TCR(immediateValue)    		  					(0x50000000  | (immediateValue))
#define END_RECIPE                                      (0xF0000000)
#define NOP                                             (0x70000000)

#define WAIT(event)                                     (0x74000000 | (event))
#define WAIT_FOR_TCR0_TO_BE_READY                       WAIT(TCR0_READY_EVENT)
#define WAIT_FOR_TCR1_TO_TCR4_TO_BE_READY               WAIT(TCR1_TO_TCR4_READY_EVENT)
#define WAIT_FOR_BF_IDLE_OR_TIMEOUT                     WAIT(TIMER_EVENT | BF_STATE_MACHINE_IDLE_EVENT)
#define WAIT_FOR_MPDU_OR_BEACON_TO_BE_READY             WAIT(COUNTER_EVENT)
#define WAIT_FOR_DURATION             					WAIT(DURATION_EVENT)
#define WAIT_BF_LENGTH_READY_OR_ERROR                   WAIT(BF_LENGTH_READY | BF_REPORT_ERROR)
#define WAIT_BF_HT_CONTROL_READY_OR_ERROR               WAIT(BF_REPORT_HT_CONTROL_READY | BF_REPORT_ERROR)
#define WAIT_BF_REPORT_READY_OR_ERROR                   WAIT(BF_REPORT_READY | BF_REPORT_ERROR)


#define LOAD_REGISTER_WITH_IMMEDIATE_VALUE(registerNumber,value)                           (0x40000000 | ((registerNumber) << 24) | ((unsigned long)(value) & 0x007FFFFF))
#define LOAD_REGISTER_WITH_VALUE_FROM_ADDRESS(destinationRegister,addressRegister,offset)  (0x48000000 | ((destinationRegister) << 24) | ((addressRegister) << 20) | ((unsigned long)(offset) & 0x000FFFFF))
#define LOAD_FROM_HOB(registerNumber,offset)                                               (0x47800000 | ((registerNumber) << 20) | ((unsigned long)(offset) & 0x00000FFF))
#define STORE(valueRegister,addressRegister,bytesToStore,offset)                           (0x48800000 | ((valueRegister) << 24) | ((addressRegister) << 20) | ((bytesToStore) << 16) | ((unsigned long)(offset) & 0x0000FFFF))
#define STORE_TO_HOB(registerNumber,offset)                                                (0x4f800000 | ((registerNumber) << 20) | ((unsigned long)(offset) & 0x00000FFF))

#define TRANSMIT_FROM_HOB(numberOfBytes,offset)                                                                 (0x07000000 |  ((numberOfBytes) << 12) | ((unsigned long)(offset) & 0x00000FFF))
#define TRANSMIT_ALIGNED_FROM_HOB(numberOfBytes,offset)                                                          (0x0fc00000 |  ((numberOfBytes) << 12) | ((unsigned long)(offset) & 0x00000FFF))
#define TRANSMIT_ALIGNED_FROM_HOB_WITH_LENGTH_FROM_REGISTER(lengthRegister,offset)                               (0x0f400000 |  ((lengthRegister) << 12) | ((unsigned long)(offset) & 0x00000FFF))
#define TRANSMIT_FROM_REGISTER(registerNumber,numberOfBytes,offset)                                             (0x00000000 | ((registerNumber) << 24) | ((numberOfBytes) << 12) | ((unsigned long)(offset) & 0x00000FFF))
#define TRANSMIT_FROM_REGISTER_WITH_LENGTH_FROM_REGISTER(addressRegister,numOfBytesRegister,offset)             (0x80000000 | ((addressRegister) << 24) | ((numOfBytesRegister) << 20) | ((unsigned long)(offset) & 0x00000FFF))
#define TRANSMIT_FROM_HOB_WITH_LENGTH_FROM_REGISTER_AND_OFFSET_FROM_REGISTER(numOfBytesRegister,offsetRegister) (0x87800000 | ((numOfBytesRegister) << 20) | (offsetRegister))
#define TRANSMIT_ALIGNED_TAIL_FROM_HOB(numberOfBytes,offset)								                    (0x17800000 | ((numberOfBytes) << 12) | ((unsigned long)(offset) & 0x00000FFF)) 
#define TRANSMIT_IMMEDIATE(numberOfBytes,immediateValue)											            (0x30000000 | ((numberOfBytes) << 24) | ((unsigned long)(immediateValue) & 0x00FFFFFF))
#define TRANSMIT_FROM_REGISTER_WITH_IMMEDIATE_SIZE(numberOfBytes,registerNumber)								(0x38000000 | ((numberOfBytes) << 24) | (registerNumber)) 


#define SKIP(registerNumber,falseBit,bitNumber,offset)		                            (0x60000000 | ((registerNumber) << 24) | ((falseBit) << 15) | ((bitNumber) << 12) | ((unsigned long)(offset) & 0x00000FFF))
#define SKIP_ON_HOB(falseBit,bitNumber,offset)		                                    (0x67000000 | ((falseBit) << 15) | ((bitNumber) << 12) | ((unsigned long)(offset) & 0x00000FFF))
#define SKIP_IF_EQUAL_TO_IMMEDIATE(registerNumber,falseBit,immediateValue)		        (0x60800000 | ((registerNumber) << 24) | ((falseBit) << 19) | ((unsigned long)(immediateValue) & 0x00007FFF))
#define JUMP(address)      		                                                        (0x71000000 | ((unsigned long)(address) & 0x007FFFFC))
#define JUMP_FROM_REGISTER(registerNumber,offset)      		                            (0x79000000 | ((registerNumber) << 20) | ((offset) & 0x007FFFFC))
#define SHIFT_LEFT(registerNumber,shift)                                                (0xa8000000 | ((registerNumber) << 24) | ((unsigned long)(shift) & 0x0000001F))
#define SHIFT_RIGHT(registerNumber,shift)                                               (0xa0000000 | ((registerNumber) << 24) | ((unsigned long)(shift) & 0x0000001F))
#define SHIFT_RIGHT_FROM_REGISTER(destinationRegister,shiftRegister)                    (0xa0800000 | ((destinationRegister) << 24) | ((shiftRegister) << 20))
#define MASK_REGISTER(registerNumber,bytesToMask,maskPattern)                           (0x90000000 | ((registerNumber) << 24) | ((bytesToMask) << 20) | ((unsigned long)(maskPattern) & 0x000000FF))///to fix with other definition
#define ADD_REGISTER(destinationRegister,registerToAdd)                                 (0xc8000000 | ((destinationRegister) << 24) | ((registerToAdd) << 20))
#define ADD_REGISTER_AND_IMMEDIATE(destinationRegister,registerToAdd,immediateValue)    (0xc8800000 | ((destinationRegister) << 24) | ((registerToAdd) << 20)|((unsigned long)(immediateValue) & 0x00000FFF))
#define COPY(destinationRegister,sourceRegister)                                        (0xc0000000 | ((destinationRegister) << 24) | ((sourceRegister) << 20))


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef enum
{
	DELIA_INSTRUCTION_RECIPE_0_ENABLE_PHY = 0,
#ifdef DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_RECIPE_0_LOAD_R1_WITH_INTTEURPT_VALUE_TO_SENDER_DUMMY,
#endif //DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_RECIPE_0_LOAD_R1_WITH_INTTEURPT_VALUE_TO_SENDER,
	DELIA_INSTRUCTION_RECIPE_0_CREATE_INTERRUPT_TO_SENDER,
	DELIA_INSTRUCTION_RECIPE_0_LOAD_R0_WITH_DELIA_DESCRIPTOR,
	DELIA_INSTRUCTION_RECIPE_0_WAIT_FOR_INPUT_TO_BE_READY,
	DELIA_INSTRUCTION_RECIPE_0_SKIP_IF_ALL_TCRS_READY,
	DELIA_INSTRUCTION_RECIPE_0_JUMP_TO_SEND_TCRS_FROM_DELIA_DESC,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR0_FROM_HOB,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR1_FROM_HOB,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR2_FROM_HOB,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR3_FROM_HOB,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR4_FROM_HOB,
	DELIA_INSTRUCTION_RECIPE_0_WAIT_FOR_WORD5_TO_WORD6_TO_BE_READY,
	DELIA_INSTRUCTION_RECIPE_0_JUMP_TO_LOAD_R1_WITH_GENERAL_INFO,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR0,
	DELIA_INSTRUCTION_RECIPE_0_WAIT_FOR_TCR1_TO_WORD6_TO_BE_READY,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR1,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR2,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR3,
	DELIA_INSTRUCTION_RECIPE_0_SEND_TCR4,
	DELIA_INSTRUCTION_RECIPE_0_CHECK_IF_LENGTH_ZERO,
	DELIA_INSTRUCTION_RECIPE_0_LENGTH_ZERO_RECIPE_END,
	DELIA_INSTRUCTION_RECIPE_0_LOAD_R1_WITH_GENERAL_INFO,
	DELIA_INSTRUCTION_RECIPE_0_SKIP_IF_BF_EXIST,	
    DELIA_INSTRUCTION_RECIPE_0_BF_NOT_EXIST_JUMP_TO_RECIPES_BRANCHING,
    DELIA_INSTRUCTION_RECIPE_0_BF_START, 
	DELIA_INSTRUCTION_RECIPE_0_BF_COPY_GENERAL_INFO_TO_R2,
	DELIA_INSTRUCTION_RECIPE_0_BF_MASK_STATION_ID,
	DELIA_INSTRUCTION_RECIPE_0_BF_LOAD_R3_WITH_BF_INDEXES_TABLE_BASE_ADDRESS,
	DELIA_INSTRUCTION_RECIPE_0_BF_CALCULATE_BF_INDEX_ENTRY_ADDRESS,
	DELIA_INSTRUCTION_RECIPE_0_BF_LOAD_R1_WITH_TIMEOUT_VALUES,
	DELIA_INSTRUCTION_RECIPE_0_BF_SET_TIMER,
	DELIA_INSTRUCTION_RECIPE_0_BF_WAIT_FOR_TIMEOUT_OR_BF_READY,
	DELIA_INSTRUCTION_RECIPE_0_BF_LOAD_R6_WITH_BF_INDEX,
	DELIA_INSTRUCTION_RECIPE_0_BF_MASK_STATION_ID_TO_MODULO_4,
	DELIA_INSTRUCTION_RECIPE_0_BF_CACULATE_SHIFT_RIGHT_TO_INDEX,
	DELIA_INSTRUCTION_RECIPE_0_BF_SHIFT_RIGHT_BF_INDEX,
	DELIA_INSTRUCTION_RECIPE_0_BF_MASK_BF_INDEX,
	DELIA_INSTRUCTION_RECIPE_0_BF_CALCULATE_BF_REPORT_OFFSET,
	DELIA_INSTRUCTION_RECIPE_0_BF_LOAD_R4_WITH_BF_REPORT_TABLE_BASE_ADDRESS,
	DELIA_INSTRUCTION_RECIPE_0_BF_CALCULATE_BF_REPORT_ADDRESS,
	DELIA_INSTRUCTION_RECIPE_0_BF_LOAD_R5_WITH_BF_REPORT_LENGTH,
	DELIA_INSTRUCTION_RECIPE_0_BF_MASK_BF_REPORT_LENGTH,
	DELIA_INSTRUCTION_RECIPE_0_BF_TRANSMIT_BF_REPORT,
	DELIA_INSTRUCTION_RECIPE_0_RESET_CRC_AND_CHANGE_BUS_TO_DATA,
	DELIA_INSTRUCTION_RECIPE_0_SHIFT_TYPE,
	DELIA_INSTRUCTION_RECIPE_0_CALCULATE_LOOKUP_TABLE_ENTRY_OFFSET,
	DELIA_INSTRUCTION_RECIPE_0_LOAD_R2_WITH_LOOKUP_TABLE_BASE_ADDRESS,
	DELIA_INSTRUCTION_RECIPE_0_CALCULATE_RECIPE_ADDRESS,
	DELIA_INSTRUCTION_RECIPE_0_JUMP_TO_PROPER_RECIPE,
	DELIA_INSTRUCTION_RECIPE_0_LAST_COMMAND,	
} DeliaRecipe0_e;

typedef enum
{
	DELIA_INSTRUCTION_LEGACY_PACKET_FIRST_COMMAND = DELIA_INSTRUCTION_RECIPE_0_LAST_COMMAND,
	DELIA_INSTRUCTION_LEGACY_PACKET_LOAD_R2_WITH_AUTO_FILL_START = DELIA_INSTRUCTION_LEGACY_PACKET_FIRST_COMMAND,
	DELIA_INSTRUCTION_LEGACY_PACKET_START_AUTO_FILL,
	DELIA_INSTRUCTION_LEGACY_PACKET_LOAD_R1_WITH_MPDU_COUNTER,
	DELIA_INSTRUCTION_LEGACY_PACKET_STROE_MPDU_COUNTER_INTO_HOB,
	DELIA_INSTRUCTION_LEGACY_PACKET_WAIT_FOR_MPDU_TO_BE_READY,	
	DELIA_INSTRUCTION_LEGACY_PACKET_LOAD_R3_WITH_HEADER_LENGTH,
	DELIA_INSTRUCTION_LEGACY_PACKET_LOAD_R4_WITH_HEADER_ADDRESS,
	DELIA_INSTRUCTION_LEGACY_PACKET_TRANSMIT_HEADER,
	DELIA_INSTRUCTION_LEGACY_PACKET_LOAD_R5_WITH_PAYLOAD_LENGTH,
	DELIA_INSTRUCTION_LEGACY_PACKET_MASK_PAYLOAD_LENGTH,
	DELIA_INSTRUCTION_LEGACY_PACKET_LOAD_R6_WITH_PAYLOAD_ADDRESS,
	DELIA_INSTRUCTION_LEGACY_PACKET_MASK_PAYLOAD_ADDRESS,
	DELIA_INSTRUCTION_LEGACY_PACKET_TRANSMIT_PAYLOAD,
	DELIA_INSTRUCTION_LEGACY_PACKET_TRANSMIT_CRC,
	DELIA_INSTRUCTION_LEGACY_PACKET_LOAD_R2_WITH_AUTO_FILL_END,
	DELIA_INSTRUCTION_LEGACY_PACKET_END_AUTO_FILL,
	DELIA_INSTRUCTION_LEGACY_PACKET_END_RECIPE,
	DELIA_INSTRUCTION_LEGACY_PACKET_LAST_COMMAND
} DeliaRecipeLegacy_e;

typedef enum
{
	DELIA_INSTRUCTION_AGGREGATION_FIRST_COMMAND = DELIA_INSTRUCTION_LEGACY_PACKET_LAST_COMMAND,
	DELIA_INSTRUCTION_AGGREGATION_LOAD_R3_WITH_HEADER_LENGTH = DELIA_INSTRUCTION_AGGREGATION_FIRST_COMMAND,
	DELIA_INSTRUCTION_AGGREGATION_COPY_R3_TO_R2_SAVE_START_DELIMITERS_COUNT,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_START_DELIMITERS_SHIFT_RIGHT,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_START_DELIMITERS_SHIFT_LEFT,
	DELIA_INSTRUCTION_AGGREGATION_TRANSMIT_START_DELIMITERS,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_FIRST_MPDU_DESCRIPTOR_OFFSET,
	DELIA_INSTRUCTION_AGGREGATION_LOAD_MPDU_COUNTER_R1_WITH_ZERO ,
	DELIA_INSTRUCTION_AGGREGATION_START_OF_LOOP, /* loop starts here */
	DELIA_INSTRUCTION_AGGREGATION_LOAD_R2_WITH_AUTO_FILL_START = DELIA_INSTRUCTION_AGGREGATION_START_OF_LOOP,
	DELIA_INSTRUCTION_AGGREGATION_START_AUTO_FILL,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_MPDU_DESCRIPTOR_ADDRESS,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_MPDU_COUNTER ,
	DELIA_INSTRUCTION_AGGREGATION_STROE_MPDU_COUNTER_INTO_HOB,
	DELIA_INSTRUCTION_AGGREGATION_WAIT_FOR_MPDU_TO_BE_READY,
	DELIA_INSTRUCTION_AGGREGATION_LOAD_R5_WITH_PAYLOAD_LENGTH_AND_ZLD,
	DELIA_INSTRUCTION_AGGREGATION_COPY_R5_TO_R2_SAVE_ZLD_COUNT,
	DELIA_INSTRUCTION_AGGREGATION_MASK_PAYLOAD_LENGTH,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_LENGTH_HEADER_AND_CRC,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_TOTAL_LENGTH,
	DELIA_INSTRUCTION_AGGREGATION_STORE_TOTAL_LENGTH_TO_HOB,
	DELIA_INSTRUCTION_AGGREGATION_TRANSMIT_DELIMITER,
	DELIA_INSTRUCTION_AGGREGATION_RESET_CRC,
	DELIA_INSTRUCTION_AGGREGATION_LOAD_R4_WITH_HEADER_ADDRESS,
	DELIA_INSTRUCTION_AGGREGATION_TRANSMIT_HEADER,
	DELIA_INSTRUCTION_AGGREGATION_LOAD_R6_WITH_PAYLOAD_ADDRESS,
	DELIA_INSTRUCTION_AGGREGATION_MASK_PAYLOAD_ADDRESS,
	DELIA_INSTRUCTION_AGGREGATION_TRANSMIT_PAYLAOD,
	DELIA_INSTRUCTION_AGGREGATION_TRANSMIT_CRC,
	DELIA_INSTRUCTION_AGGREGATION_LOAD_R2_WITH_AUTO_FILL_END,
	DELIA_INSTRUCTION_AGGREGATION_END_AUTO_FILL,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_ZLD_SHIFT_RIGHT,
	DELIA_INSTRUCTION_AGGREGATION_CALCULATE_ZLD_SHIFT_LEFT,
	DELIA_INSTRUCTION_AGGREGATION_TRANSMIT_ZLD,
	DELIA_INSTRUCTION_AGGREGATION_CHECK_IF_LAST,
	DELIA_INSTRUCTION_AGGREGATION_JUMP_TO_START_OF_LOOP, /* loop ends here */
	DELIA_INSTRUCTION_AGGREGATION_END_OF_LOOP,
	DELIA_INSTRUCTION_AGGREGATION_END_RECIPE = DELIA_INSTRUCTION_AGGREGATION_END_OF_LOOP,
	DELIA_INSTRUCTION_AGGREGATION_LAST_COMMAND	
} DeliaRecipeAggregation_e;

typedef enum
{
	DELIA_INSTRUCTION_BEACON_FIRST_COMMAND = DELIA_INSTRUCTION_AGGREGATION_LAST_COMMAND,
	DELIA_INSTRUCTION_BEACON_LOAD_R2_WITH_AUTO_FILL_START = DELIA_INSTRUCTION_BEACON_FIRST_COMMAND,
	DELIA_INSTRUCTION_BEACON_START_AUTO_FILL,
	DELIA_INSTRUCTION_BEACON_CALCULATE_FIRST_ELEMENT_DESCRIPTOR_OFFSET,
	DELIA_INSTRUCTION_BEACON_CALCULATE_COUNTER ,
	DELIA_INSTRUCTION_BEACON_STROE_MPDU_COUNTER_INTO_HOB,
	DELIA_INSTRUCTION_BEACON_WAIT_FOR_BEACON_TO_BE_READY,
	DELIA_INSTRUCTION_BEACON_START_OF_LOOP,
	DELIA_INSTRUCTION_BEACON_CALCULATE_ELEMENT_DESCRIPTOR_ADDRESS = DELIA_INSTRUCTION_BEACON_START_OF_LOOP,
	DELIA_INSTRUCTION_BEACON_LOAD_R5_WITH_ELEMENT_LENGTH,
	DELIA_INSTRUCTION_BEACON_MASK_ELEMENT_LENGTH,
	DELIA_INSTRUCTION_BEACON_SKIP_IF_REGULAR_ELEMENT,
	DELIA_INSTRUCTION_BEACON_JUMP_TO_SPECIAL_ELEMENT,
	DELIA_INSTRUCTION_BEACON_LOAD_R6_WITH_ELEMENT_ADDRESS,
	DELIA_INSTRUCTION_BEACON_TRANSMIT_ELEMENT,
	DELIA_INSTRUCTION_BEACON_REGULAR_ELEMENT_JUMP_TO_CHECK_IF_LAST,
	DELIA_INSTRUCTION_BEACON_SKIP_IF_TIMESTAMP_ELEMENT,
	DELIA_INSTRUCTION_BEACON_JUMP_TO_TIM_ELEMENT,
	DELIA_INSTRUCTION_BEACON_LOAD_R4_WITH_VAP_INDEX,
	DELIA_INSTRUCTION_BEACON_STORE_VAP_INDEX_INTO_HOB,
	DELIA_INSTRUCTION_BEACON_TRANSMIT_TSF_ELEMENT,
	DELIA_INSTRUCTION_BEACON_TSF_ELEMENT_JUMP_TO_CHECK_IF_LAST,
	DELIA_INSTRUCTION_BEACON_TRANSMIT_CONSTANT_BYTES_OF_TIM_ELEMENT,
	DELIA_INSTRUCTION_BEACON_LOAD_R2_WITH_TIM_BITMAP_PARAMETERS,
	DELIA_INSTRUCTION_BEACON_COPY_R2_TO_R3_TO_SAVE_OFFSET,
	DELIA_INSTRUCTION_BEACON_MASK_BITMAP_LENGTH,
	DELIA_INSTRUCTION_BEACON_SHIFT_BITMAP_OFFSET,
	DELIA_INSTRUCTION_BEACON_MASK_BITMAP_OFFSET,
	DELIA_INSTRUCTION_BEACON_ADD_BASE_ADDRESS_TO_BITMAP_OFFSET,
	DELIA_INSTRUCTION_BEACON_TRANSMIT_TIM_ELEMENT,
	DELIA_INSTRUCTION_BEACON_CHECK_IF_LAST,
	DELIA_INSTRUCTION_BEACON_JUMP_TO_STRAT_OF_LOOP,
	DELIA_INSTRUCTION_BEACON_END_OF_LOOP,
	DELIA_INSTRUCTION_BEACON_TRANSMIT_CRC = DELIA_INSTRUCTION_BEACON_END_OF_LOOP,
	DELIA_INSTRUCTION_BEACON_LOAD_R2_WITH_AUTO_FILL_END,
	DELIA_INSTRUCTION_BEACON_END_AUTO_FILL,
	DELIA_INSTRUCTION_BEACON_END_RECIPE,
	DELIA_INSTRUCTION_BEACON_LAST_COMMAND
} DeliaRecipebeacon_e;


typedef enum
{
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_FIRST_COMMAND = DELIA_INSTRUCTION_BEACON_LAST_COMMAND,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_LOAD_R1_WITH_MPDU_COUNTER = DELIA_INSTRUCTION_LEGACY_VHT_PACKET_FIRST_COMMAND,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_STROE_MPDU_COUNTER_INTO_HOB,
	DELIA_INSTRUCTION_LEGACY_VHT_WAIT_FOR_MPDU_TO_BE_READY,
	DELIA_INSTRUCTION_LEGACY_VHT_LOAD_R2_WITH_AUTO_FILL_START,
	DELIA_INSTRUCTION_LEGACY_VHT_START_AUTO_FILL,
	DELIA_INSTRUCTION_LEGACY_VHT_LOAD_R3_WITH_HEADER_LENGTH,
	DELIA_INSTRUCTION_LEGACY_VHT_CALCULATE_LENGTH_HEADER_AND_CRC,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_LOAD_R5_WITH_PAYLOAD_LENGTH,
	DELIA_INSTRUCTION_LEGACY_VHT_CALCULATE_TOTAL_LENGTH,
	DELIA_INSTRUCTION_LEGACY_VHT_STORE_TOTAL_LENGTH_TO_HOB,
	DELIA_INSTRUCTION_LEGACY_VHT_TRANSMIT_DELIMITER,
	DELIA_INSTRUCTION_LEGACY_VHT_RESET_CRC,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_LOAD_R4_WITH_HEADER_ADDRESS,
	DELIA_INSTRUCTION_LEGACY_VHT_TRANSMIT_HEADER,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_LOAD_R6_WITH_PAYLOAD_ADDRESS,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_MASK_PAYLOAD_ADDRESS,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_TRANSMIT_PAYLOAD,
	DELIA_INSTRUCTION_LEGACY_VHT_PACKET_TRANSMIT_CRC,
	DELIA_INSTRUCTION_LEGACY_VHT_LOAD_R2_WITH_AUTO_FILL_END,
	DELIA_INSTRUCTION_LEGACY_VHT_END_AUTO_FILL,
	DELIA_INSTRUCTION_LEGACY_VHTN_END_RECIPE,	
	DELIA_INSTRUCTION_LEGACY_VHT_LAST_COMMAND	
} DeliaRecipeLegacyVht_e;


typedef enum
{
	DELIA_INSTRUCTION_ACK_FIRST_COMMAND = 0,
	DELIA_INSTRUCTION_ACK_START_AUTO_FRAME = DELIA_INSTRUCTION_ACK_FIRST_COMMAND,
#ifdef DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_ACK_LOAD_TCR0_ADDR_DUMMY,
#endif //DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_ACK_LOAD_TCR0_ADDR,
	DELIA_INSTRUCTION_ACK_LOAD_TCR2_ADDR,
	DELIA_INSTRUCTION_ACK_SEND_TCR0,
	DELIA_INSTRUCTION_ACK_SEND_TCR1,
	DELIA_INSTRUCTION_ACK_SEND_TCR2,
	DELIA_INSTRUCTION_ACK_SEND_TCR3,
	DELIA_INSTRUCTION_ACK_SEND_TCR4,
	DELIA_INSTRUCTION_ACK_START_DATA,
	DELIA_INSTRUCTION_ACK_TRANSMIT_CONTROL,
	//DELIA_INSTRUCTION_ACK_TRANSMIT_PM,//SHOULD BE CHECKED IF TO REMOVE
	DELIA_INSTRUCTION_ACK_WAIT_FOR_DURATION,
	DELIA_INSTRUCTION_ACK_TRANSMIT_DURATION,
	DELIA_INSTRUCTION_ACK_TRANSMIT_RECIEVER_ADDRESS,
	DELIA_INSTRUCTION_ACK_TRANSMIT_CRC,
	DELIA_INSTRUCTION_ACK_END_RECIPE,
	DELIA_INSTRUCTION_ACK_LAST_COMMAND
} DeliaRecipeAck_e;

typedef enum
{
	DELIA_INSTRUCTION_BA_FIRST_COMMAND = 0,
	DELIA_INSTRUCTION_BA_START_AUTO_FRAME = DELIA_INSTRUCTION_BA_FIRST_COMMAND,
#ifdef DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_BA_LOAD_TCR0_ADDR_DUMMY,
#endif //DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_BA_LOAD_TCR0_ADDR,
	DELIA_INSTRUCTION_BA_LOAD_TCR2_ADDR,
	DELIA_INSTRUCTION_BA_SEND_TCR0,
	DELIA_INSTRUCTION_BA_SEND_TCR1,
	DELIA_INSTRUCTION_BA_SEND_TCR2,
	DELIA_INSTRUCTION_BA_SEND_TCR3,
	DELIA_INSTRUCTION_BA_SEND_TCR4,
	DELIA_INSTRUCTION_BA_START_DATA,
	DELIA_INSTRUCTION_BA_TRANSMIT_CONTROL,
	//DELIA_INSTRUCTION_BA_TRANSMIT_PM,//SHOULD BE CHECKED IF TO REMOVE
	DELIA_INSTRUCTION_BA_WAIT_FOR_DURATION,
	DELIA_INSTRUCTION_BA_TRANSMIT_DURATION,
	DELIA_INSTRUCTION_BA_TRANSMIT_RECIEVER_ADDRESS,
	DELIA_INSTRUCTION_BA_TRANSMIT_TRANSMITTER_ADDRESS,
	DELIA_INSTRUCTION_BA_TRANSMIT_BA_CONTROL_AND_BITMAP,
	DELIA_INSTRUCTION_BA_TRANSMIT_CRC,
	DELIA_INSTRUCTION_BA_END_RECIPE,
	DELIA_INSTRUCTION_BA_LAST_COMMAND
} DeliaRecipeBa_e;

typedef enum
{
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_FIRST_COMMAND = 0,

#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND

	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_TX_ENABLE = DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_FIRST_COMMAND,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_SKIP_ON_HOB_IF_SIGNALING_TA,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_NOT_SIGNALING_JUMP_TO_ORIGINAL_CODE,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_LOAD_CB_POINTER,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_CALC_PHY_METRICS_ADDRESS,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_CALC_PHY_MODE_WORD_ADDRESS,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_SKIP_IF_11_A_G_BIT_6_FALSE,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_NOT_11_A_G__BIT_6_JUMP_TO_ORIGINAL_CODE,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_SKIP_IF_11_A_G_BIT_7_FALSE,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_NOT_11_A_G__BIT_7_JUMP_TO_ORIGINAL_CODE,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_TRANSMIT_FROM_CYCLIC_BUF_RESERVED_WORD,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_START_AUTO_FRAME,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_JUMP_TO_CONTINUE_TRANSMIT_THE_REST_TCRS,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_START_AUTO_FRAME,
#else
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_START_AUTO_FRAME = DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_FIRST_COMMAND,
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND
#ifdef DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_LOAD_TCR0_ADDR_DUMMY,
#endif //DELIA_LOAD_IMMEDIATE_AFTER_RECOVERY_WORKAROUND
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_LOAD_TCR0_ADDR,	
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_SEND_TCR0,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_SEND_TCR1,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_LOAD_TCR2_ADDR,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_SEND_TCR2,
#ifdef DYNAMIC_RTS_ISSUE_WORKAROUND
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_INITIATE_LOOP_COUNTER,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_DO_NOPS,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_INCREMENT_LOOP_COUNTER,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_SKIP_IF_COUNTER_LIMIT_REACHED,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_RTS_WORKAROUND_JUMP_TO_START_OF_THE_LOOP,
#endif //DYNAMIC_RTS_ISSUE_WORKAROUND
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_SEND_TCR3,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_SEND_TCR4,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_START_DATA,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_TRANSMIT_CONTROL,
	//DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_TRANSMIT_PM,//SHOULD BE CHECKED IF TO REMOVE
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_WAIT_FOR_DURATION,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_TRANSMIT_DURATION,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_TRANSMIT_RECIEVER_ADDRESS,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_TRANSMIT_CRC,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_END_RECIPE,
	DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_LAST_COMMAND
} DeliaRecipeCtsAutoResponse_e;

typedef enum
{
	DELIA_INSTRUCTION_BF_REPORT_FIRST_COMMAND = 0,	
	DELIA_INSTRUCTION_BF_REPORT_START_RECIPE = DELIA_INSTRUCTION_BF_REPORT_FIRST_COMMAND,
	DELIA_INSTRUCTION_BF_REPORT_SEND_TCR_0_3,
	DELIA_INSTRUCTION_BF_REPORT_SKIP_IF_MATRICES_EXIST,
	DELIA_INSTRUCTION_BF_MATRICES_NOT_EXIST_JUMP_TO_WAIT_FOR_LENGHT,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R2_WITH_STATION_INDEX,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R3_WITH_BF_INDEXES_TABLE_BASE_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_CALCULATE_BF_INDEX_ENTRY_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_SHIFT_RIGHT_R3_FOR_WORD_ALLIGNED_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_SHIFT_LEFT_R3_TO_RETURN_TO_BYTES_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R6_WITH_TIMEOUT_VALUES,
	DELIA_INSTRUCTION_BF_REPORT_SET_TIMER,
	DELIA_INSTRUCTION_BF_REPORT_WAIT_FOR_TIMEOUT_OR_BF_READY,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R6_WITH_BF_INDEX,
	DELIA_INSTRUCTION_BF_REPORT_SHIFT_LEFT_R2_TO_CALCULATE_MODULO_4,
	DELIA_INSTRUCTION_BF_REPORT_SHIFT_RIGHT_R2_TO_CALCULATE_SHIFT_FOR_INDEX,
	DELIA_INSTRUCTION_BF_REPORT_SHIFT_RIGHT_BF_INDEX,
	DELIA_INSTRUCTION_BF_REPORT_MASK_BF_INDEX,
	DELIA_INSTRUCTION_BF_REPORT_CALCULATE_BF_REPORT_OFFSET,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R4_WITH_BF_REPORT_TABLE_BASE_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_CALCULATE_BF_REPORT_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R5_WITH_BF_REPORT_LENGTH,
	DELIA_INSTRUCTION_BF_REPORT_MASK_BF_REPORT_LENGTH,
	DELIA_INSTRUCTION_BF_REPORT_WAIT_FOR_LENGTH_OR_ERROR,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_TCR4,
	DELIA_INSTRUCTION_BF_REPORT_SET_BUS_TO_BF,
	DELIA_INSTRUCTION_BF_REPORT_SKIP_IF_MATRICES_DONT_EXIST,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_BF_MATRICES,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R6_WITH_REPORT_FRAME_LENGTH,
	DELIA_INSTRUCTION_BF_REPORT_STORE_FRAME_LENGTH_TO_HOB,
	DELIA_INSTRUCTION_BF_REPORT_SKIP_IF_NOT_VHT,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_VHT_DELIMITER,	
	DELIA_INSTRUCTION_BF_REPORT_START_DATA,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_CONTROL,
	DELIA_INSTRUCTION_BF_REPORT_WAIT_FOR_DURATION,
	DELIA_INSTRUCTION_BF_REPORT_SKIP_IF_NOT_AFTER_NDP,
	DELIA_INSTRUCTION_BF_REPORT_JUMP_TO_TRANSMIT_DURATION_AFTER_NDP,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_DURATION_AFTER_BF_POLL,
	DELIA_INSTRUCTION_BF_REPORT_JUMP_TO_TRANSMIT_RECEIVER_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_DURATION_AFTER_NDP,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_RECIEVER_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_TRANSMITTER_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R6_WITH_NDPA_VAP_INDEX,
	DELIA_INSTRUCTION_BF_REPORT_STORE_VAP_INDEX_INTO_HOB,
	DELIA_INSTRUCTION_BF_REPORT_SKIP_CHOOSE_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_JUMP_TO_TRANSMIT_ADDRESS_1_AS_ADDRESS_3,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_ADDRESS_2_AS_ADDRESS_3,
	DELIA_INSTRUCTION_BF_REPORT_JUMP_TO_LOAD_R3_WITH_VAP_DATABASE_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_ADDRESS_1_AS_ADDRESS_3,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R3_WITH_VAP_DATABASE_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_LOAD_R5_WITH_SEQUENCE_NUMBER,
	DELIA_INSTRUCTION_BF_REPORT_SHIFT_SEQUENCE_NUMBER_WITH_FRAGEMENT_BITS,
	DELIA_INSTRUCTION_BF_REPORT_TRANSMIT_SEQUENCE_NUMBER,
	DELIA_INSTRUCTION_BF_REPORT_INCREMENT_SEQUENCE_NUMBER,
	DELIA_INSTRUCTION_BF_REPORT_WRAP_AROUND_SEQUENCE_NUMBER,
	DELIA_INSTRUCTION_BF_REPORT_SHIFT_RIGHT_SEQUENCE_NUMBER,
	DELIA_INSTRUCTION_BF_REPORT_SAVE_SEQUENCE_NUMBER,
	DELIA_INSTRUCTION_BF_REPORT_SKIP_IF_VHT,
	DELIA_INSTRUCTION_BF_REPORT_JUMP_TO_HT_FRAME,
	DELIA_INSTRUCTION_BF_REPORT_VHT_TRANSMIT_ACTION_CATEGORY_AND_VALUE,
	DELIA_INSTRUCTION_BF_REPORT_VHT_WAIT_FOR_REPORT_READY_OR_ERROR,
	DELIA_INSTRUCTION_BF_REPORT_VHT_SKIP_IF_ERROR,
    DELIA_INSTRUCTION_BF_REPORT_VHT_JUMP_TO_REGULAR_MIMO,
    DELIA_INSTRUCTION_BF_REPORT_VHT_TRANSMIT_EMPTY_MIMO,
    DELIA_INSTRUCTION_BF_REPORT_VHT_JUMP_TO_VHT_REPORT_PAYLOAD,
	DELIA_INSTRUCTION_BF_REPORT_VHT_TRANSMIT_FIRST_PART_OF_REGULAR_MIMO,
	DELIA_INSTRUCTION_BF_REPORT_VHT_TRANSMIT_SECOND_PART_OF_REGULAR_MIMO,
	DELIA_INSTRUCTION_BF_REPORT_VHT_LOAD_R1_WITH_NUMBER_OF_COLUMNS,
	DELIA_INSTRUCTION_BF_REPORT_VHT_TRANSMIT_SNR,
	DELIA_INSTRUCTION_BF_REPORT_VHT_LOAD_R4_WITH_BEAMFORMEE_TX_BUFFER_BASE_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_VHT_ADD_OFFSET_TO_R4,
	DELIA_INSTRUCTION_BF_REPORT_VHT_LOAD_R2_WITH_BEAMFORMEE_MATRICES_FINAL_SIZE,
	DELIA_INSTRUCTION_BF_REPORT_VHT_TRANSMIT_BEAMFORMEE_MATRICES,
	DELIA_INSTRUCTION_BF_REPORT_VHT_CRC,
	DELIA_INSTRUCTION_BF_REPORT_VHT_END_OF_RECIPE,
	DELIA_INSTRUCTION_BF_REPORT_HT_TRANSMIT_ACTION_CATEGORY_AND_VALUE,
	DELIA_INSTRUCTION_BF_REPORT_HT_TRANSMIT_MIMO,
	DELIA_INSTRUCTION_BF_REPORT_HT_TRANSMIT_LOWER_TSF_BYTES,
	DELIA_INSTRUCTION_BF_REPORT_HT_LOAD_R1_WITH_NUMBER_OF_COLUMNS,
	DELIA_INSTRUCTION_BF_REPORT_HT_TRANSMIT_SNR,
	DELIA_INSTRUCTION_BF_REPORT_HT_LOAD_R4_WITH_BEAMFORMEE_TX_BUFFER_BASE_ADDRESS,
	DELIA_INSTRUCTION_BF_REPORT_HT_WAIT_FOR_REPORT_READY_OR_ERROR,
	DELIA_INSTRUCTION_BF_REPORT_HT_LOAD_R2_WITH_BEAMFORMEE_MATRICES_FINAL_SIZE,
	DELIA_INSTRUCTION_BF_REPORT_HT_TRANSMIT_BEAMFORMEE_MATRICES,
	DELIA_INSTRUCTION_BF_REPORT_HT_SKIP_IF_NOT_ERROR,
	DELIA_INSTRUCTION_BF_REPORT_HT_RESET_CRC,
	DELIA_INSTRUCTION_BF_REPORT_HT_TRANSMIT_CRC,
	DELIA_INSTRUCTION_BF_REPORT_HT_END_OF_RECIPE,
	DELIA_INSTRUCTION_BF_REPORT_LAST_COMMAND
} DeliaRecipeBfReport_e;





#endif /*DELIA_RECIPES_H_ */

