/***************************************************************
 File:	Dut_Api.h
 Module:	Dut
 Purpose: 	A short description of the class purpose.
 Description: A detailed description of the class, its attributes and whatever 
	             information the user & maintainer might find 
 	             valuable.
***************************************************************/
#ifndef DUT_API_H
#define DUT_API_H
//---------------------------------------------------------------------------------
//						Includes									
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "mhi_dut.h"
#include "mhi_umi.h"
#include "shram_man_msgs.h"
#include "PacketDescriptor.h"

//---------------------------------------------------------------------------------
//						Defines									
//---------------------------------------------------------------------------------
//#define DUT_DEBUG
//#define SNIFFER_DEBUG
//#define BEEROCK_DEBUG

#define MAX_NUM_OF_POWER_VECTOR_INDEX 64

typedef struct measuredVoltagePowerVector_tag
{
	uint16 measuredVector[DUT_4ANT_ARRAY][MAX_NUM_OF_POWER_VECTOR_INDEX];
}measuredVoltagePowerVector_t;

//---------------------------------------------------------------------------------
//						Public Variables									
//---------------------------------------------------------------------------------

extern measuredVoltagePowerVector_t *measuredVoltagePowerVector;
extern uint32 isTxPowerVectorOn ;
extern uint32 PVpowerToTransmitIndex;
extern uint8 isDataLongTransmitted;

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef enum dutBand
{
	DUT_BAND_5000MHZ = 0,
	DUT_BAND_2400MHZ = 1,
	DUT_BAND_BOTH	 = 2,
	DUT_BAND_INVALID = 0xff
}dutBand_e;

typedef enum dutMode
{
	DUT_MODE_OFF = 0,
	DUT_MODE_ON
}dutMode_e;

typedef enum dutTxStates
{
	DUT_TX_STATE_IDLE,
//	DUT_TX_STATE_PROCESSING_TRAFFIC_PARAMS,
	DUT_TX_STATE_TRANSMITTING,
//	DUT_TX_STATE_TRANSMITTED,
	DUT_TX_STATE_STOPPING,
	DUT_TX_STATE_LAST
}dutTxStates_e;
typedef enum durOperationModeUpdateMsgType
{
	ADD_VAP,
	REMOVE_VAP
}dutOperationModeUpdateMsgType_e;

typedef struct dutHeaderReturn
{
	K_MSG_TYPE retMsg;
	K_TASKID retTask;
}dutHeaderReturn_t;

typedef struct dutMsgBtwnCores
{
	K_MSG_TYPE retMsg;
	K_TASKID retTask;
	uint8  toReleasePool;
	uint8  reserved;
	uint32 *pD;
}dutMsgBtwnCores_t;

typedef struct dutOperationModeUdateMsgParams
{
	UmiOperationMode_e	operationMode;
	dutOperationModeUpdateMsgType_e msgType;
	K_MSG_TYPE retMsg;
	K_TASKID retTask;	
}dutOperationModeUdateMsgParams_t;

typedef struct dutTransmittPacketReqParams
{
	uint32 length;
	bool allocationStatus;
	K_TASKID retTask;
	K_MSG_TYPE retMsg;
}dutTransmittPacketReqParams_t;

typedef struct dutRxCountParams
{
	K_TASKID retTask;
	K_MSG_TYPE retMsg;
	uint32 rxCount;	
}dutRxCountParams_t;

//---------------------------------------------------------------------------------
//						Macros									
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Data Type Definition									
//---------------------------------------------------------------------------------
typedef struct trafficParams
{
	dutTxStates_e trafficState;
	uint8 	isTxEndless;
	uint16	packetsProcessed;
	uint16	packetsTransmitted;
	uint16	numOfPacketToTransmit;
	uint8	cpMode;
	PhyMode_e phyMode;
	bool 	modifyParamsOnTheFly;
	uint8 	powerVectorWord;
	uint32	packetLength;
	uint16 	txRate;
	bool 	txPacketIsOngoing;
} trafficParams_t;

typedef struct dutModifiedPacketParams_tag
{
	uint16 currentPacketLength;
	uint16 newPacketLength;
}dutModifiedPacketParams_t;

typedef struct dutHwSpacingParams_tag
{
	uint32 		spacingUsec;
	uint8 		ifsn;
//	uint8		slotTimerValue;
	uint8		vapIndex;
	uint8 		ac;
}dutHwSpacingParams_t;

typedef struct dutDB_Tag
{
	dutMessagesId_e		savedDutMsgId;
	K_MSG 				*savedDutMsg_p;
#ifdef DUT_DEBUG
	K_MSG				*savedDutMsgDebug_p;
#endif
	UmiOperationMode_e	operationMode;
	uint8 				vapIndex;
	trafficParams_t 	m_DutTrafficParams;
	bool 				isChannelSet;
	// calibration params
	uint32				onlineCalibrationCount;
	dutCalibrationType_e calibrationReq; // bit mask according to dutCalibrationType_e
	uint32 				calibrationResults;
	bool				calibrationInProcess;
	// mac filtering params
	uint32 				rxCount;
	// tx power feedbalck params
	bool	  			TxPowerFeedbackRequested;
	uint32 				failedTxPowerFeedbackReadAttempts;
	dutHwSpacingParams_t dutHwSpacingParams;
	bool				sendCfm;
	uint8 				vapCount;
	uint8 				spaceless;
	dutRiscMode_e 		riscMode;
	AntennaBitmaps_e	txAntEnableMask;
	AntennaBitmaps_e	rxAntEnableMask;
}dutDB_t;

#ifdef SNIFFER_DEBUG
typedef struct _AAA_DebugTrace_SnifferArray_t
{   
	uint16 eventId;
	uint32 bdIndex;
	uint32 tsfLow;	
} AAA_DebugTrace_SnifferArray_t;

typedef enum _AAA_DebugTrace_SnifferArray_Events_e
{
	SNIFFER_EVENT_PRE_DMA,
	SNIFFER_EVENT_DMA_DONE_BEFORE_PUSSHING_TO_PP_QUEUE,
	SNIFFER_EVENT_DMA_DONE_AFTER_PUSSHING_TO_PP_QUEUE,
	SNIFFER_EVENT_RX_PP_NEW_RD_LIST_BEFORE_PUSSHING_TO_PP_FW_LIST,
	SNIFFER_EVENT_RX_PP_FORWARD_RDS_START,
	SNIFFER_EVENT_RX_PP_FORWARD_RDS_FINISH,
	SNIFFER_EVENT_HOST_IF_RINGS_CONVERT_DATA_RDS_TO_HDS_BEFORE_PUTTING_ON_RD_LIST,
	SNIFFER_EVENT_HOST_IF_RINGS_CONVERT_DATA_RDS_TO_HDS_AFTER_PUTTING_ON_RD_LIST,		
} AAA_DebugTrace_SnifferArray_Events_e;
#endif //SNIFFER_DEBUG

//---------------------------------------------------------------------------------
//						Public Function Declaration									
//---------------------------------------------------------------------------------
/*********************************************************************************
Method:			Dut_Init
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void Dut_Init(void);
/*********************************************************************************
Method:			DUT_InitParams
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_InitParams(void);

/*********************************************************************************
Method:			Dut_Task
Description:  
Parameter:    	K_MSG * psMsg
Returns:      	void
Remarks:		None
*********************************************************************************/
void Dut_Task(IN K_MSG *psMsg);

void dutDispatcher(IN K_MSG *psMsg);

/*********************************************************************************
Method: 		Dut_updateCalibResults
Description:  
Parameter:		uint32 statusResults
Returns:		void
Remarks:		None
*********************************************************************************/
void Dut_updateCalibResults(uint32 statusResults);

/*********************************************************************************
Method: 		Dut_UpdateCalibrationCounter
Description:  
Parameter:		void
Returns:		void
Remarks:		None
*********************************************************************************/
void Dut_UpdateCalibrationCounter(void);

/*********************************************************************************
Method: 		DUT_HandleCalibDone
Description:  
Parameter:		void
Returns:		void
Remarks:		None
*********************************************************************************/
void DUT_HandleCalibDone(void);

/*********************************************************************************

Method: 		DUT_setRxCount
Description:  
Parameter:		dutRxCount *
Returns:		void
Remarks:		None
*********************************************************************************/
void DUT_setRxCount(IN dutRxCount *rxCount_p);


/*********************************************************************************
Method: 		DUT_getRxCountReq
Description:  
Parameter:		dutRxCount *
Returns:		void
Remarks:		None
*********************************************************************************/
void DUT_getRxCountReq(void);
/*********************************************************************************
Method: 		DUT_getRxCountCfm
Description:  
Parameter:		dutRxCount *
Returns:		void
Remarks:		None
*********************************************************************************/

void DUT_getRxCountCfm(K_MSG* pDutRxCountMsgCfm);

/*********************************************************************************
Method:			DUT_getPhyRateCfm
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_getRateCfm(K_MSG* pLaGetPhyRate);

/*********************************************************************************
Method:			DUT_ModifyParamProcess
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_ModifyParamProcess(void);

/*********************************************************************************
Method:			DUT_FinalizeModifyParamProcess
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void DUT_FinalizeModifyParamProcess(uint32 status);

/*********************************************************************************
Method:			dutSetIfsValue
Description:  
Parameter:    	dutIfsParams_t *ifsParams_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutSetIfsValue(dutIfsParams_t *ifsParams_p);

/*********************************************************************************
Method:			dutHwAccessReadTxPowerFeedBack
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/

void dutHwAccessReadTxPowerFeedBack(uint8 forceConfirm);

/*********************************************************************************
Method:			Dut_getDB
Description:  
Parameter:    	void
Returns:      	dutDB_t *
Remarks:		None
*********************************************************************************/
dutDB_t *Dut_getDB(void);

/*********************************************************************************
Method:			DUT_stopTxCondition
Description:  
Parameter:    	void
Returns:      	bool
Remarks:		None
*********************************************************************************/
bool DUT_stopTxCondition(void);

/*********************************************************************************
Method:			DUT_CfmToHost
Description:  
Parameter:    	dutStatus_e status
Returns:      	none
Remarks:		None
*********************************************************************************/
void DUT_CfmToHost(dutStatus_e status);

/*********************************************************************************
Method:			dutTxSetState
Description:  
Parameter:    	dutTxStates_e dutTxNewState
Returns:      	none
Remarks:		None
*********************************************************************************/
void dutTxSetState(dutTxStates_e dutTxNewState);

/*********************************************************************************
Method:			dutTxGetState
Description:  
Parameter:    	nonr
Returns:      	dutTxStates_e
Remarks:		None
*********************************************************************************/
dutTxStates_e dutTxGetState(void);

/*********************************************************************************
Method:			dutHandleTxActionPublicFrameCb
Description:  
Parameter:    	TxPd_t *packetDescriptor
Returns:      	none
Remarks:		None
*********************************************************************************/

void dutHandleTxActionPublicFrameCb(TxPd_t *packetDescriptor);

/*********************************************************************************
Method:			DUT_SetTxTimer
Description:  
Parameter:    	uint32 timeout
Returns:      	none
Remarks:		None
*********************************************************************************/
void DUT_SetTxTimer(uint32 timeout);

/*********************************************************************************
Method:			DUT_ResetTxTimer
Description:  
Parameter:    	None
Returns:      	none
Remarks:		None
*********************************************************************************/
void DUT_ResetTxTimer(void);
void dutHwAccessTPCtableOffset(dutPoutTableOffsetParams_t *dutPoutTableOffsetParams_p, uint8 setGet);
void dutHwAccessRxEnableAggregate (dutRxEnableAggregate_t* EnableAggregate);

#ifndef ENET_INC_ARCH_WAVE600
// when DUT will move to Lower MACs and RxH sniffer will be ready, uncomment this function
/*********************************************************************************
Method:			DUT_SnifferSetUdpHeader
Description:  
Parameter:    	UMI_ADD_STREAM_REQ_t* addStreamStructurePtr
Returns:      	none
Remarks:		None
*********************************************************************************/
void DUT_SnifferSetUdpHeader(UMI_ADD_STREAM_REQ_t* addStreamStructurePtr);

#endif // ENET_INC_ARCH_WAVE600
#ifdef SNIFFER_DEBUG
void AAA_SNIFFER_DEBUGTRACE(uint16 event, uint32 bdIndex);
#endif //SNIFFER_DEBUG


#endif //DUT_API_H
