/***************************************************************
 File:	Dut.h
 Module:	Dut
 Purpose: 	A short description of the class purpose.
 Description: A detailed description of the class, its attributes and whatever 
	             information the user & maintainer might find 
 	             valuable.
***************************************************************/
#ifndef DUT_H
#define DUT_H
//---------------------------------------------------------------------------------
//						Includes									
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "mhi_dut.h"
#include "Dut_Api.h"
#include "linkAdaptation_api.h"
#include "PhyDriver_API.h"
#include "ServicesHandler_Api.h"

//---------------------------------------------------------------------------------
//						Defines									
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Macros									
//---------------------------------------------------------------------------------
#define SET_MSG_ID_TO_CFM(x) 	(x += 1)
#define CALC_11B_ANT(x) 		((x & 1)? 0:((x & 2)? 1:((x & 4)? 2:(x & 8)? 3:1)))  //note! if mask=0 return 1  

#define IFSN_NUM_OF_BITS (4)
#define IFSN_MAX_VAL ((0x1 << IFSN_NUM_OF_BITS) - 1)
#define SLOT_TIMER_MIN_VALUE (SLOT_TIME_11A)

#define PROCESS_DUT_PRE_SERVICES_BITMAP			(1 << SERVICE_ID_PAUSE_ALL)
#define PROCESS_DUT_POST_SERVICES_BITMAP		(1 << SERVICE_ID_RESUME_ALL)

#define TONE_DIGGAIN					(256)   
#define INITIAL_TPC_INDEX				2
#define PAD_GAIN_DB						0
#define SCALE_MIN_VALUE					(-2)
#define SCALE_MAX_VALUE					2

//---------------------------------------------------------------------------------
//						Data Type Definition									
//---------------------------------------------------------------------------------
// Attributes of active traffic 




typedef struct dutMessageHeader
{
	uint16 				msgLength;
	dutStatus_e 		status; /* dutStatus_e */
	uint8 				reserved[2];
	dutMessagesId_e 	msgId;	/* dutMessagesId_e */
}dutMessageHeader_t;






//---------------------------------------------------------------------------------
//						Public Function Declaration									
//---------------------------------------------------------------------------------


/*********************************************************************************
Method:			Dut_MsgCallBackFromProcess
Description:  
Parameter:    	K_MSG *kMsg_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void Dut_MsgCallBackFromProcess(K_MSG *kMsg_p);

/*********************************************************************************
Method:			Dut_MsgCallBack
Description:  
Parameter:    	IN K_MSG * psMsg
Returns:      	void
Remarks:		None
*********************************************************************************/
void Dut_MsgCallBack(K_MSG * psMsg);

/*********************************************************************************
Method:			DutMngmnt_Sm
Description:  
Parameter:    	dutMessage_t * dutMessage
Returns:      	void
Remarks:		None
*********************************************************************************/
void DutMngmnt_Dispatcher(IN dutMessage_t *dutMessage);

///*********************************************************************************
//Method:			DutHwAccess_Dispatcher
//Description:  
//Parameter:    	IN K_MSG * psMsg
//Returns:      	void
//Remarks:		None
//*********************************************************************************/
//bool DutHwAccess_Dispatcher(dutMessage_t *dutMessage);


//---------------------------------------------------------------------------------
//						Public Function Declaration									
//---------------------------------------------------------------------------------
/*********************************************************************************
Method:			DutTx_Init
Description:  
Parameter:    	void
Returns:      	void
Remarks:		None
*********************************************************************************/
void DutTx_Init(void);

/*********************************************************************************
Method:			DutTx_Sm
Description:  
Parameter:    	dutMessage_t * psDutMsg
Returns:      	void
Remarks:		None
*********************************************************************************/
void DutTx_Dispatcher(dutMessage_t *psDutMsg);

void dutHwAccessReadMemory(OUT dutMemoryAccessParams_t *memoryAccessParams);
void dutHwAccessWriteMemory(IN dutMemoryAccessParams_t *memoryAccessParams);
void Dut_HandleAddVapReq(K_MSG *pMsg);
void Dut_HandleRemoveVapReq(K_MSG *pMsg);
void Dut_HandleSetFixedRateCfm(K_MSG *pKmsg);
void Dut_HandleTxActionPublicFrameCb(K_MSG* pMsg);

//void DUT_SetRateReq(LaFixedRateParams_t *laFixedRateParams_p);

void dutTxSendPackets(void);
void dutHwAccessReadChipVersion(OUT dutChipVersion_t *chipVersion);
void dutHwAccessReadRiscVersion(OUT PhyVersion_t *hwParams);
void dutResetBb(void);
void dutStartBb(void);
uint32 dutGetMaxSpacingAllowed(uint32 slotTimer);
void dutHwAccessEnableTxAntenna(IN dutSetAntennaParams_t *setAntennaParams);
void dutHwAccessEnableRxAntenna(IN dutSetAntennaParams_t *setAntennaParams);
//----------------------------- Digital Phy ----------------------------
void dutHwAccessSetDefaultAntenaSet(IN antSelectionParams_t *defaultAntennaSet);
#ifdef ENET_INC_ARCH_WAVE600
int8 dutHwAccessGetScale(int8 amplitude);
void dutTxStopLongPackets(void);
void dutTxSendLongPackets(dutTxParams_t *txParams_p);
#endif
void dutHwAccessTransmitTone(IN dutTxToneParams_t *toneParams);
void dutHwAccessSetSpacelessTransmission(dutTxSpacelessParams_t *dutTxSpacelessParams_p);
void dutHwAccessSetScramblerMode(IN dutScramblerParams_t *scramblerParams);
void dutHwAccessGetRssi(IN dutRssiParams_t *rssiValues);
void dutHwAccessReadPacketsCounters(IN packetCountersParams_t *packetCountersParams);
void dutHwAccessGetRxEvm(IN dutGetRxEvm_t *rxEvm_p);
//----------------------------- RFIC  ----------------------------//
void dutHwAccessGetTxPowerFeedbackReq(INOUT dutTpcFeedbackparams_t *tpcFeedbackParams_p);
void dutHwAccessGetRxGains(OUT dutRficRxGainsParams_t *rxGains);
void dutHwAccessGetXtalValue(OUT dutXtalParams_t *xtalParams);
void dutHwAccessSetXtalValue(IN dutXtalParams_t *xtalParams);
void dutHwAccessGetLnaParams(OUT dutLnaParam_t * LnaParams);
void dutHwAccessSetLnaParams(IN dutLnaParam_t * LnaParams);
void DUT_SendModifyIfsParamsReq(K_MSG *kMsg_p);
void dutReadRfGainsFromPhy(dutRficTxGainsParams_t *dutRficTxGainsParams_p);
uint32  dutGetTxPowerVectorStatus(void);
uint32  dutGetChangePowerVectorStatus(void);
uint32  dutGetTransmitPowerVectorStartingLength(void);
TxPd_t *  dutGetTransmitPowerPacketDesc(void);
void dutTxStartTransmision(IN dutTxParams_t *txParams_p);
void dutSetPowerAndLength(dutPowerAndPacketLength_t *dutPowerAndPacketLength_p);
void dutSetCalibrationMask(dutCalibrationType_e calibrationType, dutCalibrationMaskType_e maskType, uint32 mask);
void DUT_UpdateMsgWithCalibResults(void);
void dutHandleCbInTransmittingState(TxPd_t *pDesc);
void dutTransmitPacketCfm(K_MSG* pMsg);
void dutTxSendManagementPacketFromFw(TxPd_t* pDesc);
void dutTxReleaseManagementPacket(TxPd_t* pDesc);



#endif //DUT_H
