/***************************************************************
 File:			Dut.c
 Module:		Dut
 Purpose: 		
 Description:	
***************************************************************/
//---------------------------------------------------------------------------------
//						Includes									
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "stringLibApi.h"
#include "queue_utility.h"
#include "shram_man_msgs.h"
#include "init_ifmsg.h"
#include "OSAL_Api.h"
#include "mhi_dut.h"
#include "mhi_umi.h"
#include "Dut.h"
#include "Dut_Api.h"
#include "ErrorHandler_Api.h"
#include "bss_manage_task.h"
#include "SenderInterface_Api.h"
#ifndef ENET_INC_ARCH_WAVE600
// todo: when DUT will move to Lower MAC, restore RxHandler_Api.h 
#include "RxHandler_Api.h"
#endif
//#include "RxPp_Api.h"
#include "TpcClbrHndlr.h"
#include "CoC_Api.h"
#include "TxPacketsClassifier_API.h"
#include "CalibrationManager.h"
#include "loggerAPI.h"
#ifdef SNIFFER_DEBUG
#include "Pac_Api.h"
#endif //SNIFFER_DEBUG
#define LOG_LOCAL_GID   GLOBAL_GID_DUT
#define LOG_LOCAL_FID 0


//---------------------------------------------------------------------------------
//						Defines									
//---------------------------------------------------------------------------------

// Allows Special Compilation for Dut

#define DUT_SUB_MODULE_MASK		0xF00
#define DUT_SUB_MODULE_SHIFT	8

typedef enum
{
	DUT_MANAGMENT_SUB_MODULE = 0,
	DUT_HW_ACCESS_SUB_MODULE,
	DUT_TX_SUB_MODULE,
	DUT_RX_SUB_MODULE,
	DUT_TOTAL_SUB_MODULE = 0xFF
} dutSubModule_e;

//typedef enum
//{
//	DUT_STATE_DISABLED,
//	DUT_STATE_ENABLED,
//} dutState_e;

#ifdef SNIFFER_DEBUG
#define DEBUG_SNIFFER_TRACE_ARRAY_SIZE 500

AAA_DebugTrace_SnifferArray_t AAA_DebugTrace_SnifferArray[DEBUG_SNIFFER_TRACE_ARRAY_SIZE] = {0};
uint16 AAA_DebugTrace_SnifferArrayIndex = 0;
#endif //SNIFFER_DEBUG


//---------------------------------------------------------------------------------
//						Macros									
//---------------------------------------------------------------------------------
#define GET_DUT_SUB_MODULE_ID(x)	((x & DUT_SUB_MODULE_MASK) >> DUT_SUB_MODULE_SHIFT)
//---------------------------------------------------------------------------------
//						Data Type Definition									
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Static Function Declaration									
//---------------------------------------------------------------------------------
//static void dutDispatcher(IN K_MSG *psMsg);
//static void dutLmConfigureCfm(IN K_MSG *psMsg);
void DutLmConfigureCfm(K_MSG *psMsg);
//void Dut_UpdateAntennas(uint8 txAntsMask, uint8 rxAntMask);
static void DUT_SetCurrentAntsMask(K_MSG* pMsg);
static void DUT_updateRxManagerOnOperationModeChange(UmiOperationMode_e opMode,  dutOperationModeUpdateMsgType_e mode,uint8 vapId);
static void DUT_updateRxManagerOnOperationModeChangeRes(K_MSG* pMsg);

//static void dutSetChannelCfm(IN K_MSG *psMsg);
//static void dutSetHwDepConfigCfm(IN K_MSG *psMsg);
//static void dutHwAccessMsgCfm(IN K_MSG *psMsg);
//static void dutTxPacketCfm(IN K_MSG *psMsg);
//---------------------------------------------------------------------------------
//						Static Variables									
//---------------------------------------------------------------------------------
static const FunctionEntry_t afpTaskTable[TASK_DUT_END-TASK_DUT_START]=
{
	
	{dutDispatcher,				DOUBLE_CHECK_MSG_TYPE(DUT_MSG_REQ)},
	{Dut_HandleAddVapReq,		DOUBLE_CHECK_MSG_TYPE(DUT_ADD_VAP)},
	{Dut_HandleRemoveVapReq,	DOUBLE_CHECK_MSG_TYPE(DUT_REMOVE_VAP)},
	{Dut_HandleSetFixedRateCfm,	DOUBLE_CHECK_MSG_TYPE(DUT_SET_FIXED_RATE_CFM)},
	{Dut_HandleSetFixedRateCfm,	DOUBLE_CHECK_MSG_TYPE(DUT_SET_TX_POWER_CFM)},
	{Dut_HandleSetFixedRateCfm,	DOUBLE_CHECK_MSG_TYPE(DUT_SET_TX_ANT_CFM)},
	{DUT_SendModifyIfsParamsReq,DOUBLE_CHECK_MSG_TYPE(DUT_START_DUT_PROCESS)},
	{Dut_MsgCallBackFromProcess,DOUBLE_CHECK_MSG_TYPE(DUT_FINALIZE_DUT_PROCESS)},
	{Dut_MsgCallBack, 			DOUBLE_CHECK_MSG_TYPE(DUT_MSG_CFM)},	
	{DUT_SetCurrentAntsMask,	DOUBLE_CHECK_MSG_TYPE(DUT_UPDATE_TX_RX_ANTS_FROM_COC)}, 	
	{dutTransmitPacketCfm,		DOUBLE_CHECK_MSG_TYPE(DUT_TRANSMIT_PACKET_CFM)}, 	
	{DUT_updateRxManagerOnOperationModeChangeRes,	DOUBLE_CHECK_MSG_TYPE(DUT_OPERATION_MODE_UPDATE_RES)},	
	{DUT_getRxCountCfm,			DOUBLE_CHECK_MSG_TYPE(DUT_GET_RX_COUNT_CFM)},	
#ifdef ENET_INC_ARCH_WAVE600
	{DUT_getRateCfm, 			DOUBLE_CHECK_MSG_TYPE(DUT_GET_PHY_RATE_CFM)},	
#endif
	{Dut_HandleTxActionPublicFrameCb,DOUBLE_CHECK_MSG_TYPE(DUT_ACTION_PACKET_CB_HNDLR_REQ)},	




	
};

dutDB_t dutDB;

FwUtils_queue_t dutGeneralMsgQ;

//static FwUtils_queue_t hwDepConfigMsgQ;

//---------------------------------------------------------------------------------
//						Debug Section									
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Functions Definitions									
//---------------------------------------------------------------------------------






void Dut_HandleAddVapReq(K_MSG *pMsg)
{
	UMI_ADD_VAP* addVapStructurePtr;
	uint8 vapId; 
	K_MSG *vapMsg = (K_MSG *) (*((uint32 *)pK_MSG_DATA(pMsg)));

	addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(vapMsg);
	vapId = addVapStructurePtr->vapId; 
	dutDB.vapCount++;
	dutDB.operationMode = (UmiOperationMode_e)addVapStructurePtr->operationMode;
	DUT_updateRxManagerOnOperationModeChange(dutDB.operationMode,ADD_VAP, vapId);
	if ((addVapStructurePtr->operationMode == OPERATION_MODE_DUT) || (addVapStructurePtr->operationMode == OPERATION_MODE_SNIFFER))
	{
		DUT_InitParams();
		dutDB.vapIndex = addVapStructurePtr->vapId;
#ifdef DUT_LOGS_ON
		ILOG0_V("-------- DUT VAP ADDED --------");
#endif
#if !defined (HDK_REL_2_0)
		TPC_stopTimer();
#endif
#if !defined (HDK_REL_2_0)
		ClbrMngr_EnableDisableOnlineCal(DISABLED, FALSE);
#endif
	}
}

void Dut_HandleRemoveVapReq(K_MSG *pMsg)
{
	uint8 vapId;
	UMI_REMOVE_VAP* removeVapStructurePtr; 
	K_MSG *vapMsg = (K_MSG *) (*((uint32 *)pK_MSG_DATA(pMsg)));
	removeVapStructurePtr = (UMI_REMOVE_VAP *)pK_MSG_DATA(vapMsg);
	vapId = removeVapStructurePtr->vapId; 
	DEBUG_ASSERT(dutDB.vapCount > 0);
	dutDB.vapCount--;
	if (((dutDB.operationMode == OPERATION_MODE_DUT) || (dutDB.operationMode == OPERATION_MODE_SNIFFER)) && (dutDB.vapIndex == removeVapStructurePtr->vapId))
	{
		dutDB.operationMode = OPERATION_MODE_NORMAL;
#ifdef DUT_LOGS_ON
		ILOG0_V("-------- DUT VAP REMOVED--------");
#endif
	}
	DUT_updateRxManagerOnOperationModeChange(dutDB.operationMode,REMOVE_VAP, vapId);
}

void Dut_HandleSetFixedRateCfm(K_MSG *pKmsg)
{
	uint32 isTxPowerVectorEnable;
	uint32 changedPowerStatus;
	dutTxParams_t txParams_p;
	TxPd_t *pDesc = PNULL;
	UNUSED_PARAM(pKmsg);
	
#ifdef DUT_LOGS_ON
	ILOG0_V("-------- DUT Dut_HandleSetFixedRateCfm--------");
#endif
	isTxPowerVectorEnable =dutGetTxPowerVectorStatus();
	changedPowerStatus = dutGetChangePowerVectorStatus();

	pDesc = dutGetTransmitPowerPacketDesc();

	if(isTxPowerVectorEnable == FALSE)
	{
		Dut_MsgCallBack(PNULL);
	}
	else
	{
		if(changedPowerStatus == 0x1)
		{
			txParams_p.repeats =0xffff;//transmitPowerVector.numOfTransmitionPerPower[PVpowerToTransmitIndex];
			txParams_p.packetLength =dutGetTransmitPowerVectorStartingLength();
			txParams_p.isTxEndless =TRUE;
			dutTxStartTransmision(&txParams_p);
			
		}
		if(changedPowerStatus == 0x2)
		{		
			dutTxSendManagementPacketFromFw(pDesc);
		}
	}
}

void DUT_InitParams()
{
	dutDB.sendCfm = FALSE;
	dutDB.savedDutMsg_p = PNULL;
	dutDB.savedDutMsgId = DUT_UNKNOWN_MSG;
	dutDB.isChannelSet = FALSE;
	dutDB.calibrationInProcess = FALSE;
	dutDB.TxPowerFeedbackRequested = FALSE;
	dutDB.failedTxPowerFeedbackReadAttempts = 0;
	dutDB.spaceless = FALSE;
	dutDB.riscMode = DUT_RISC_START;
	dutDB.txAntEnableMask = ANTENNA_BITMAP_NONE;
	dutDB.rxAntEnableMask = ANTENNA_BITMAP_NONE;
    DutTx_Init();
}

#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void Dut_Init(void)
{
	dutDB.vapCount = 0;
	dutDB.operationMode =			OPERATION_MODE_NORMAL;
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif



/****************************************************************************
 **
 ** NAME:		   vTXST_Task
 **
 ** PARAMETERS:	 kernel message
 **
 ** RETURN VALUES:  void
 **
 ** DESCRIPTION:	State machine entry point, as used by the kernel
 **
 ***************************************************************************/
void Dut_Task(K_MSG *psMsg)
{
    /* Use common task switching and Table */
	vTaskDispatcher(psMsg, afpTaskTable, TASK_DUT_START, TASK_DUT_END);
}

void DUT_CfmToHost(dutStatus_e status)
{
	dutMessage_t *dutMessage_p = (dutMessage_t *)pK_MSG_DATA(dutDB.savedDutMsg_p);
	
	SET_MSG_ID_TO_CFM(dutMessage_p->msgId);	
	dutMessage_p->status = (uint16)status;
#ifdef DUT_LOGS_ON
		ILOG0_V("DUT_CfmToHost  DUT_CfmToHost  DUT_CfmToHost  DUT_CfmToHost");
#endif

	ILOG2_V("DUT_CfmToHost  DUT_CfmToHost  DUT_CfmToHost  DUT_CfmToHost");
	Dut_MsgCallBack(PNULL);
}

/*********************************************************************************
Method:			Dut_getDB
Description:  
Parameter:    	none
Returns:      	void
Remarks:		None
*********************************************************************************/
dutDB_t *Dut_getDB(void)
{
	return (&dutDB);
}

/*********************************************************************************
Method:			Dut_MsgCallBackFromProcess
Description:  
Parameter:    	none
Returns:      	void
Remarks:		None
*********************************************************************************/
void Dut_MsgCallBackFromProcess(K_MSG *kMsg_p)
{
	UNUSED_PARAM(kMsg_p);	
#ifdef DUT_LOGS_ON
	ILOG0_V("Dut_MsgCallBackFromProcess");
#endif
	Dut_MsgCallBack(PNULL);
}

/*********************************************************************************
Method:       Dut_MsgCallBack
Description:  
Parameter:    K_MSG * psMsg - shall no be used
Returns:      void
*********************************************************************************/
void Dut_MsgCallBack(K_MSG *kMsg_p)
{
	UNUSED_PARAM(kMsg_p);
#ifdef DUT_LOGS_ON
{
	dutMessage_t *dutMessage_p = (dutMessage_t *)(dutDB.savedDutMsg_p->abData);
	dutMessageHeader_t *dutMessageHeader_p = (dutMessageHeader_t *)dutMessage_p;
	
	UNUSED_PARAM(dutMessageHeader_p);
	SLOG0(0, 0, dutMessageHeader_t, dutMessageHeader_p);
}
#endif
	OSAL_SEND_MESSAGE(UMI_DUT_MSG_CFM, TASK_UM_IF_TASK, dutDB.savedDutMsg_p, dutDB.vapIndex);	
#ifdef DUT_DEBUG
	dutDB.savedDutMsgDebug_p = dutDB.savedDutMsg_p;
#endif
	dutDB.savedDutMsg_p = NULL;
}

//---------------------------------------------------------------------------------
//						Static Functions Definitions									
//---------------------------------------------------------------------------------
/*********************************************************************************
Method:       dutDispatcher
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
void dutDispatcher(IN K_MSG *psMsg)  
{
	dutMessage_t *dutMessage_p = (dutMessage_t*)pK_MSG_DATA(psMsg);
	uint8 dutSubModuleId =  GET_DUT_SUB_MODULE_ID(dutMessage_p->msgId);
	dutMessageHeader_t *dutMessageHeader_p = (dutMessageHeader_t *)dutMessage_p;
//	dutMessagesId_e dutMessagesId = dutMessageHeader_p->msgId;


	ILOG0_D("dutDispatcher Received message with ID = 0x%X",dutMessageHeader_p->msgId);

	// Save pointer to msg
//    ASSERT(dutDB.savedDutMsg_p == PNULL);
	dutDB.savedDutMsg_p = psMsg;
	dutDB.savedDutMsgId = dutMessageHeader_p->msgId;
	switch (dutSubModuleId)
	{
	case DUT_MANAGMENT_SUB_MODULE:
	case DUT_HW_ACCESS_SUB_MODULE:
		DutMngmnt_Dispatcher(dutMessage_p);
		break;
	case DUT_TX_SUB_MODULE:
		DutTx_Dispatcher(dutMessage_p);
		break;
	case DUT_RX_SUB_MODULE:
		// Currently Not Supported
	default:
		DEBUG_ASSERT(0);
		break;
	}
}
static void DUT_SetCurrentAntsMask(K_MSG* pMsg)
{
	cocUpdateAntMaskMsg_t* numOfActivateAnts = (cocUpdateAntMaskMsg_t*)pK_MSG_DATA(pMsg);

	dutDB.txAntEnableMask = (AntennaBitmaps_e)numOfActivateAnts->currentTxAntsMask;
	dutDB.rxAntEnableMask = (AntennaBitmaps_e)numOfActivateAnts->currentRxAntsMask;
}


#ifndef ENET_INC_ARCH_WAVE600
void DUT_SnifferSetUdpHeader(UMI_ADD_STREAM_REQ_t* addStreamStructurePtr)
{
	RxHandler_SetUdpHeader(addStreamStructurePtr); 
}
#endif 
#ifdef SNIFFER_DEBUG
void AAA_SNIFFER_DEBUGTRACE(uint16 event, uint32 bdIndex)
{
	AAA_DebugTrace_SnifferArray[AAA_DebugTrace_SnifferArrayIndex].eventId = event;
	AAA_DebugTrace_SnifferArray[AAA_DebugTrace_SnifferArrayIndex].bdIndex = bdIndex;
	AAA_DebugTrace_SnifferArray[AAA_DebugTrace_SnifferArrayIndex].tsfLow = GET_TSF_TIMER_LOW();
	AAA_DebugTrace_SnifferArrayIndex++;
	if (AAA_DebugTrace_SnifferArrayIndex == DEBUG_SNIFFER_TRACE_ARRAY_SIZE)
	{
		AAA_DebugTrace_SnifferArrayIndex = 0;
	}
}
#endif //SNIFFER_DEBUG


static void DUT_updateRxManagerOnOperationModeChange(UmiOperationMode_e opMode,  dutOperationModeUpdateMsgType_e mode,uint8 vapId)
{
	K_MSG* pMsg;
	dutOperationModeUdateMsgParams_t* pDutOpModeParams;
	
	pMsg = OSAL_GET_MESSAGE(sizeof(dutOperationModeUdateMsgParams_t));
	pDutOpModeParams = (dutOperationModeUdateMsgParams_t *)pK_MSG_DATA(pMsg);
	pDutOpModeParams->operationMode = opMode;
	pDutOpModeParams->msgType = mode;
	pDutOpModeParams->retMsg = DUT_OPERATION_MODE_UPDATE_RES;
	pDutOpModeParams->retTask = TASK_DUT;
	OSAL_SEND_MESSAGE(RX_MANAGER_UPDATE_DUT_OPERATION_MODE_IND, TASK_RX_MANAGER,pMsg, vapId);
}
void DUT_updateRxManagerOnOperationModeChangeRes(K_MSG* pMsg)
{
	dutOperationModeUdateMsgParams_t* pDutOpModeParams = (dutOperationModeUdateMsgParams_t *)pK_MSG_DATA(pMsg);
	K_MSG* bssManMsg;
	BSS_MANAGER_CONFIRM_EVENT* confirmEvent; 
	bssManMsg = OSAL_GET_MESSAGE(sizeof(BSS_MANAGER_CONFIRM_EVENT));
	confirmEvent = (BSS_MANAGER_CONFIRM_EVENT*)(pK_MSG_DATA(bssManMsg));

	switch (pDutOpModeParams->msgType)
	{
		case ADD_VAP:
			confirmEvent->vapId = pMsg->header.vapId;
			confirmEvent->eventIndex = VAP_MANAGER_ADD_VAP; 
			confirmEvent->clientId = BSS_MANAGER_VAP_MANAGER_DUT_CLIENT; 
			break;
		case REMOVE_VAP:
			confirmEvent->vapId= pMsg->header.vapId;
			confirmEvent->eventIndex = VAP_MANAGER_REMOVE_VAP; 
			confirmEvent->clientId = BSS_MANAGER_VAP_MANAGER_DUT_CLIENT; 
			break;
	}
	OSAL_SEND_MESSAGE(BSS_MANAGER_VAP_MANAGER_REGISTERED_MODULE_CONFIRM, TASK_BSS_MANAGER, bssManMsg, confirmEvent->vapId);	 
}
