/***************************************************************
 File:	Dut_HwAccess.c.c
 Module:	Dut
 Purpose: 	A short description of the class purpose.
 Description: A detailed description of the class, its attributes and whatever 
	             information the user & maintainer might find 
 	             valuable.
***************************************************************/
//-------------------------------------------------------------------------------
//						Includes									
//-------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Information.h"
#include "enet_pas.h"
#include "stringLibApi.h"
 
#include "OSAL_Api.h"
#include "Dut_Api.h"
#include "Dut.h"
#include "mhi_dut.h"
#include "LmHdk_API.h"
#include "RficDriver_API.h"
#include "Afe_API.h"
#include "PhyDriver_API.h"
#include "PhyCalDriver_API.h"
#include "TpcClbrHndlr.h"
#include "lm.h"
#include "lm_statistics.h"
#include "shram_man_queues.h"
#include "int_gen.h"
#include "ErrorHandler_Api.h"
#include "ShramTxHandlerTimingParams.h"
#include "TxHandler_Api.h"
#include "lm.h"
#include "HwQManager_API.h"
#include "Pac_Api.h"
#include "ProcessManager_Api.h"
#include "TpcClbrHndlr.h"
#include "lminfra.h"
#include "init_ifmsg.h"
#include "CoC_Api.h"
#include "RegAccess_Api.h"
#include "HwMemoryMap.h"
#include "Protocol_PhyAttributes.h"
#include "PSD.h"

/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"
#define LOG_LOCAL_GID   GLOBAL_GID_DUT
#define LOG_LOCAL_FID 1


//-------------------------------------------------------------------------------
//						Defines									
//-------------------------------------------------------------------------------
#define DUT_POWER_FB_READ_ATTEMPTS_PER_SAMPLE (10)
//-------------------------------------------------------------------------------
//						Data Type Definition									
//-------------------------------------------------------------------------------

#define RF_GAIN_ADDR_ANT0 (0x202A0)
#define RF_GAIN_ADDR_ANT1 (0x202A4)
#define RF_GAIN_ADDR_ANT2 (0x202A8)
#define RF_GAIN_ADDR_ANT3 (0x202AC)

#define RX_SYS_GAIN_ADDR_ANT0 (0x140F4)
#define RX_SYS_GAIN_ADDR_ANT1 (0x141F4)
#define RX_SYS_GAIN_ADDR_ANT2 (0x142F4)
#define RX_SYS_GAIN_ADDR_ANT3 (0x143F4)

#define RX_SYS_GAIN_MASK (0xFF)

#define RX_SYS_GAIN_ANT_OFFSET (RX_SYS_GAIN_ADDR_ANT1 - RX_SYS_GAIN_ADDR_ANT0)


#define BACKOFF_TO_DBM_OFFSET_ANT0 (0x14738)
#define BACKOFF_TO_DBM_OFFSET_ANT1 (0x14744)
#define BACKOFF_TO_DBM_OFFSET_ANT2 (0x14750)
#define BACKOFF_TO_DBM_OFFSET_ANT3 (0x1475C)

#define BACKOFF_TO_DBM_OFFSET_MASK (0x3F)

#define BACKOFF_TO_DBM_OFFSET_ANT_OFFSET (BACKOFF_TO_DBM_OFFSET_ANT1 - BACKOFF_TO_DBM_OFFSET_ANT0)



#define RF_GAIN_PGC2_TX_GAIN_MASK		(0x3)
#define RF_GAIN_PGC2_TX_GAIN_SHIFT		(0)

#define RF_GAIN_PRE_DRIVER_GAIN_MASK 	(0xF)
#define RF_GAIN_PRE_DRIVER_GAIN_SHIFT 	(2)

#define RF_GAIN_S2D_OFFSET_MASK 		(0x1F)
#define RF_GAIN_S2D_OFFSET_SHIFT		(6)

#define RF_GAIN_S2D_GAIN_MASK 			(0xF)
#define RF_GAIN_S2D_GAIN_SHIFT 			(11)

#define RF_GAIN_RFIC_TX_ON_INDICATOR_MASK 	(0x1)
#define RF_GAIN_RFIC_TX_ON_INDICATOR_SHIFT 	(15)

//-------------------------------------------------------------------------------
//						Macros									
//-------------------------------------------------------------------------------
#define SIGN_EXTEND(value, Bits)	if(value  >= (1<< (Bits-1) ) ) value-=(1<<Bits)

//-------------------------------------------------------------------------------
//						Static Variables									
//-------------------------------------------------------------------------------

uint8 EnableAggregate_global = 0;


//-------------------------------------------------------------------------------
//						Static Function Declaration									
//-------------------------------------------------------------------------------

//----------------------------- General  ----------------------------//


//--------------------------------------------------------------------------------
//						Debug Section									
//--------------------------------------------------------------------------------


 

//--------------------------------------------------------------------------------
//						Public Functions Definitions									
//--------------------------------------------------------------------------------


/*********************************************************************************
Method:			DutHwAccess_ReadChipVersion
Description:  
Parameter:    	OUT dutChipVersion_t * chipVersion
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessReadChipVersion(OUT dutChipVersion_t *chipVersion)
{
	chipVersion->bbChipId = SystemInfo_GetLocalChipId();
	
#if !defined (ENET_INC_HW_FPGA)
	RficDriver_GetRfChipID(&chipVersion->rfChipId);
#endif

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutChipVersion_t, chipVersion);
#endif
}

/*********************************************************************************
Method:			DutHwAccess_ReadHwVersion
Description:	
Parameter:    	OUT dutHwParams_t * hwParams
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessReadRiscVersion(OUT PhyVersion_t *hwParams)
{
	PhyDrv_ReadVersion(hwParams);
}


void dutResetBb(void)
{
	dutDB_t *dutDB_p = Dut_getDB();
	
	if (dutDB_p->riscMode == DUT_RISC_START)
	{
#ifdef DUT_LOGS_ON
		ILOG0_V("dutResetBb, calling PhyDrv_ResetBB()");
#endif
		PhyDrv_ResetBB();
	}
}

void dutStartBb(void)
{
	dutDB_t *dutDB_p = Dut_getDB();
	
	if (dutDB_p->riscMode == DUT_RISC_START)
	{
#ifdef DUT_LOGS_ON
		ILOG0_V("dutStartBb, calling PhyDrv_ReActivateBB()");
#endif
		PhyDrv_ReActivateBB();
	}
}


/*********************************************************************************
Method:			dutHwAccessEnableTxAntenna
Description:    Wave300 - Disable/Enable the tx antenna on the RFIC 
				AR10	- Disable/Enable the tx antenna on the digital domain
Parameter:    	IN dutSetAntennaParams_t * setAntennaParams
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessEnableTxAntenna(IN dutSetAntennaParams_t *setAntennaParams_p)
{
	AntennaBitmaps_e enabledAntennaBitMap = (AntennaBitmaps_e)setAntennaParams_p->enabledAntMask;
	dutDB_t *dutDB_p = Dut_getDB();
	uint8 digitalAfeTxAntMask = enabledAntennaBitMap;

	K_MSG *kMsg_p = NULL;
	LinkAdaptationFixedAntennaSelection_t *linkAdaptationFixedAntSel_p;

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutSetAntennaParams_t, setAntennaParams_p);
#endif
	
	dutDB_p->txAntEnableMask = enabledAntennaBitMap;
	if(ANTENNA_BITMAP_NONE == enabledAntennaBitMap)
	{
		/* PSD_findFirstAntInMask func. should not called with antmask == 0, 
			In gen5 and gen6 there is no option to set up system with antenna mask == 0*/
		digitalAfeTxAntMask = 1 << (PSD_findFirstAntInMask(Hdk_GetTxAntMask()));
	}

	//Stop Risc
	dutResetBb();

	PhyDrv_SetTxAntOperationSet(digitalAfeTxAntMask);
#if !defined (ENET_INC_HW_FPGA)

	// Enable the Tx antenna in the RFIC
	RficDriver_ActivateTxAntennas(enabledAntennaBitMap);
#endif	
	// Restart Risc
	dutStartBb();
	
	PhyDrv_Set_11B_TxAntSelection((PhyDrv_11BAntSelection_e)CALC_11B_ANT(enabledAntennaBitMap));


	// antenna selection
	if (enabledAntennaBitMap != 0)
	{
		kMsg_p = OSAL_GET_MESSAGE(sizeof(LinkAdaptationFixedAntennaSelection_t));
		linkAdaptationFixedAntSel_p = (LinkAdaptationFixedAntennaSelection_t *)pK_MSG_DATA(kMsg_p);
		linkAdaptationFixedAntSel_p->mode = MODIFY_ANTENNA_MASK;
		linkAdaptationFixedAntSel_p->mask = enabledAntennaBitMap;
		linkAdaptationFixedAntSel_p->vapId 	= dutDB_p->vapIndex;
		linkAdaptationFixedAntSel_p->stationId = INVALID_STA_INDEX;
		linkAdaptationFixedAntSel_p->retTask 	= TASK_DUT;
		linkAdaptationFixedAntSel_p->retMsg 	= DUT_SET_TX_ANT_CFM;

#ifdef DUT_LOGS_ON
		SLOG0(0, 0, LinkAdaptationFixedAntennaSelection_t, linkAdaptationFixedAntSel_p);
#endif

		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_ANTENNA_SELECTION_REQ, TASK_LINK_ADAPTATION, kMsg_p, dutDB_p->vapIndex); 

	}
	else
	{
		Dut_MsgCallBack(PNULL);
	}	

}

/*********************************************************************************
Method:			dutHwAccessEnableTxAntenna
Description:  
Parameter:    	IN dutSetAntennaParams_t * setAntennaParams
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessEnableRxAntenna(IN dutSetAntennaParams_t *setAntennaParams)
{
	AntennaBitmaps_e enabledAntennaBitMap = (AntennaBitmaps_e)setAntennaParams->enabledAntMask;
	dutDB_t *dutDB_p = Dut_getDB();
	uint8 digitalAfeRxAntMask = enabledAntennaBitMap;
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutSetAntennaParams_t, setAntennaParams);
#endif

	dutDB_p->rxAntEnableMask = enabledAntennaBitMap;

	//Stop Risc
	dutResetBb();
	if(ANTENNA_BITMAP_NONE == enabledAntennaBitMap)
	{
		/* PSD_findFirstAntInMask func. should not called with antmask == 0, 
			In gen5 and gen6 there is no option to set up system with antenna mask == 0*/
		digitalAfeRxAntMask = 1 << (PSD_findFirstAntInMask(Hdk_GetRxAntMask()));
	}

	// Enable the required Rx antenna in the digital domain
	PhyDrv_SetRxAntOperationSet(digitalAfeRxAntMask);
#if !defined (ENET_INC_HW_FPGA)	
	// Enable the required Rx antenna in the RF
	RficDriver_ActivateRxAntennas(enabledAntennaBitMap);
	
	RficDriver_UpdateShort0ShadowRegister(enabledAntennaBitMap); //only wave500
#endif
	// Restart risc
	dutStartBb();

    PhyDrv_Set_11B_RxAntSelection((PhyDrv_11BAntSelection_e)CALC_11B_ANT(enabledAntennaBitMap));

}

//----------------------------- Digital Phy ----------------------------//
/*********************************************************************************
Method:			dutHwAccessSetDefaultAntenaSet
Description:  
Parameter:    	dutSetAntennaParams_t * 
Parameter:    	dutMessage->data
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessSetDefaultAntenaSet(antSelectionParams_t *defaultAntennaSet)
{
	UNUSED_PARAM(defaultAntennaSet);	
#ifdef DUT_LOGS_ON
	ILOG0_V("dutHwAccessSetDefaultAntenaSet, calling PhyDrv_SetRFMtype(MTLK_RF_MGMT_TYPE_OFF) ");
#endif
}


/*********************************************************************************
Method:       DutHwAccess_TransmitTone
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/


#ifdef ENET_INC_ARCH_WAVE600
int8 dutHwAccessGetScale(int8 amplitude)
{
	int8 scale = amplitude;
	if (scale > SCALE_MAX_VALUE)
	{
		if ((scale != 9) && (scale != 10))//work around till rf will fix PhyCalDrv_RunToneGen and PhyCalDrv_SetToneGenScale, to get between 2 and -2
		{
			scale = SCALE_MAX_VALUE;
		}
	}
	else if (scale < SCALE_MIN_VALUE)
	{
		scale = SCALE_MIN_VALUE;
	}
	return scale;
}
int16 txDigGain[MAX_NUM_OF_ANTENNAS];
uint32	txTxScale= 0;

void dutHwAccessTransmitTone(IN dutTxToneParams_t *toneParams)
{
	static bool initDone = FALSE;
	uint8 txAntMask = (uint8)Hdk_GetTxAntMask();
	int16 digGain[MAX_NUM_OF_ANTENNAS] = {TONE_DIGGAIN,TONE_DIGGAIN,TONE_DIGGAIN,TONE_DIGGAIN};
	int16 dacI[MAX_NUM_OF_ANTENNAS] = {0};
	int16 dacQ[MAX_NUM_OF_ANTENNAS] = {0};
	int8 scale = dutHwAccessGetScale(toneParams->amplitude);

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutTxToneParams_t, toneParams);
#endif
		
	if (TONE_GEN_TOGGLE_ON == toneParams->onOff)
	{
		if (FALSE == initDone)
		{
			dutResetBb();
			/* tone scaling */
			txTxScale = PhyCalDrv_GetToneGenScale(); 
			PhyCalDrv_GetTxDigitalGain(txAntMask,txDigGain);
#if !defined (ENET_INC_HW_FPGA)		

			RficDriver_ActivateTxAntennas((AntennaBitmaps_e)txAntMask);
			RficDriver_ActivateRxAntennas(ANTENNA_BITMAP_NONE);
			RficDriver_setRffeMode(TX_MODE,(AntennaBitmaps_e)txAntMask);
			RficDriver_SetTxGain((AntennaBitmaps_e)txAntMask, INITIAL_TPC_INDEX, PAD_GAIN_DB);
#endif
			PhyCalDrv_ToneGenInitAfe();
			PhyCalDrv_RunToneGen(txAntMask,toneParams->binNum, scale,digGain);
			PhyCalDrv_SetDigitalLoCancelPair(txAntMask,dacI,dacQ,0);
			initDone = TRUE;
		}
		else // (TRUE == initDone) so just set the new amplitude
		{
			PhyCalDrv_SetToneGenScale(txAntMask, scale);
		}   
	}
	else //if (TONE_GEN_TOGGLE_OFF == toneParams->onOff)
	{
		PhyCalDrv_ToneGenClearAndDisable(txAntMask);
		PhyCalDrv_SetToneGenScale(txAntMask, 1);//return to default scale
		PhyCalDrv_SetDigitalLoCancelPair(txAntMask,dacI,dacQ,0);
#if !defined (ENET_INC_HW_FPGA)
		RficDriver_ActivateTxAntennas(ANTENNA_BITMAP_NONE);
		RficDriver_ActivateRxAntennas(ANTENNA_BITMAP_NONE);
#endif
		PhyCalDrv_SetToneGenScale(txAntMask,txTxScale);
		PhyCalDrv_SetDigitalGain(txAntMask,txDigGain);
		dutStartBb();
		initDone = FALSE;
	}
}
#else // not ENET_INC_ARCH_WAVE600
void dutHwAccessTransmitTone(IN dutTxToneParams_t *toneParams)
{
	static bool initDone = FALSE;
	uint8 txAntMask = (uint8)Hdk_GetTxAntMask();
#if !defined (ENET_INC_HW_FPGA)	
	dutDB_t *dutDB_p = Dut_getDB();
#endif

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutTxToneParams_t, toneParams);
#endif
		
	if (TONE_GEN_TOGGLE_ON == toneParams->onOff)
	{
		if (FALSE == initDone)
		{
			dutResetBb();
#if !defined (ENET_INC_HW_FPGA)

			RficDriver_ActivateTxAntennas((AntennaBitmaps_e)txAntMask);
			RficDriver_ActivateRxAntennas(ANTENNA_BITMAP_NONE);
			RficDriver_UpdateShort0ShadowRegister(ANTENNA_BITMAP_NONE);
			RficDriver_setRffeMode(TX_MODE,(AntennaBitmaps_e)txAntMask);
			RficDriver_AbstractSetTxGain((AntennaBitmaps_e)txAntMask, 0, 24);
#endif
			PhyCalDrv_ToneGenInitAfe();
			PhyCalDrv_SetToneGenParams(0, 0, txAntMask, 0);
			PhyCalDrv_ToneGenInit(toneParams->amplitude);
			PhyCalDrv_SetDigitalGain(0 , 0, TONEGEN_FILT_ANT01_VAL_LSB);
			PhyCalDrv_ToggleTxTone(toneParams->binNum,toneParams->onOff);
			initDone = TRUE;
		}
		else // (TRUE == initDone) so just set the new amplitude
		{
			PhyCalDev_SetToneGenAmplitude(toneParams->amplitude);
		}   
	}
	else //if (TONE_GEN_TOGGLE_OFF == toneParams->onOff)
	{
		PhyCalDrv_ToggleTxTone(toneParams->binNum,toneParams->onOff);			
		PhyCalDrv_ToneGenRestore();
#if !defined (ENET_INC_HW_FPGA)		
		RficDriver_ActivateTxAntennas(dutDB_p->txAntEnableMask);
		RficDriver_UpdateShort0ShadowRegister(dutDB_p->txAntEnableMask);
		RficDriver_ActivateRxAntennas(dutDB_p->rxAntEnableMask);
#endif
		dutStartBb();
		initDone = FALSE;
	}

}
#endif

/*********************************************************************************
Method:       DutHwAccess_SetSpacelessTransmission
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
 void dutHwAccessSetSpacelessTransmission(dutTxSpacelessParams_t *dutTxSpacelessParams_p)
{
	dutDB_t *dutDB_p = Dut_getDB();

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutTxSpacelessParams_t, dutTxSpacelessParams_p);
	ILOG0_DD("dutHwAccessSetSpacelessTransmission, dutDB_p->spaceless:%d was  (0=false, 1=true), now chabge to %d", dutDB_p->spaceless, dutTxSpacelessParams_p->onOff);
#endif	

	if (dutDB_p->m_DutTrafficParams.phyMode != PHY_MODE_11B)
	{
		if (dutTxSpacelessParams_p->onOff == TRUE)
		{
			dutDB_p->spaceless = TRUE;
	//		dutResetBb();
#if defined (ENET_INC_ARCH_WAVE600)		

			PhyCalDrv_SetSpacelessTransmission(TRUE);
#else

			PhyDrv_SetSpacelessTransmission(0x8);
#endif
		}
		else if (dutDB_p->spaceless == TRUE)
		{
			dutDB_p->spaceless = FALSE;
	//		dutStartBb();
#if defined (ENET_INC_ARCH_WAVE600)		
			PhyCalDrv_SetSpacelessTransmission(FALSE);
#else
			
			PhyDrv_SetSpacelessTransmission(0x0); // stops spaceless
#endif
		}
	}
}

/*********************************************************************************
Method:			dutHwAccessSetScramblerMode
Description:  
Parameter:    	dutScramblerParams_t * scramblerParams
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessSetScramblerMode(IN dutScramblerParams_t *scramblerParams)
{
	PhyDrv_SetScramblerMode(scramblerParams->mode);
}

void DUT_SendModifyIfsParamsReq(K_MSG *kMsg_p)
{
	dutDB_t *dutDB_p = Dut_getDB();
	/* For TLOG purpose - used to be no data message, send dummy data instead */
	K_MSG *dummyMsg = NULL;
	
	uint8 acIndex = 0;
	HwAcTimingParams_t hwTimingParameters;
	UNUSED_PARAM(kMsg_p);
#ifdef DUT_LOGS_ON
	ILOG0_V("DUT_SendModifyIfsParamsReq");
#endif

	// apply hw params to all VAPs and all ACs
	for(acIndex = HW_AC_BE; acIndex < HW_AC_NUM_OF_PRIORITIES; acIndex ++)
	{
		TxHandler_GetVapAcTimingParameters(dutDB_p->vapIndex, acIndex, &hwTimingParameters);
		hwTimingParameters.aifsn = hwTimingParameters.ifsn = dutDB_p->dutHwSpacingParams.ifsn;
		hwTimingParameters.maximumContentionWindow = 0;
		hwTimingParameters.minimumContentionWindow = 0;
		TxHandler_SetVapAcTimingParameters(dutDB_p->vapIndex, acIndex, &hwTimingParameters);
	}

	/* For TLOG purpose - used to be no data message, send dummy data instead */
	dummyMsg = ProcessManager_GetDummyMessage();	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_PROCESS_EXCUTION_FINISHED, TASK_PROCESS_MANAGER, dummyMsg, dutDB_p->vapIndex);
}

uint32 dutGetMaxSpacingAllowed(uint32 slotTimer)
{
	uint32 maxSpacingAllowed = 0xFFFF;
	uint32 maxIfsAlllowed = 0xF;

	maxSpacingAllowed = (SIFS_TIME_11A + (slotTimer * maxIfsAlllowed));
	return maxSpacingAllowed;
}

/*********************************************************************************
Method:			dutSetIfsValue
Description:  
Parameter:    	dutIfsParams_t *ifsParams_p
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutSetIfsValue(dutIfsParams_t *ifsParams_p)
{
	dutDB_t *dutDB_p = Dut_getDB();
	uint32 spacingUsec = ifsParams_p->spacingUsec;
	uint32 ifsn = MAX_UINT32;
	uint32 slotTimer = Pac_TimGetSlotTimer();	

	dutDB_p->dutHwSpacingParams.spacingUsec = spacingUsec;

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutIfsParams_t, ifsParams_p);
#endif

	if (spacingUsec < SIFS_TIME_11A)
	{
		spacingUsec = SIFS_TIME_11A;
	}

	ifsn = (spacingUsec - SIFS_TIME_11A)/slotTimer;

#ifdef DUT_LOGS_ON
	ILOG0_DDD("DUT_SetIfsValue, spacingUsec:%d, ifsn:%d, slotTimer:%d", spacingUsec, ifsn, slotTimer);
#endif

	dutDB_p->dutHwSpacingParams.ifsn = (uint8)ifsn;

	/* Schedule Process */	
	{
		K_MSG *processManagerMsg_p = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
		ProcessRequestParams_t *processRequestParams_p = (ProcessRequestParams_t*)pK_MSG_DATA(processManagerMsg_p);

		processRequestParams_p->processId 							= PROCESS_ID_DUT;
		processRequestParams_p->startProcessMsg						= DUT_START_DUT_PROCESS;
		processRequestParams_p->endProcessMsg 						= DUT_FINALIZE_DUT_PROCESS;
		processRequestParams_p->requesterParams						= NULL;
		processRequestParams_p->preProcessServiceBitmap				= PROCESS_DUT_PRE_SERVICES_BITMAP;
		processRequestParams_p->postProcessServiceBitmap			= PROCESS_DUT_POST_SERVICES_BITMAP;
		processRequestParams_p->returnTask							= TASK_DUT;
		processRequestParams_p->updateParamsBeforeFinalizing 		= FALSE;
		processRequestParams_p->serviceData 						= 0;
		processRequestParams_p->vapId 								= dutDB_p->vapIndex;
		processRequestParams_p->dualBandProcess 					= FALSE;
		processRequestParams_p->processMsgHandledByCdbProcessMan 	= FALSE;

		OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST,TASK_PROCESS_MANAGER, processManagerMsg_p, dutDB_p->vapIndex);
	}
}





/*********************************************************************************
Method:			DutHwAccess_GetRssi
Description:  
Parameter:    	IN dutRficRssiParams_t * rssiValues
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessGetRssi(IN dutRssiParams_t *rssiParams)
{
	PhyDrv_ReadRssi(rssiParams->rssi,&rssiParams->N);
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutRssiParams_t, rssiParams);
#endif
}

/*********************************************************************************
Method:			dutHwAccessreadPacketsCounters
Description:  
Parameter:    	IN packetCountersParams_t * packetCountersParams
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessReadPacketsCounters(IN packetCountersParams_t *packetCountersParams)
{
	static uint32 baseMacPacketCounter;

	if(!packetCountersParams->doReset)
	{
		PhyDrv_ReadPacketCounter(&packetCountersParams->phyRxPacketCounter,&packetCountersParams->phyRxCrcErrorCounter);
		packetCountersParams->fwPacketCounter = (MT_LM_STAT_PP_GET(0, MT_LM_STAT_TX_UNICAST_OTHR_MPDU) - baseMacPacketCounter);
		if (TRUE == EnableAggregate_global)
		{
			packetCountersParams->phyRxCrcErrorCounter = Pac_RxcReadMpduCounter();
		}
	}
	else
	{
		PhyDrv_ResetPacketCounter();
		if (TRUE == EnableAggregate_global)
		{
			Pac_RxcClearMpduEndErrorCtrl();
		}
		packetCountersParams->phyRxPacketCounter = 0;
		packetCountersParams->phyRxCrcErrorCounter = 0;
		packetCountersParams->fwPacketCounter	   = 0;
		baseMacPacketCounter = MT_LM_STAT_PP_GET(0, MT_LM_STAT_TX_UNICAST_OTHR_MPDU);
	}
}
/*********************************************************************************
Method:			dutHwAccessGetRxEvm
Description:  
Parameter:    	
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutHwAccessGetRxEvm(IN dutGetRxEvm_t *rxEvm_p)
{
	PhyDrv_GetRxEvm(rxEvm_p->rxEvm);
}

//----------------------------- RFIC  ----------------------------//
/*********************************************************************************
Method:			dutHwAccessGetTxPowerFeedbackReq
Description:	Reads the TPC feedback table
Parameter:    	OUT dutTpcFeedbackparams_t * tpcFeedback
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutHwAccessGetTxPowerFeedbackReq(dutTpcFeedbackparams_t *tpcFeedbackParams_p)
{
	dutDB_t *dutDB_p = Dut_getDB();
	dutTxStates_e dutTxState;

	DEBUG_ASSERT(dutDB_p->TxPowerFeedbackRequested == FALSE);

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutTpcFeedbackparams_t, tpcFeedbackParams_p);
#endif

	dutTxState = dutTxGetState();

	if (dutTxState != DUT_TX_STATE_TRANSMITTING)
	{
		tpcFeedbackParams_p->valueGain = 0xDEAFDEAF;//  = 3736067759

#ifdef DUT_LOGS_ON
		ILOG0_V("dutHwAccessGetTxPowerFeedbackReq, dutTxState NOT is DUT_TX_STATE_TRANSMITTING ! return to user");
#endif

		Dut_MsgCallBack(PNULL);
	}
	else //DUT_TX_STATE_TRANSMITTING
	{
		tpcFeedbackParams_p->actualNumOfSamples = 0;
		dutDB_p->failedTxPowerFeedbackReadAttempts = 0;

		memset(tpcFeedbackParams_p->valueSum, 0, DUT_4ANT_ARRAY * sizeof(tpcFeedbackParams_p->valueSum[0]));

		tpcFeedbackParams_p->valueGain = 0;

		/* Only after all preparations are done, set the Tx feedback requested to TRUE */
		/* If set before, the feedback CFM interrupt might "cut" this function in the middle */
		dutDB_p->TxPowerFeedbackRequested = TRUE;
		if (TRUE == isDataLongTransmitted)//no call back in this situation
		{	
			dutHwAccessReadTxPowerFeedBack(TRUE);
		}
	}
}

/*********************************************************************************
Method:			DutHwAccess_GetRxGains
Description:  
Parameter:    	dutRficRxGainsParams_t * 
Parameter:    	dutMessage->data
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutHwAccessGetRxGains(OUT dutRficRxGainsParams_t *rxGains_p)
{
	int32 sysGain[MAX_NUM_OF_ANTENNAS];
	int32 backoffToDbmOffset;
	uint32 tempVal;
	uint8 antIndex = 0;
	
	PhyDrv_StopRisc();

	for(antIndex = 0; antIndex < MAX_NUM_OF_ANTENNAS; antIndex++)
	{
#if defined (ENET_INC_ARCH_WAVE600)		
		RegAccess_Read((B0_PHY_RX_TD_BASE_ADDR + RX_SYS_GAIN_ADDR_ANT0 + (antIndex * RX_SYS_GAIN_ANT_OFFSET)), &tempVal);
#else
		RegAccess_Read((PHY_TD_BASE_ADDR + RX_SYS_GAIN_ADDR_ANT0 + (antIndex * RX_SYS_GAIN_ANT_OFFSET)), &tempVal);
#endif
		sysGain[antIndex] = (int32)(tempVal & RX_SYS_GAIN_MASK);

		// 2's complement (8 bit)
		SIGN_EXTEND(sysGain[antIndex], 8);
		
#ifdef DUT_LOGS_ON
		ILOG0_DD("dutHwAccessGetRxGains, sysGain[%d] = 0x%x", antIndex, sysGain[antIndex]);
#endif
	}

	for(antIndex = ANTENNA_0; antIndex < MAX_NUM_OF_ANTENNAS; antIndex++)
	{
#if defined (ENET_INC_ARCH_WAVE600)		
		RegAccess_Read((B0_PHY_RX_TD_BASE_ADDR + BACKOFF_TO_DBM_OFFSET_ANT0 + (antIndex * BACKOFF_TO_DBM_OFFSET_ANT_OFFSET)), &tempVal);
#else
		RegAccess_Read((PHY_TD_BASE_ADDR + BACKOFF_TO_DBM_OFFSET_ANT0 + (antIndex * BACKOFF_TO_DBM_OFFSET_ANT_OFFSET)), &tempVal);
#endif

		backoffToDbmOffset = (int32)(tempVal & BACKOFF_TO_DBM_OFFSET_MASK);

		// 2's complement (6 bit)
		SIGN_EXTEND(backoffToDbmOffset, 6);

#ifdef DUT_LOGS_ON
		ILOG0_D("dutHwAccessGetRxGains, backoffToDbmOffset = 0x%x", backoffToDbmOffset);
#endif

		rxGains_p->antRxGains[antIndex].bbGain = sysGain[antIndex] - backoffToDbmOffset;
		rxGains_p->antRxGains[antIndex].type = 1;

#ifdef DUT_LOGS_ON
		ILOG0_DD("dutHwAccessGetRxGains, rxGains_p->antRxGains[%d].bbGain = 0x%x", antIndex, rxGains_p->antRxGains[antIndex].bbGain);
#endif
	}

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutRficRxGainsParams_t, rxGains_p);
#endif

	PhyDrv_StartRisc();

}

/*********************************************************************************
Method:			dutHwAccessGetXtalValue
Description:  
Parameter:    	IN dutXtalParams_t * xtalParams
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessGetXtalValue(OUT dutXtalParams_t *xtalParams)
{
    // Stop RISC to use the IndirectAccess interface
	dutResetBb();
    
    LmHdk_GetXtalValue(&xtalParams->xtalValue);

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutXtalParams_t, xtalParams);
#endif
	
    // Restart RISC
	dutStartBb();
}
/*********************************************************************************
Method:			dutHwAccessSetXtalValue
Description:  
Parameter:    	dutXtalParams_t * 
Parameter:    	dutMessage->data
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessSetXtalValue(IN dutXtalParams_t *xtalParams)
{
    // Stop RISC to use the IndirectAccess interface
	dutResetBb();

#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutXtalParams_t, xtalParams);
#endif

    LmHdk_SetXtalValue(xtalParams->xtalValue);

    // Restart RISC
	dutStartBb();
}

/*********************************************************************************
Method:			dutHwAccessGetLnaParams
Description:  
Parameter:    void
Returns:      	OUT dutLnaParam_t * LnaParams
Remarks:		None
*********************************************************************************/
 void dutHwAccessGetLnaParams(OUT dutLnaParam_t * LnaParams)
{
	UNUSED_PARAM(LnaParams);	
//	LmHdk_GetExtLnaParams(&LnaParams->extLNAbypass, &LnaParams->extLNAhigh);
}

/*********************************************************************************
Method:			dutHwAccessSetLnaParams
Description:  
Parameter:    IN dutLnaParam_t * LnaParams
Returns:      	void
Remarks:		None
*********************************************************************************/
 void dutHwAccessSetLnaParams(IN dutLnaParam_t * LnaParams)
{
	UNUSED_PARAM(LnaParams);
//	LmHdk_SetExtLnaParams(LnaParams->extLNAbypass, LnaParams->extLNAhigh);
}

/*********************************************************************************
Method:			dutHwAccessReadMemory
Description:  
Parameter:    	OUT dutMemoryAccessParams_t * memoryAccessParams
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutHwAccessReadMemory(OUT dutMemoryAccessParams_t *memoryAccessParams)
{
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutMemoryAccessParams_t, memoryAccessParams);
#endif
	
	switch(memoryAccessParams->module)
	{
	case DUT_CHIP_MODULE_LMAC_MEM:
	case DUT_CHIP_MODULE_UMAC_MEM:
		MEMCPY((void *)memoryAccessParams->data,(void *)memoryAccessParams->address,memoryAccessParams->length);
		break;
	case DUT_CHIP_MODULE_PHY:
		// We must read the phy word aligned and in word at a time (not Byte)
		DEBUG_ASSERT(!((memoryAccessParams->address)%4));
		memcpy32((void *)memoryAccessParams->data,(void *)memoryAccessParams->address,(memoryAccessParams->length + 4)/4);
		break;
	case DUT_CHIP_MODULE_RF:
		dutResetBb();
#if !defined (ENET_INC_HW_FPGA)
		RficDriver_ReadRegister(memoryAccessParams->address,(uint16*)memoryAccessParams->data);
#endif
		dutStartBb();
		break;
	case DUT_CHIP_MODULE_AFE:
		dutResetBb();
#if !defined HDK_INTERMEDIATE_UNTIL_API_MERGE////PHYTBD: open after merge with CDB and API lignment 
		AFE_ReadRegister(memoryAccessParams->address,(uint16*)memoryAccessParams->data);
#endif
		dutStartBb();
		break;
	default:
		DEBUG_ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code
		break;
	}
}

/*********************************************************************************
Method:			dutHwAccessWriteMemory
Description:  
Parameter:    	IN dutMemoryAccessParams_t * memoryAccessParams
Returns:      	void
Remarks:		None
*********************************************************************************/
void dutHwAccessWriteMemory(IN dutMemoryAccessParams_t *memoryAccessParams)
{
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutMemoryAccessParams_t, memoryAccessParams);
#endif
		
	switch(memoryAccessParams->module)
	{
	case DUT_CHIP_MODULE_UMAC_MEM:
	case DUT_CHIP_MODULE_LMAC_MEM:
		MEMCPY((void *)memoryAccessParams->address,(void *)memoryAccessParams->data,memoryAccessParams->length);
		break;
	case DUT_CHIP_MODULE_PHY:
		// We must read the phy word aligned and in word at a time (not Byte)
		DEBUG_ASSERT(!((memoryAccessParams->address)%4));
		memcpy32((void *)memoryAccessParams->address,(void *)memoryAccessParams->data,(memoryAccessParams->length + 4)/4);
		break;
	case DUT_CHIP_MODULE_RF:
		dutResetBb();
#if !defined (ENET_INC_HW_FPGA)
		RficDriver_WriteRegister(memoryAccessParams->address,(uint16 *)memoryAccessParams->data);
#endif
		dutStartBb();
		break;
	case DUT_CHIP_MODULE_AFE:
		break;
	default:
		DEBUG_ASSERT(0); //klocwork ignore, UNREACH.GEN..... All the cases in the ENUM is handled, klockwork sees this assert as unreachable code
		break;
	}
}


/*********************************************************************************
Method:			dutHwAccessGetTxPowerFeedbackReq
Description:	Reads the TPC feedback table- TSSI
Parameter:    	OUT dutTpcFeedbackparams_t * tpcFeedback
Returns:      	void
Remarks:		None
*********************************************************************************/

void dutHwAccessReadTxPowerFeedBack(uint8 forceConfirm) 
{
	uint16 validSamples = 0;
	uint16 voltageMeasure =0;
	uint8 powerIndex, ant;
	dutTpcFeedbackparams_t* tpcFeedbackParams = NULL;
	dutDB_t *dutDB_p = Dut_getDB();
	Bandwidth_e bw = HDK_getChannelWidth();
	uint8 txEnabledAntennas = dutDB_p->txAntEnableMask;
	uint8 firstAnt;

	if (dutDB_p->TxPowerFeedbackRequested == TRUE)
	{
	
		if(isTxPowerVectorOn == FALSE)
		{
			dutMessage_t *dutMessage_p = (dutMessage_t *)pK_MSG_DATA(dutDB_p->savedDutMsg_p);
			DEBUG_ASSERT(dutDB_p->savedDutMsgId == DUT_GET_TX_POWER_FEEDBACK_REQ);
			tpcFeedbackParams = (dutTpcFeedbackparams_t *)dutMessage_p->data;
				
		}
		
		TPC_GetTxPowerIndex(bw, &powerIndex);// not relevant for gen5
#if !defined (ENET_INC_HW_FPGA)		
		validSamples = PhyCalDrv_GetValidTpc(); // for gen5 all bits are valid
#endif		
#ifdef DUT_LOGS_ON
		ILOG0_DDDD("dutHwAccessReadTxPowerFeedBack, powerIndex:%x, validSamples:0x%x, txEnabledAntennas:0x%x, phyBw:%d", powerIndex, validSamples, txEnabledAntennas, bw);
#endif
		if (validSamples & (1 << powerIndex))
		{
			for (ant = 0; ant < MAX_NUM_OF_ANTENNAS; ant++)
			{
				if ((1 << ant) & txEnabledAntennas)
				{
#if !defined (ENET_INC_HW_FPGA)
					voltageMeasure = PhyCalDrv_GetFeedBackTpc(powerIndex, ant);
#endif
					ILOG2_DD("dutHwAccessReadTxPowerFeedBack, ant:%d, voltageMeasure:%d", ant, voltageMeasure);
					if(isTxPowerVectorOn == FALSE)
					{
						
						tpcFeedbackParams->valueSum[ant] += voltageMeasure;
					}
					else
					{
						measuredVoltagePowerVector->measuredVector[ant][PVpowerToTransmitIndex] += voltageMeasure;
						ILOG2_DD("voltageMeasure, voltageMeasure:%d , ant = %d", voltageMeasure,ant);
					}
				}
			}

			dutDB_p->failedTxPowerFeedbackReadAttempts = 0;
#if !defined (ENET_INC_HW_FPGA)			
			PhyCalDrv_ResetValidTpc();
#endif
			if(isTxPowerVectorOn == FALSE)
			{
				tpcFeedbackParams->actualNumOfSamples++;
			}
		}
		else
		{
			dutDB_p->failedTxPowerFeedbackReadAttempts++;
		}
		if(isTxPowerVectorOn == FALSE)
		{
			if ((tpcFeedbackParams->actualNumOfSamples >= tpcFeedbackParams->numOfSamples) ||
				(dutDB_p->failedTxPowerFeedbackReadAttempts >= DUT_POWER_FB_READ_ATTEMPTS_PER_SAMPLE)||
				(TRUE == forceConfirm))
			{
				// In case there were no valid samples set numOfSamples to  0, than caller can identify a problem
	//			if (dutDB_p->failedTxPowerFeedbackReadAttempts >= DUT_POWER_FB_READ_ATTEMPTS_PER_SAMPLE)
	//			{
	//#ifdef DUT_LOGS_ON
	//				ILOG0_V("dutHwAccessGetTxPowerFeedback Failed to Read Feedback");
	//#endif
	//				tpcFeedbackParams->actualNumOfSamples = 0;
	//			}
				firstAnt = PSD_findFirstAntInMask(Hdk_GetTxAntMask());
				tpcFeedbackParams->valueGain = TPC_getPowerIndexValue(0, (Antenna_e)firstAnt, bw);

#ifdef DUT_LOGS_ON
				SLOG0(0, 0, dutTpcFeedbackparams_t, tpcFeedbackParams);
#endif

				dutDB_p->TxPowerFeedbackRequested = FALSE;

				OSAL_SEND_NO_DATA_MESSAGE(DUT_MSG_CFM, TASK_DUT, dutDB_p->vapIndex);
			}
		}
	}
}


void dutReadRfGainsFromPhy(dutRficTxGainsParams_t *dutRficTxGainsParams_p)
{
	PhyDrv_StopRisc();
#if !defined (ENET_INC_HW_FPGA)	
	RficDriver_GetTxGain(dutRficTxGainsParams_p);
#endif	
	PhyDrv_StartRisc();
	
#ifdef DUT_LOGS_ON
	SLOG0(0, 0, dutRficTxGainsParams_t, dutRficTxGainsParams_p);
#endif
}

void dutHwAccessTPCtableOffset(dutPoutTableOffsetParams_t *dutPoutTableOffsetParams_p, uint8 setGet)
{
	TPC_setGetTxTableOffset(dutPoutTableOffsetParams_p->antNum, dutPoutTableOffsetParams_p->bw, &dutPoutTableOffsetParams_p->tableOffset, setGet );
}

void dutHwAccessRxEnableAggregate (dutRxEnableAggregate_t* EnableAggregate)
{
	uint8 enableNonAggregate;
	EnableAggregate_global = EnableAggregate->aggregate;
	if (TRUE == EnableAggregate->aggregate)
		enableNonAggregate = FALSE;
	else
		enableNonAggregate = TRUE;
	PhyDrv_SetVhtNonAggregate(enableNonAggregate);
}




